#include <stdlib.h>
#include <string.h>
#include "DrawBack.h"
#include "viewer_types.h"

SchedDefineTask(DrawBack);

static void
linebuf_init(int *buf, int x, int rgb)
{
    for (int i = 0; i < x; i++) {
	buf[i] = rgb;
    }
}

static int
run(SchedTask *smanager, void *rbuf, void *wbuf)
{
    int rgb          = (long)smanager->get_param(0);
    int rangex_start = (long)smanager->get_param(1);
    int rangex_end   = (long)smanager->get_param(2);
    int rangey       = (long)smanager->get_param(3);
    int rangex       = rangex_end - rangex_start + 1;
    int *linebuf;

    for (int i = 0; i < rangey; i++) {
	linebuf = (int*)smanager->get_output(i);
	linebuf_init(linebuf, rangex, rgb);
    }

    return 0;
}
