#include <stdio.h>
#include <string.h>
#include <math.h>
#include "universe_move.h"
#include "Func.h"
#include "types.h"

/* これは必須 */
SchedDefineTask(UniverseTask);

typedef struct {
    float xyz[3];
    float angle[3];
    float stack_xyz[3];
    int property_index;
    int parent_index;
    int have_parent;
    memaddr parent;
    memaddr children;
    memaddr node;
    const char *name;
} *PropertyPtr, Property;

static int
run(SchedTask *s,void *rbuf, void *wbuf)
{
    PropertyPtr	property	= (PropertyPtr)s->get_input(rbuf, 0);
    PropertyPtr	update_property = (PropertyPtr)s->get_output(wbuf, 0);
    int screen_w = 1920;
    int screen_h = 1080;

    property[0].angle[1] += 1.0f;
    if (property[0].angle[1] > 360.0f) {
	property[0].angle[1] = 0.0f;
    }

    property[0].xyz[0] += property[0].stack_xyz[0];
    if ((int)property[0].xyz[0] > screen_w || (int)property[0].xyz[0] < 0) {
	property[0].stack_xyz[0] = -property[0].stack_xyz[0];
    }

    property[0].xyz[1] += property[0].stack_xyz[1];
    if ((int)property[0].xyz[1] > screen_h || (int)property[0].xyz[1] < 0) {
	property[0].stack_xyz[1] = -property[0].stack_xyz[1];
    }

    memcpy((void*)update_property, (void*)property, sizeof(Property)*2);

    return 0;
}
