#include "sgchangeSDL.h"
#include "Func.h"
#include "TaskManager.h"

extern void post2runLoop(void *);

extern

void
SgChangeSDL::video_init(TaskManager *manager)
{
    Uint32 sdl_flag = default_sdl_flag | SDL_INIT_VIDEO;
    Uint32 *p;

    if (SDL_Init(sdl_flag) < 0) {
	fprintf(stderr,"Couldn't initialize SDL: %s\n", SDL_GetError());
	exit(1);
    }

    screen = SDL_SetVideoMode(width, height, bpp, SDL_SWSURFACE);
    if (screen == NULL) {
	fprintf(stderr, "Couldn't set GL mode: %s\n", SDL_GetError());
	SDL_Quit();
	exit(1);
    }
    
    p = (Uint32*)manager->allocate(screen->pitch*height);
    bitmap = SDL_CreateRGBSurfaceFrom((void *)p,
				      screen->w, screen->h,
				      screen->format->BitsPerPixel,
				      screen->pitch,
				      redMask, greenMask, blueMask, alphaMask);

    pixels = p;
}

void
SgChangeSDL::clean_pixels()
{
    //bzero(pixels, sizeof(int)*width*height);
    SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0,0,0));
}

void
SgChangeSDL::run_loop(HTaskPtr task_next)
{
    SDL_BlitSurface(bitmap, NULL, screen, NULL);
    SDL_UpdateRect(screen, 0, 0, 0, 0);        

    SgChange::run_loop(task_next);
}

void
SgChangeSDL::run_finish()
{
    free(bitmap->pixels);
    SDL_FreeSurface(bitmap);

    SgChange::run_finish();
}
