#ifndef INCLUDED_SCENE_GRAPH_PACK
#define INCLUDED_SCENE_GRAPH_PACK

#include "SceneGraph.h"

#include "types.h"

#define MAX_NODE 16
#define MAX_POLYGON 36

typedef struct SceneGraphNode {
    int size; // この Node で使ってるポリゴンの数、でいいのかな
    float vertex[MAX_POLYGON*3];
    float texture[MAX_POLYGON*2];
    float obj_pos[4];
    float angle[4];
    float translation[16];
    uint32 *tex_addr;
    int tex_width, tex_height;
    int id;
    int move, interaction;
    int pn; // parent number?
    SceneGraphNode *next;
    int pad[3];
    SceneGraphPtr self;
    SceneGraphPtr tree;

    void init(void) {
	size = 0;
	next = 0;
    }

    void finish(void) {
	SceneGraphNode *p = this->next, *p1;

	while (p) {
	    p1 = p->next;
	    free(p);
	    p = p1;
	}
    }
}SceneGraphNode, *SceneGraphNodePtr;

typedef struct SceneGraphInfo {
    int size;
    int pad[2];
}SceneGraphInfo;

typedef struct SceneGraphPack {
    SceneGraphInfo info;
    SceneGraphNode node[MAX_NODE];
    SceneGraphPack *next;

    void init(void){
	next = 0;
	info.size = 0;

	for (int i = 0; i < MAX_NODE; i++) {
	    node[i].size = 0;
	}
    }

    void finish(void) {
	for (int i = 0; i < info.size; i++) {
	    node[i].finish();
	}

	next = 0;
	info.size = 0;
    }
} SceneGraphPack, *SceneGraphPackPtr;

#endif
