#include "TaskManager.h"
#include "viewer.h"
#include "viewerSDL.h"
#include "viewerFB.h"
#include "viewerGL.h"
#include "viewerPS3.h"
#include "viewerNONE.h"
#include "Application.h"

/* prototype */
extern int init(TaskManager *manager, int argc, char *argv[]);

extern void task_initialize();
extern Application *application();
extern int init(TaskManager *manager, int argc, char *argv[]);

// 大域変数は禁止
//static Viewer *screen;

/*
const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n\
  -cpu Number of SPE (default 1)\n\
  -width, -height window size (default 640x480), -bpp bits per pixcel\n\
  -video {sdl|fb}   in case of frame buffer, width,height,bpp is automatically set\n\
  \n";
 */

int
init(TaskManager *manager, int argc, char *argv[])
{
    int bpp    = 32;
    int width  = 640;
    int height = 480;
    int spenum = 1;
    video_type vtype = VTYPE_SDL;

    int mem_flag = 0;
    int profile = 0;

    for(int i = 1; argv[i]; ++i)
    {
	if (strcmp(argv[i], "-bpp") == 0) {
	    bpp = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-width") == 0) {
	    width = atoi(argv[++i]);
	} 
	if (strcmp(argv[i], "-height") == 0) {
	    height = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-cpu") == 0) {
	    spenum = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-p") == 0) {
            profile = 1;
        }
	if (strcmp(argv[i], "-video") == 0) {
	    if (strcmp(argv[i+1], "sdl") == 0) { 
		vtype = VTYPE_SDL;
	    } else if (strcmp(argv[i+1], "fb") == 0) {
		vtype = VTYPE_FB;
	    } else if  (strcmp(argv[i+1], "gl") == 0) {
	      vtype = VTYPE_GL;
	    } else if  (strcmp(argv[i+1], "ps3") == 0) {
	      vtype = VTYPE_PS3;
	    } else if  (strcmp(argv[i+1], "sdl") == 0) {
	      vtype = VTYPE_SDL;
	    } else if (strcmp(argv[i+1], "none") == 0) {
	      vtype = VTYPE_NONE;
	    }
	    i++;
	}
	if (strcmp(argv[i], "-mem") == 0) {
	  mem_flag = 1;
	}
    }

    Viewer *screen;
    if (vtype == VTYPE_SDL) {
	ViewerDevice *dev = new ViewerSDL(manager);
	screen = new Viewer(manager, dev, bpp, width, height, spenum);
    } else if (vtype == VTYPE_FB) {
	ViewerDevice *dev = new ViewerFB(manager);
	screen = new Viewer(manager, dev, bpp, width, height, spenum);
    } else if (vtype == VTYPE_GL) {
        screen = new ViewerGL(manager, bpp, width, height, spenum);
    } else if (vtype == VTYPE_PS3) {
        ViewerDevice *dev = new ViewerPS3();
	screen = new Viewer(manager, dev, bpp, width, height, spenum);
    } else if (vtype == VTYPE_NONE) {
	ViewerDevice *dev = new ViewerNONE(manager);
	screen = new Viewer(manager, dev, bpp, width, height, spenum);
    } else {
	ViewerDevice *dev = new ViewerSDL(manager);
	screen = new Viewer(manager, dev, bpp, width, height, spenum);
   }    
    screen->mem_flag = mem_flag;
    screen->profile = profile;
    screen->run_init(manager, application());

    return 0;
}

#if 0

// These are defined in Application

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
}

#endif

/* end */
