/*  $Id$ */

/*----------------------------------------------------------------------
  マクロ定義
----------------------------------------------------------------------*/

#define FAIL            (-1)

#define PS_DEB          0xf8

#define MAX_QUEUE       1024

#define INT_SIZE    4     // Byte = sizeof(int)

#define LDSERV_PORT     11511

/*----------------------------------------------------------------------
 パケットフォーマット
 char     short  int    int
 Mode +   ID   + Seq  + Data_len + Padding + Data
 0        1      3      7          11        12
----------------------------------------------------------------------*/

#define LINDA_MODE_OFFSET          0
#define LINDA_ID_OFFSET            1
#define LINDA_SEQ_OFFSET           3
#define LINDA_DATA_LENGTH_OFFSET   7
#define LINDA_HEADER_SIZE          12

/*----------------------------------------------------------------------
  構造体定義
----------------------------------------------------------------------*/
typedef struct psx_reply{
    unsigned char *answer;
    unsigned int seq;
    struct psx_reply *next;
    char mode;
    void(*callback)(unsigned char * tuple, void * obj);
    void * obj;
} REPLY;
          
typedef struct command_queue{
    struct command_queue *next;
    unsigned int tspace_id;        /* ID of destination Tuple Space */
    unsigned int size;
    unsigned char *command;
} COMMAND;


/*----------------------------------------------------------------------
  Linda API
----------------------------------------------------------------------*/

extern void init_linda(void);
extern int open_linda(const char *hostname, int port);
extern int open_linda_java(const char *hostname, int port);
extern int close_linda(int tspace_id);

extern void psx_free(void*);

extern unsigned char *psx_reply(unsigned int seq);
extern void psx_sync_n(void);
extern void psx_sync_n_timeout(int time);
extern unsigned int psx_get_datalength(unsigned char *);
extern unsigned int psx_get_seq(unsigned char *);
extern unsigned short psx_get_id(unsigned char *);
extern unsigned char psx_get_mode(unsigned char *);
extern unsigned char * psx_get_data(unsigned char *);

extern int psx_out(unsigned int tspace_id, unsigned int id,
                   unsigned char *data, unsigned int size);
extern int psx_callback_update(unsigned int tspace_id, unsigned int id,
							   unsigned char *data, unsigned int size,
							   void(*callback)(unsigned char *,void *),void * obj);
extern int psx_ld(unsigned int tspace_id, unsigned int id,
                  char mode, void(*callback)(unsigned char *,void *),void * obj);

#define psx_in(tid, id)      psx_ld(tid, id, 'i', NULL, NULL)
#define psx_rd(tid, id)      psx_ld(tid, id, 'r', NULL, NULL)
#define psx_ck(tid, id)      psx_ld(tid, id, 'c', NULL, NULL)
#define psx_wait_rd(tid, id) psx_ld(tid, id, 'w', NULL, NULL)
#define psx_update(tid, id, data, size) psx_callback_update(tid, id, data, size, NULL, NULL)

#define psx_callback_in(tid, id,callback,obj)      psx_ld(tid, id, 'i', callback, obj)
#define psx_callback_rd(tid, id,callback,obj)      psx_ld(tid, id, 'r', callback, obj)
#define psx_callback_ck(tid, id,callback,obj)      psx_ld(tid, id, 'c', callback, obj)
#define psx_callback_wait_rd(tid, id,callback,obj) psx_ld(tid, id, 'w', callback, obj)
