#ifndef INCLUDED_VIEWER_DEV
#define INCLUDED_VIEWER_DEV

#include "TaskManager.h"
#include "SDL.h"

class ViewerDevice {
public:
    ViewerDevice();    
    virtual ~ViewerDevice();

    ViewerDevice(TaskManager *m) {};

    int width;
    int height;
    int bpp;

    /* override function */
    virtual Uint32 *video_init(TaskManager *manager, int bpp, int width, int height) = 0;
    virtual Uint32 * flip_screen(Uint32 *v) { return v; }
    virtual void clean_pixels() = 0;
    virtual void clear_screen() = 0;
    virtual void free_device() = 0;    
};

#endif
