#include "TaskManager.h"
#include "SgChange.h"
#include "sgchangeSDL.h"
#include "sgchangeFB.h"
#include "Application.h"

/* prototype */
extern void task_initialize();
extern Application *application();
extern int sg_init(TaskManager *manager, int argc, char *argv[]);

int
sg_init(TaskManager *manager, int argc, char *argv[])
{
    int bpp    = 32;
    int width  = 640;
    int height = 480;
    int spenum = 1;
    video_type vtype = VTYPE_SDL;

    for(int i = 1; argv[i]; ++i)
    {
	if (strcmp(argv[i], "-bpp") == 0) {
	    bpp = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-width") == 0) {
	    width = atoi(argv[++i]);
	} 
	if (strcmp(argv[i], "-height") == 0) {
	    height = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-cpu") == 0) {
	    spenum = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-video") == 0) {
	    if (strcmp(argv[i+1], "sdl") == 0) { 
		vtype = VTYPE_SDL;
	    } else if (strcmp(argv[i+1], "fb") == 0) {
		vtype = VTYPE_FB;
	    }
	    i++;
	}
    }

    /*
    SgChange *screen = new SgChange(bpp, width, height, spenum);
    screen->run_init(manager, application());
    */

    SgChange *screen;
    if (vtype == VTYPE_SDL) {
	screen = new SgChangeSDL(manager, bpp, width, height, spenum);
    } else if (vtype == VTYPE_FB) {
	screen = new SgChangeFB(manager, bpp, width, height, spenum);
    }else{
	screen = new SgChangeSDL(manager, bpp, width, height, spenum);
    }    

    screen->video_init(manager);
    screen->run_init(manager, application());

    return 0;
}

#if 0

// These are defined in Application

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

#endif

/* end */
