#ifndef INCLUDED_CAMERA
#define INCLUDED_CAMERA

#include "SceneGraph.h"

class SceneGraphRoot;

class Camera : public SceneGraph {
public:
    //Camera(float w = 640, float h = 480, SceneGraphRoot *sgroot);
    Camera(float w, float h, SceneGraphRoot *sgroot, TaskManager *manager);
    ~Camera(void);    

    SceneGraphRoot *sgroot;

    float zd[4]; // direction z
    float yd[4]; // direction y
    float fov;
    float near;
    float far;

    float *m_view;
    float *m_pers;
    float *m_screen;

    void updateView(void);
    void updatePerspective(float w, float h);
    void updateScreen(float w, float h);

    void setCamera(float *pose);
    void update(float screen_w, float screen_h);

    //void camera_move(SceneGraphPtr _node, int screen_w, int screen_h);
};

typedef Camera *CameraPtr;

#endif
