#include <stdio.h>
#include <stdlib.h>
#include "types.h"
#include "DmaBuffer.h"

#define ALIGN_DOWN(v, align) ((v)&(-align))
#define ALIGN_UP(v, align)   ALIGN_DOWN((v)+((align)-1), align)


DmaBuffer::DmaBuffer(int size)
{
#ifndef HAS_POSIX_MEMALIGN
    buffer[0] = malloc(size);
    buffer[1] = malloc(size);
#else
    posix_memalign(&buffer[0],64,size);
    posix_memalign(&buffer[1],64,size);
#endif
    flag = 0;
}

DmaBuffer::~DmaBuffer(void)
{
    free(buffer[0]);
    free(buffer[1]);
}

void
DmaBuffer::swap_buffer(void)
{
    flag ^= 1;
}

void
DmaBuffer::get_buffer(void *_dst)
{
    void **dst = (void**)_dst;
    *dst = buffer[flag];
}
