#ifndef INCLUDED_SPE_TASK_MANAGER_IMPL
#define INCLUDED_SPE_TASK_MANAGER_IMPL

#include "TaskManagerImpl.h"
#include "MainScheduler.h"
#include "Scheduler.h"

class SpeTaskManagerImpl : public TaskManagerImpl {
public:
    /* constructor */
    BASE_NEW_DELETE(SpeTaskManagerImpl);

    SpeTaskManagerImpl() ;
    ~SpeTaskManagerImpl();

    /* functions */
    // call by system
    void init(int spuIdle);
    void run();
    void start_profile();
    void show_profile();
    HTaskPtr create_task(int cmd);
    HTaskPtr create_task(int cmd, memaddr rbuf, long r_size, memaddr wbuf, long w_size);
    HTaskPtr create_task_array(int cmd, memaddr rbuf, long rs, memaddr wbuf, long ws);
    void set_task_depend(HTaskPtr master, HTaskPtr slave);
    void spawn_task(HTaskPtr);
    void set_task_cpu(HTaskPtr, CPU_TYPE);
    void polling() {}
    void free_htask(HTaskPtr htask) {}
    void print_arch();

}  ;


#endif /* INCLUDED_SPE_TASK_MANAGER_IMPL */
