/****************************************************************************
    NUT3W Numbering software for BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/// nu3wDlg.cpp : t@C
//

#include "stdafx.h"
#include "nu3w.h"
#include "nu3wDlg.h"
//#include ".\nu3wdlg.h"
#include "SNut.h"
#include "DdLb.h"
#include ".\nu3wdlg.h"
#include "cmdlineparam.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define FILE_NAME_BUFFER_SIZE (_MAX_PATH * 64  + 1)

// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnInitDialog();
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// Cnu3wDlg _CAO



Cnu3wDlg::Cnu3wDlg(CWnd* pParent /*=NULL*/)
	: CDialog(Cnu3wDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_noMessageBox = FALSE;
}

void Cnu3wDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_SRC, m_lbSrc);
}

BEGIN_MESSAGE_MAP(Cnu3wDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
//	ON_BN_CLICKED(ID_REF, OnBnClickedRef)
	ON_BN_CLICKED(ID_CLR, OnBnClickedClr)
	ON_BN_CLICKED(ID_REF, OnBnClickedRef)
	ON_LBN_SELCHANGE(IDC_LIST_SRC, OnLbnSelchangeListSrc)
	ON_BN_CLICKED(ID_DOWN, OnBnClickedDown)
	ON_BN_CLICKED(ID_UP, OnBnClickedUp)
	ON_BN_CLICKED(IDC_CHECK_ENABLE_PREFIXFILTER, &Cnu3wDlg::OnBnClickedCheckEnablePrefixfilter)
//	ON_BN_CLICKED(IDC_RADIO_DONT, &Cnu3wDlg::OnBnClickedRadioDont)
ON_BN_CLICKED(IDC_NEWLYONLY, &Cnu3wDlg::OnBnClickedNewlyonly)
END_MESSAGE_MAP()


// Cnu3wDlg bZ[W nh

BOOL Cnu3wDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	HICON hIcon=AfxGetApp()->LoadIcon(IDI_SMALL);
	SetIcon(hIcon, FALSE);		// ACRݒ

	//SetIcon(m_hIcon, FALSE);		// ACR̐ݒ



	// TODO: ɒǉ܂B
	CDdLb* pLB=(CDdLb*)GetDlgItem(IDC_LIST_SRC);
	const CStringList& strListSrcFiles=((Cnu3wApp*)AfxGetApp())->m_cmdInfo.m_strListSrcFiles;
	POSITION pos = strListSrcFiles.GetHeadPosition();
	while(pos){
		CString fileName = strListSrcFiles.GetNext(pos);
		pLB->AddString(fileName);
	}




	setButtonEnable();
	int n;
	CSpinButtonCtrl* pSpin=(CSpinButtonCtrl*)GetDlgItem(IDC_SPIN_INIT);
	pSpin->SetRange(1,PARTNUM_INIT_MAX);
	n=((Cnu3wApp*)AfxGetApp())->m_cmdInfo.m_initNum;
	if(n<0)n=1;
	else if(n>PARTNUM_INIT_MAX) n=PARTNUM_INIT_MAX;
	pSpin->SetPos(n);
	pSpin=(CSpinButtonCtrl*)GetDlgItem(IDC_SPIN_STEP);
	pSpin->SetRange(1,PARTNUM_STEP_MAX);
	n=((Cnu3wApp*)AfxGetApp())->m_cmdInfo.m_stepNum;
	if(n<0)n=1;
	else if(n>PARTNUM_STEP_MAX) n=PARTNUM_STEP_MAX;
	pSpin->SetPos(n);

	/////////////////////////////////////////////////////
	//  `FbN{bNX̐ݒ
	n=((Cnu3wApp*)AfxGetApp())->m_cmdInfo.m_flag3sAutoNum;
	CButton* pCheck=(CButton*)GetDlgItem(IDC_ANUM);
	pCheck->SetCheck(n>0);

	if(((Cnu3wApp*)AfxGetApp())->m_cmdInfo.m_forceExecute){
		m_noMessageBox=TRUE;
		OnOK();
		EndDialog(IDOK);
	}

	((CButton*)GetDlgItem(IDC_CHECK_ENABLE_PREFIXFILTER))->SetCheck(0);
	((CButton*)GetDlgItem(IDC_RADIO_DONT))->SetCheck(1);
	((CButton*)GetDlgItem(IDC_NEWLYONLY))->SetCheck(0);

	setPrefixFilterControlEnable();

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void Cnu3wDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void Cnu3wDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

//[U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR Cnu3wDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

//\[X̃Xg{bNX̏ԂŃ{^̃Cl[uԂݒ
void Cnu3wDlg::setButtonEnable()
{
	CButton* pButton;
	CDdLb* pLB=(CDdLb*)GetDlgItem(IDC_LIST_SRC);
	int nCount = pLB->GetCount();
	int nSelect = pLB->GetCurSel();
	pButton=(CButton*)GetDlgItem(IDOK);
	pButton->EnableWindow(nCount>0);
	pButton=(CButton*)GetDlgItem(ID_CLR);
	pButton->EnableWindow(nCount>0);
	pButton=(CButton*)GetDlgItem(ID_UP);
	pButton->EnableWindow(nCount>0 && nSelect!= LB_ERR && nSelect>0);
	pButton=(CButton*)GetDlgItem(ID_DOWN);
	pButton->EnableWindow(nCount>0 && nSelect!= LB_ERR && nSelect<nCount-1);
}

void Cnu3wDlg::OnOK()
{
	// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB

	SNut snut;

	CDdLb* pLB=(CDdLb*)GetDlgItem(IDC_LIST_SRC);
	int nCount = pLB->GetCount();
	if(nCount==0){
		return;
	}
	CString str;
	int readCount=0;
	for(int n=0;n<nCount;n++){
		CString msg;
		CString ldmsg;
		const char* pcsz;

		pLB->GetText(n,str);
		int retval=snut.readFile(str);
		switch(retval){
			case 1://łɓt@Cǂݍ݂
				break;
			case 2://ǂݍ݃G[
				break;
			case 3://G[ȂǐVBSch3Vōꂽf[^
				pcsz = snut.filename(snut.fileCount()-1);
				if(pcsz){
					msg = pcsz;
					msg += "\n";
					ldmsg.LoadString(IDS_LATERVERSION);
					msg += ldmsg;
					if(AfxMessageBox(msg,MB_OKCANCEL)==IDCANCEL){
						return;
					}
				}
				break;
			default:
				break;
		}
	}
	if(snut.fileCount()==0)return;

	snut.renameToBackup();

	int nInit=GetDlgItemInt(IDC_INIT);
	if(nInit<1 || nInit>PARTNUM_INIT_MAX){							//w͈͊OȂ
		SetDlgItemInt(IDC_INIT,1);									//ftHgl1ݒ肵
		AfxMessageBox(IDS_INIT_RANGE_ERR,MB_OK|MB_ICONINFORMATION);		//bZ[W{bNX\
		CEdit* pEdit=(CEdit*)GetDlgItem(IDC_INIT);
		pEdit->SetSel(0,-1);
		return;
	}
	int nStep=GetDlgItemInt(IDC_STEP);
	if(nStep<1 || nStep>PARTNUM_STEP_MAX){							//w͈͊OȂ
		SetDlgItemInt(IDC_STEP,1);									//ftHgl1ݒ肵
		AfxMessageBox(IDS_STEP_RANGE_ERR,MB_OK|MB_ICONINFORMATION);		//bZ[W{bNX\
		CEdit* pEdit=(CEdit*)GetDlgItem(IDC_STEP);
		pEdit->SetSel(0,-1);
		return;
	}
	snut.m_enablePrefixFilter = (((CButton*)GetDlgItem(IDC_CHECK_ENABLE_PREFIXFILTER))->GetCheck() == 1);
	snut.m_prefixFilterDontMode = (((CButton*)GetDlgItem(IDC_RADIO_DONT))->GetCheck()== 1);
	bool newlyOnly = (((CButton*)GetDlgItem(IDC_NEWLYONLY))->GetCheck()== 1);
	bool anumMode = newlyOnly || (((CButton*)GetDlgItem(IDC_ANUM))->GetCheck() == 1);

	CString filterString;
	GetDlgItem(IDC_EDIT_PREFIXFILTER)->GetWindowText(filterString);
	snut.setPrefixFilter(filterString);


	if(newlyOnly){
		snut.anumNewlyOnly();
	}else if(anumMode){
		snut.anum(nInit,nStep);
	}else{
		snut.renum(nInit,nStep);
	}
	snut.saveFiles();
	if(!m_noMessageBox){
		AfxMessageBox(IDS_FINISHED);
	}
	//CDialog::OnOK();
}


void Cnu3wDlg::OnBnClickedClr()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	CDdLb* pLB=(CDdLb*)GetDlgItem(IDC_LIST_SRC);
	int nCount = pLB->GetCount();
	if(nCount){
		int nSelect = pLB->GetCurSel();
		if(nSelect == LB_ERR) nSelect = 0;
		pLB->DeleteString(nSelect);
		nCount --;
		if(nCount>0){
			if(nSelect>=nCount)nSelect=nCount-1;
			if(nSelect>=0)pLB->SetCurSel(nSelect);
		}
	}	
	setButtonEnable();
}

void Cnu3wDlg::OnBnClickedRef()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	int nResult;
	char szNames[FILE_NAME_BUFFER_SIZE];
	strcpy(szNames,"*.CE3");

	CFileDialog dlg(TRUE,				//I[v_CAO
					NULL,				//gqtȂꍇ̃ftHg
					NULL,			//t@C
					OFN_HIDEREADONLY|OFN_FILEMUSTEXIST|OFN_ALLOWMULTISELECT,
					"BSch3 data(*.ce3)|*.CE3||",	//tB^
					this);				//eEChE
	
	dlg.m_ofn.lpstrFile = szNames;	//t@Ci[obt@ݒ肷B
	dlg.m_ofn.nMaxFile = FILE_NAME_BUFFER_SIZE;		//t@Ci[obt@̃TCYݒ肷B
	
	nResult=dlg.DoModal();			//t@C_CAO̎s
	if(nResult==IDOK){		//IȂc
		CDdLb* pLB=(CDdLb*)GetDlgItem(IDC_LIST_SRC);	//Xg{bNX擾āc
		//pLB->ResetContent();
		CString strPath;
		POSITION pos = dlg.GetStartPosition();
		int nSelect = pLB->GetCurSel();
		int nCount  = pLB->GetCount();
		if(nSelect==LB_ERR) nSelect=-1;
		while(pos){
			strPath = dlg.GetNextPathName(pos);				
			nSelect = pLB->InsertString(nSelect,strPath);	//Xg{bNXւ̃Zbg
			nSelect++;
		}
		pLB->SetListboxWidth();
	}
	setButtonEnable();

}

void Cnu3wDlg::OnLbnSelchangeListSrc()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	setButtonEnable();
}

void Cnu3wDlg::OnBnClickedDown()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	CString string;
	CDdLb* pLB=(CDdLb*)GetDlgItem(IDC_LIST_SRC);
	int nCount = pLB->GetCount();
	if(nCount>=2){
		int nSelect = pLB->GetCurSel();
		if(nSelect == LB_ERR || nSelect>=nCount -1) return;
		pLB->GetText(nSelect,string);
		pLB->DeleteString(nSelect);
		nCount--;
		nSelect++;
		if(nSelect>=nCount)nSelect=-1;
		nSelect=pLB->InsertString(nSelect,string);
		pLB->SetCurSel(nSelect);
	}	
	setButtonEnable();
}

void Cnu3wDlg::OnBnClickedUp()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	CString string;
	CDdLb* pLB=(CDdLb*)GetDlgItem(IDC_LIST_SRC);
	int nCount = pLB->GetCount();
	if(nCount>=2){
		int nSelect = pLB->GetCurSel();
		if(nSelect == LB_ERR || nSelect < 1) return;
		pLB->GetText(nSelect,string);
		pLB->DeleteString(nSelect);
		//nCount--;
		nSelect--;
		//if(nSelect>=nCount)nSelect=-1;
		nSelect=pLB->InsertString(nSelect,string);
		pLB->SetCurSel(nSelect);
	}	
	setButtonEnable();
}

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	CString msg;
	CString strVersion;
	strVersion.LoadString(IDS_VERSION);
	msg = "NUT3W Version ";
	msg += strVersion;
	SetDlgItemText(IDC_STATIC_VERSION,msg);


	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cnu3wDlg::OnBnClickedCheckEnablePrefixfilter()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	setPrefixFilterControlEnable();
}

void Cnu3wDlg::setPrefixFilterControlEnable()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	bool enable = (((CButton*)GetDlgItem(IDC_CHECK_ENABLE_PREFIXFILTER))->GetCheck()!=0);
	GetDlgItem(IDC_EDIT_PREFIXFILTER)->EnableWindow(enable);
	GetDlgItem(IDC_RADIO_DONT)->EnableWindow(enable);
	GetDlgItem(IDC_RADIO_ONLY)->EnableWindow(enable);
}



void Cnu3wDlg::OnBnClickedNewlyonly()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	bool enable = true;
	if(((CButton*)GetDlgItem(IDC_NEWLYONLY))->GetCheck()){
		SetDlgItemInt(IDC_INIT,1);
		SetDlgItemInt(IDC_STEP,1);
		((CButton*)GetDlgItem(IDC_ANUM))->SetCheck(1);
		enable = false;
	}
	GetDlgItem(IDC_ANUM)->EnableWindow(enable);
	GetDlgItem(IDC_INIT)->EnableWindow(enable);
	GetDlgItem(IDC_STEP)->EnableWindow(enable);

}
