/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2005 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

///////////////////////////////////////////////////////////////////
// BSch̃tHgNX
// bd̃tHgƓ̂̂g
//  Windows ̃tHggȂR
//      Ehbgł̔F̂₷
//      ẼT|[g
// ̃NXBSch̋NɂP쐬āAIɔjB
// ۂɂ́AO[oϐŊmۂ

#ifndef BSCHFONT_H
#define BSCHFONT_H

#include "draw.h"



class CBSchFont
{
private:
	int 			m_nBuffXByte;	//obt@̉TCYoCgŕ\
	int				m_nBuffXDot;	//obt@̉TCYhbgŕ\
	int 			m_nBuffYDot;	//obt@̏cTCYhbgŕ\
	char*			m_pString;		//ւ̃|C^
	int				m_nStrLen;		//̒
	unsigned char* 	m_pBmpBit;		//WJpobt@ւ̃|C^BRXgN^4096oCgm
	LOGFONT         m_logfontLabel;	
	CFont*			m_pFontHLabel;
	CFont*			m_pFontVLabel;
	int				m_VExt;
	int				m_WExt;
	int				m_vOffset;

	
private:
	void Init88Font();			//p̃tHg̍쐬
	

public:
	CBSchFont();		//RXgN^
	~CBSchFont();		//fXgN^B

	LOGFONT logfontLabel();
	void setLogFontLabel(LOGFONT lf);

	CSize PutFont(		//xtHg̕`
		CDC* pDC,				//o͐̃foCXReLXg
		int x,int y,			//o͈ʒu
		LPCSTR lpstr,			//o͕
		int nStrLen=-1,			//
		COLORREF col=RGB(255,255,255),	//o͐F
		UINT nMode=DRAW_ON,		//`惂[h
		BOOL bVert=FALSE,		//tO
		int  nPointPos=0,		//w肵o͈ʒu 0:̑O 1:̌ 2:̒
		int  nVExt=1,			//\{(View)
		int  nWExt=1,			//\{(Window)
		BOOL bUseUpperLine=TRUE);	//̎gp

	CSize PutWinFont(	//RgpWindowstHg̕`
		CDC* pDC,				//o͐̃foCXReLXg
		int x,int y,			//o͈ʒu
		LPCSTR lpstr,			//o͕
		int nStrLen,			//
		LOGFONT* plf,
		COLORREF col,			//o͐F
		UINT nMode,				//`惂[h
		BOOL bVert,				//tO
		int  nPointPos,	//w肵o͈ʒu 0:̑O 1:̌ 2:̒
										//					 0:̉ 4:̏   8:̒
		int  nVExt,				//\{(View)
		int  nWExt);			//\{(Window)

	static BOOL IniReadFontInfo(const char* sectionName, LPLOGFONT lplf,const char* defFont,int defHeight);
	static BOOL IniWriteFontInfo(const char* sectionName, LPLOGFONT lplf);

};

//////////////////////////////////////////////////////////////////////
//tHg֘A O[oϐE֐		Global.hړ
extern CBSchFont* g_pFont;	//̂ BSchFont.cpp

BOOL g_IniReadFontInfo(LPLOGFONT lplf);	//WXgRg̃ftHg̃tHg𓾂
BOOL g_IniWriteFontInfo(LPLOGFONT lplf);//WXgɃRg̃ftHg̃tHg

BOOL g_IniReadLabelFontInfo(LPLOGFONT lplf);//WXg烉x̃tHg𓾂
BOOL g_IniWriteLabelFontInfo(LPLOGFONT lplf);//WXgɃx̃tHg



#endif