/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// SetLib.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "BSch.h"
#include "SetLib.h"
#include "xbschglobal.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetLib _CAO


CSetLib::CSetLib(CWnd* pParent /*=NULL*/)
	: CDialog(CSetLib::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetLib)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CSetLib::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetLib)
                //  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetLib, CDialog)
	//{{AFX_MSG_MAP(CSetLib)
	ON_LBN_SELCHANGE(IDC_LIB_LIST, OnSelchangeLibList)
	ON_BN_CLICKED(IDC_LIB_UP, OnLibUp)
	ON_BN_CLICKED(IDC_LIB_DOWN, OnLibDown)
	ON_BN_CLICKED(IDC_LIB_ADD, OnLibAdd)
	ON_BN_CLICKED(IDC_LIB_DEL, OnLibDel)
	//}}AFX_MSG_MAP
	ON_WM_COPYDATA()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetLib o[֐Cvg

//_CAO\{^̃Cl[u
void CSetLib::EnableButton(UINT id,BOOL bEnable)
{
	CButton*  pBtn=(CButton*)GetDlgItem(id);
	// fBZ[u悤Ƃ{^ɃtH[JXꍇ
	// nj{^ɃtH[JXZbg
	if(!bEnable){
		CWnd* pWnd=GetFocus();
		if(pWnd==pBtn){
			CButton* pDefaultBtn=(CButton*)GetDlgItem(IDOK);
			pDefaultBtn->SetFocus();
		}
	}
	pBtn->EnableWindow(bEnable);
}

void CSetLib::SetListboxWidth()
{
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIB_LIST);
	CString rString;
	CDC* pDC;
	CSize textsize;
	int maxwidth=0;
	int i,n;
	pDC = pLB->GetDC();

	n = pLB->GetCount();
	for(i=0;i<n;i++){
		pLB->GetText(i,rString);
		textsize = pDC->GetTextExtent(rString);
		if(textsize.cx>maxwidth) maxwidth = textsize.cx;
	}
	pLB->SetHorizontalExtent(maxwidth);
	pLB->ReleaseDC(pDC);
}



/////////////////////////////////////////////////////////////////////////////
// CSetLib bZ[W nh

//WM_INITDIALOG bZ[Wnh
BOOL CSetLib::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIB_LIST);
	CString rString;
//	CDC* pDC;
	CSize textsize;
	char str[32];
	int i;
//	int maxwidth=0;



//	pDC = pLB->GetDC();
	//WXgɓo^ꂽCut@CXg{bNX֐ݒ
	for(i=0;i<MAX_LIB;i++){
		wsprintf(str,"LIB%d",i);			//Gg̍쐬
		rString=AfxGetApp()->GetProfileString("Library",str);
		if(rString.IsEmpty()) break;		//iCujlłȂbreak
		pLB->InsertString(-1,rString);		//Xg{bNX̍Ōɒǉ
//		textsize = pDC->GetTextExtent(rString);
//		if(textsize.cx>maxwidth) maxwidth = textsize.cx;
	}
	SetListboxWidth();


	m_nList=pLB->GetCount();				//o^̐ݒ
	EnableButton(IDC_LIB_ADD,m_nList<MAX_LIB);	//܂o^łȂΒǉ\Ȃ悤ɁuADDvCl[u
		
	EnableButton(IDC_LIB_DOWN,FALSE);		//uֈړv{^̓fBZ[u
	if(m_nList!=0){					//o^OłȂ
		pLB->SetCurSel(m_nList-1);			//Xg{bNẌԉ̍sɃJ[\ݒ
	}else{							//o^OȂ
		EnableButton(IDC_LIB_UP,  FALSE);	//uֈړvu폜vfBZ[u
		EnableButton(IDC_LIB_DEL, FALSE);
	}


	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

//IDOK(OK{^)̏
//WXgɃXg{bNX̓e
void CSetLib::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIB_LIST);
	CString rString;
	char str[32];
	int i,n;

	n=pLB->GetCount();							//Xg{bNXւ̓o^̎擾
	for(i=0;i<MAX_LIB;i++){
		if(i<n) pLB->GetText(i,rString);		//ws̃Cu̎擾
		else	rString.Empty();				//o^𒴂ꍇ͋󕶎ɂ
		wsprintf(str,"LIB%d",i);				//Gg̍쐬
		AfxGetApp()->WriteProfileString("Library",str,rString);//WXgւ̏
	}
	CDialog::OnOK();
}


//Cuۑ郊Xg{bNXŁAJ[\ړiIẮj
//ςꍇ̏
//uֈړvuֈړṽ{^̃Cl[uݒ
void CSetLib::OnSelchangeLibList() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIB_LIST);
	int n=pLB->GetCurSel();						//IĂʒu̎擾
	EnableButton(IDC_LIB_DOWN,n<m_nList-1);		//uցv{^̐ݒ
	EnableButton(IDC_LIB_UP  ,n>0);				//uցv{^̐ݒ
}


//Cuۑ郊Xg{bNXŁAIĂ̂uֈړv
//݂̈ʒu炢폜āAOɑ}
void CSetLib::OnLibUp() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIB_LIST);
	CString rString;
	int n=pLB->GetCurSel();			//IĂʒu̎擾
	if(n==LB_ERR || n==0) return;	//IĂ̂Ȃɐ擪̏ꍇ͉Ȃ
	pLB->GetText(n,rString);		//IĂ镶擾āc
	pLB->DeleteString(n);			//			Xg{bNX폜
	n--;							//ԍグāc
	pLB->InsertString(n,rString);	//			ǉāc
	pLB->SetCurSel(n);				//			J[\ݒ肵đIԂɂ
	EnableButton(IDC_LIB_DOWN,n<m_nList-1);		//uցv{^̐ݒ
	EnableButton(IDC_LIB_UP  ,n>0);				//uցv{^̐ݒ
}

//Cuۑ郊Xg{bNXŁAIĂ̂uֈړv
//݂̈ʒu炢폜āAOɑ}
void CSetLib::OnLibDown() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIB_LIST);
	CString rString;
	int n=pLB->GetCurSel();			//IĂʒu̎擾
	if(n==LB_ERR || n>=m_nList-1) return;	//IĂ̂ȂɍŌ̏ꍇ͉Ȃ
	pLB->GetText(n,rString);		//IĂ镶擾āc
	pLB->DeleteString(n);			//			Xg{bNX폜
	n++;							//ԍグāc
	pLB->InsertString(n,rString);	//			ǉāc
	pLB->SetCurSel(n);				//			J[\ݒ肵đIԂɂ
	EnableButton(IDC_LIB_DOWN,n<m_nList-1);		//uցv{^̐ݒ
	EnableButton(IDC_LIB_UP  ,n>0);				//uցv{^̐ݒ
}

//Cuւ̒ǉ
//t@C_CAON(*.LIB)sbNAbvđI
void CSetLib::OnLibAdd() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int nResult;
	if(m_nList>=MAX_LIB) return;	//łɓo^ȂȂɂȂ

	char szFileNameBuffer[_MAX_PATH *MAX_LIB+256];
	strcpy(szFileNameBuffer,"*.LB3");

	CFileDialog dlg(TRUE,				//I[v_CAO
					NULL,				//gqtȂꍇ̃ftHg
					NULL,			//t@C
					OFN_HIDEREADONLY|OFN_FILEMUSTEXIST|OFN_ALLOWMULTISELECT,
					"BSch Library(*.lb3)|*.LB3|BSch3 schematic(*.ce3)|*.CE3||",	//tB^
					this);				//eEChE
	
	CString rCaption;
	rCaption.LoadString(IDS_LIB_ADD_NEW);//_CAO{bNX̃LvV\[X烍[h
	dlg.m_ofn.lpstrTitle=rCaption;		//t@C_CAONXɃLvV̐ݒ
	dlg.m_ofn.lpstrFile = szFileNameBuffer;	//t@Ci[obt@ݒ肷B
	dlg.m_ofn.nMaxFile = _MAX_PATH *MAX_LIB+256;		//t@Ci[obt@̃TCYݒ肷B
	
	nResult=dlg.DoModal();			//t@C_CAO̎s
	if(nResult==IDOK){		//IȂc
//		CString rString=CString(dlg.m_ofn.lpstrFile);		//t@C_CAOt@C擾
		CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIB_LIST);	//Xg{bNX擾āc
		int n;
		CString strPath;
		POSITION pos = dlg.GetStartPosition();
		while(pos){
			strPath = dlg.GetNextPathName(pos);				
			n=pLB->GetCurSel();				//ݑIĂƂɑ}邽߂Ɍݒl擾
			if(n==LB_ERR) n=0;				//ݑIĂ̂Ȃΐ擪ɓ
			pLB->InsertString(n,strPath);	//Xg{bNXւ̃Zbg
			pLB->SetCurSel(n);				//Is̍Đݒ
			m_nList=pLB->GetCount();		//o[ϐւ̓o^̐ݒ
			if(m_nList>=MAX_LIB) break;
		}
		SetListboxWidth();
		EnableButton(IDC_LIB_ADD ,m_nList<MAX_LIB);//uADDv{^̐ݒ
		EnableButton(IDC_LIB_DOWN,n<m_nList-1);		//uցv{^̐ݒ
		EnableButton(IDC_LIB_UP  ,n>0);				//uցv{^̐ݒ
		EnableButton(IDC_LIB_DEL ,TRUE);			//uDELv{^̐ݒ
	}
}

//Cu̍폜
void CSetLib::OnLibDel() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int n;
	if(m_nList==0) return;		//o^OȂ牽Ȃ
    CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIB_LIST);
	n=pLB->GetCurSel();			//IĂ̂̔ԍ擾
	if(n==LB_ERR) return;		//IĂ̂ȂΉȂ
	pLB->DeleteString(n); 		//IĂ̂폜
    m_nList=pLB->GetCount(); 	//o^̐ݒ
	if(n>=m_nList) n=m_nList-1;	//폜̂ŉŝ̂Ȃ玟ɑÎ͈
	if(n>=0)pLB->SetCurSel(n);
	SetListboxWidth();
	EnableButton(IDC_LIB_ADD, TRUE);
   	EnableButton(IDC_LIB_DOWN,n<m_nList-1 && m_nList>0);
   	EnableButton(IDC_LIB_UP,  n>0);
	EnableButton(IDC_LIB_DEL, m_nList>0);
	
}


