/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// BSch.cpp : AvP[VpNX̋@\`s܂B
//

#include "stdafx.h"
#include "cderr.h"
#include "BSch.h"
#include <assert.h>
#include <string>
#include <list>
#include <Shlobj.h>
using namespace std;


#include "MainFrm.h"

//#include "BSchObj.h"

#include "BSchDoc.h"
#include "BSchView.h"

#include "complib.h"
#include "BSchFont.h"
#include "Global.h"
#include "Splash.h"

// Import from Qt-BSch project
#include "xbschglobal.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CBSchApp

BEGIN_MESSAGE_MAP(CBSchApp, CWinApp)
	//{{AFX_MSG_MAP(CBSchApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_PRINT_SETUP, OnFilePrintSetup)
	//}}AFX_MSG_MAP
	// W̃t@C{hLg R}h
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// ẄZbgAbv R}h
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBSchApp NX̍\z

CBSchApp::CBSchApp()
{
	// TODO: ̈ʒuɍ\zpR[hǉĂB
	//  InitInstance ̏dvȏׂċLqĂB
	//int i;
	//for(i=0;i<MAX_LIB;i++) g_pCompLib[i]=NULL;
	//g_bPrintPartNum=TRUE;	// 1997/01/26
	//g_bPrintPartName=TRUE;	// 1998/07/22

	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char pathModule[_MAX_PATH];

	m_szIniFileDir[0] = '\0';

	m_pszIniFileName = new char[_MAX_PATH];		//pXi[GÅm
												//MFCdeletêŁAŒGAmۂĂ͂ȂB

	//W[̃pX𒲂ׂB
	::GetModuleFileName(NULL,m_moduleFileName,_MAX_PATH);
	::_splitpath(m_moduleFileName,pathModule,dir,NULL,NULL);
	lstrcat(pathModule,dir);	//pathModuleɃW[̃fBNgB\LB

	//JgfBNg
	::GetCurrentDirectory(_MAX_PATH,m_pszIniFileName);	//JgfBNg𓾂
	lstrcat(m_pszIniFileName,"\\");			//\Lǉ

	//W[̃pXƃJgfBNgvȂƂ́A
	//JgfBNgBSCH3.INI̗LmFB
	//JgfBNgBSCH3.INIƂ͂INIt@CƂĎgB
	if(lstrcmp(pathModule,m_pszIniFileName)!=0){
		lstrcat(m_pszIniFileName,"BSCH3.INI");			//BSCH3.INIǉ
		//lstrcpy(m_pszIniFileName,"BSCH.INI");
		FILE *pf=fopen(m_pszIniFileName,"rt");
		if(pf){
			fclose(pf);
			goto EndOfFunc;
			//m_pszProfileName=m_pszIniFileName;	//쐬̃|C^m_pszProfileNameɃRs[
			//return;
		}
	}

	//Windows 2000/XPɂ
	//\Documents and Settings\username\Local Settings\Application Data\SuigyodoONLINE\BSCH3.INI TB
	//ꂪƂ́AINIt@CƂĎgB
	OSVERSIONINFO versionInfo;
	versionInfo.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
	if(GetVersionEx(&versionInfo)){
		if(versionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT){
			if(SHGetSpecialFolderPath(NULL,m_pszIniFileName,CSIDL_LOCAL_APPDATA,FALSE)){
				TRACE("CBSchApp::CBSchApp() %s\n",m_pszIniFileName);
				lstrcat(m_pszIniFileName,"\\SuigyodoONLINE\\BSCH3.INI");
				FILE *pf=fopen(m_pszIniFileName,"rt");
				if(pf){
					fclose(pf);
					goto EndOfFunc;
					//m_pszProfileName=m_pszIniFileName;	//쐬̃|C^m_pszProfileNameɃRs[
					//return;
				}
			}
		}
	}

	::_splitpath(m_moduleFileName,drive,dir,NULL,NULL);
	::_makepath(m_pszIniFileName,drive,dir,"BSCH3",".INI");

EndOfFunc:
	m_pszProfileName=m_pszIniFileName;	//쐬̃|C^m_pszProfileNameɃRs[
	::_splitpath(m_pszIniFileName,m_szIniFileDir,dir,NULL,NULL);
	::lstrcat(m_szIniFileDir,dir);
}

/////////////////////////////////////////////////////////////////////////////
// CBSchApp NX̏  96/10/20 ǉ

CBSchApp::~CBSchApp()
{
	g_FreeLibrary();	//Cũ
	delete g_pFont;
	delete g_pFontName;
}



/////////////////////////////////////////////////////////////////////////////
// B CBSchApp IuWFNg

CBSchApp theApp;


/////////////////////////////////////////////////////////////////////////////
// CBSchApp NX̏

BOOL CBSchApp::InitInstance()
{
	// CG: ̃ubŃuXvbV XN[vR|[lgɂǉĂ܂B
	{
		CCommandLineInfo cmdInfo;
		ParseCommandLine(cmdInfo);
		if(cmdInfo.m_nShellCommand != CCommandLineInfo::FileNew)cmdInfo.m_bShowSplash=FALSE;
		CSplashWnd::EnableSplashScreen(cmdInfo.m_bShowSplash);
	}
	// WIȏ
	// ̋@\gpAst@C̃TCY
	// Έȉ̓̏[`̒sKvȂ
	// 폜ĂB

	//AfxMessageBox(m_lpCmdLine);



#ifdef _AFXDLL
	Enable3dControls();			// L DLL ̒ MFC gpꍇɂ͂R[ĂB 
#else
	Enable3dControlsStatic();	// MFC ƐÓIɃNĂꍇɂ͂R[ĂB
#endif

	LCID lcid = ::GetSystemDefaultLCID();
	g_bJapaneseLangEnv = (lcid == 1041);

	//ꃊ\[XDLLǂݍޑÕ\[X̃o[Wƃ\[Xnh̕ۑ

	
	// Version 0.69 20101016
	//DLL̓ǂݍ݃pXst@C̃fBNgɐ
	char dllPath[_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	::_splitpath(m_moduleFileName,drive,dir,NULL,NULL);
	::_makepath(dllPath,drive,dir,"bsch3v_lang","dll");
	//܂ Version 0.69 20101016

	CString strVersion;
	strVersion.LoadString(IDS_VERSION);
	HINSTANCE hInstRcOrg = AfxGetResourceHandle();
	HINSTANCE hInstRc = LoadLibrary( dllPath );			//Version 0.69 20101016 DLL̓ǂݍ݃pXst@C̃fBNgɐ
	if ( hInstRc){				// ꃊ\[XDLL.
		AfxSetResourceHandle(hInstRc);
		//ꃊ\[X̃o[W`FbN
		CString strVersionAddRc;
		strVersionAddRc.LoadString(IDS_VERSION);
		//o[WvȂ΁Ã\[Xnhɖ߂
		if(strVersion.Compare(strVersionAddRc)!=0){
			AfxSetResourceHandle(hInstRcOrg);
		}
	}

	//GDIPLUS.DLL̗L`FbNB
	//GDIPLUS.DLL̓JwŁAx[hw邱ƁB
	g_bAvailableGDIplus = FALSE;
	HINSTANCE		hInstDGIPLUS;
	hInstDGIPLUS = LoadLibrary( "gdiplus.dll");
	if ( hInstDGIPLUS){				// gdiplus.dll.
		g_bAvailableGDIplus = TRUE;
		FreeLibrary(hInstDGIPLUS);
	}



//	SetRegistryKey("Suigyodo");	//INIt@C̑ɃWXg"Suigyodo()"g
// 1998/05/19
// Version 0.40   WXĝɃJgfBNg BSCH.INI gp悤ɕύX
// CBSchApp() (RXgN^) ŁAm_pszProfileName ɃJgfBNgBSCH.INIw
// 悤ɐݒ
// TRACE("m_pszProfileName %s\n",m_pszProfileName);
	LoadStdProfileSettings();  // W INI t@C̃IvV[ނ܂ (MRU ܂)
	// AvP[Vp̃hLg ev[go^܂BhLg ev[g
	// ̓hLgAt[ EBhEƃr[邽߂ɋ@\܂B

	/////////////////////////////////////////////////////////////////////////////
	// 96/10/21
	//O[oϐ̏Ȃ
	g_ReadLibrary();	//iCu̓ǂݍ
	LOGFONT lf;
	g_pFont=new CBSchFont;
	g_IniReadLabelFontInfo(&lf);
	g_pFont->setLogFont(lf);

	g_pFontName=new CBSchFont;
	g_IniReadNameFontInfo(&lf);
	g_pFontName->setLogFont(lf);
	g_pViewWindow = NULL;



	//g_RegisterClipboardFormat();//Nbv{[htH[}bg̓o^
			
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CBSchDoc),
		RUNTIME_CLASS(CMainFrame),       // C SDI t[ EBhE
		RUNTIME_CLASS(CBSchView));
	AddDocTemplate(pDocTemplate);

	// DDE Execute open gp\ɂ܂B
	EnableShellOpen();
	RegisterShellFileTypes(FALSE);


	// DDEAfile open ȂǕW̃VF R}h̃R}hC͂܂B
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	if(cmdInfo.m_nShellCommand == CCommandLineInfo::AppRegister){
		RegisterShellFileTypes(TRUE); 	//20090211
		AfxMessageBox(IDS_REG_FILETYPE,MB_OK|MB_ICONINFORMATION);
		return FALSE;
	}


	//EBhETCY̕
	int cmdShow;
	int mainframeCx;
	int mainframeCy;
	CMainFrame::IniReadWindowPosition(cmdShow,mainframeCx,mainframeCy);
	if(cmdShow==SW_SHOWMAXIMIZED){	//ő剻ƂOI̍ő剻gBȊOWindows̎wɏ]
		m_nCmdShow = SW_SHOWMAXIMIZED;
	}
	CMainFrame::SetInitialWindowSize(mainframeCx,mainframeCy);

	//20090211
	if(cmdInfo.m_nShellCommand == CCommandLineInfo::AppUnregister){
		UnregisterShellFileTypes();
		AfxMessageBox(IDS_UNREG_FILETYPE,MB_OK|MB_ICONINFORMATION);
		return FALSE;
	}

	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// R}hCŃfBXpb` R}hw肵܂B

	// hbO/hbv I[v܂
	m_pMainWnd->DragAcceptFiles();

	// INIt@CɂO[oϐ̏
	::g_notSaveBitPtn = (AfxGetApp()->GetProfileInt("Option","NotSaveBitPtn",0)!=0);
	AfxGetApp()->WriteProfileInt("Option","NotSaveBitPtn",(g_notSaveBitPtn?1:0));

	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

  	// ClassWizard ͉z֐𐶐I[o[Ch܂B
	//{{AFX_VIRTUAL(CAboutDlg)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// bZ[W nh͂܂B
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButtonSuigyodo();
	afx_msg void OnNMClickSyslink1(NMHDR *pNMHDR, LRESULT *pResult);
	virtual BOOL OnInitDialog();
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// bZ[W nh܂B
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_SUIGYODO, OnBnClickedButtonSuigyodo)
END_MESSAGE_MAP()

// _CAOs邽߂̃AvP[V R}h
void CBSchApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CBSchApp R}h


CDocument* CBSchApp::OpenDocumentFile(LPCTSTR lpszFileName) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	TRACE("OpenDocument(%s)\n",lpszFileName);
	//Ot@Cl[IɎgp BSch Version 0.64 1998/12/14
	char szLongFname[_MAX_PATH];
	char szDrive[_MAX_DRIVE];
	char szDir[_MAX_DIR];
	WIN32_FIND_DATA ffd;
	HANDLE hFindFile = ::FindFirstFile(lpszFileName,&ffd);
	if(hFindFile != INVALID_HANDLE_VALUE){
		::_splitpath(lpszFileName,szDrive,szDir,NULL,NULL);
		::_makepath(szLongFname,szDrive,szDir,"","");
		strcat(szLongFname,ffd.cFileName);
		::FindClose(hFindFile);
	}else{
		strcpy(szLongFname,lpszFileName);
	}

	CMainFrame* pMainFrame = (CMainFrame*)AfxGetMainWnd();
	if(pMainFrame){
		CDocument* pDoc=pMainFrame->GetActiveDocument();
		if(pDoc){
			//݂̃hLgłȂ΁AVKEBhEJ
			if(!((CBSchDoc*)pDoc)->IsEmpty()){
				if(ExecBSch(szLongFname)) return pDoc;
			}
		}
	}

	return CWinApp::OpenDocumentFile(szLongFname);
//	return CWinApp::OpenDocumentFile(lpszFileName);
}


BOOL CBSchApp::PreTranslateMessage(MSG* pMsg)
{
	// CG: ̍śuXvbV XN[vR|[lgɂǉĂ܂B
	CSplashWnd::PreTranslateAppMessage(pMsg);

	return CWinApp::PreTranslateMessage(pMsg);
}

BOOL CBSchApp::ExecBSch(const char* pathname)
{
	CString strCmdline;
	if(!pathname || *pathname == 0){
		strCmdline.Format("\"%s\"",m_moduleFileName);
	}else{
		strCmdline.Format("\"%s\" \"%s\"",m_moduleFileName,pathname);
	}

	char* cmdline = new char[strlen(strCmdline)+1];
	strcpy(cmdline,strCmdline);


	PROCESS_INFORMATION pi;
	STARTUPINFO si;

    ZeroMemory(&pi, sizeof(pi));
	ZeroMemory(&si, sizeof(si));
    si.cb = sizeof(si);

    BOOL resProc = CreateProcess(NULL, cmdline, NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi);

	CloseHandle(pi.hProcess);
    CloseHandle(pi.hThread);

	delete[]cmdline;

	return resProc;

}


void CBSchApp::OnFileNew() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CMainFrame* pMainFrame = (CMainFrame*)AfxGetMainWnd();
	if(pMainFrame){
		CDocument* pDoc=pMainFrame->GetActiveDocument();
		if(!((CBSchDoc*)pDoc)->IsEmpty()){
			if(ExecBSch("")) return;
		}
	}
	CWinApp::OnFileNew();
}

/////////////////////////////////////////////////////////////
// v^ݒ֘A
static const char* lpszPrinterSetupInfo = "PrinterSetupInfo";

void CBSchApp::IniWritePrinterSetup()
{
	if(m_hDevNames != NULL && m_hDevMode != NULL){
		DEVNAMES* lpDevNames = (DEVNAMES*)::GlobalLock(m_hDevNames);
		DEVMODE* lpDevMode = (DEVMODE*)::GlobalLock(m_hDevMode);
		AfxGetApp()->WriteProfileString(lpszPrinterSetupInfo,"Driver",(LPCSTR)lpDevNames+lpDevNames->wDriverOffset);
		AfxGetApp()->WriteProfileString(lpszPrinterSetupInfo,"Device",(LPCSTR)lpDevNames+lpDevNames->wDeviceOffset);
		AfxGetApp()->WriteProfileString(lpszPrinterSetupInfo,"Output",(LPCSTR)lpDevNames+lpDevNames->wOutputOffset);
		AfxGetApp()->WriteProfileInt(lpszPrinterSetupInfo,"Orientation",lpDevMode->dmOrientation);
		AfxGetApp()->WriteProfileInt(lpszPrinterSetupInfo,"PaperSize",lpDevMode->dmPaperSize);
		GlobalUnlock(m_hDevNames);
		GlobalUnlock(m_hDevMode);
	}
}


void g_GlobalFree(HGLOBAL hGlobal)
{
	if (hGlobal == NULL)return;
	UINT nCount = GlobalFlags(hGlobal) & GMEM_LOCKCOUNT;
	while (nCount--)
		GlobalUnlock(hGlobal);
	GlobalFree(hGlobal);
}

void CBSchApp::OnFilePrintSetup() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	//CWinApp::OnFilePrintSetup();

		CPrintDialog pd(TRUE);
	//	DoPrintDialog(&pd);

	UpdatePrinterSelection(FALSE);

	pd.m_pd.hDevMode = m_hDevMode;
	pd.m_pd.hDevNames = m_hDevNames;
	int nResponse = pd.DoModal();

	// if OK or Cancel is selected we need to update cached devMode/Names
	while (nResponse != IDOK && nResponse != IDCANCEL)
	{
		switch (::CommDlgExtendedError())
		{
		// CommDlg cannot give these errors after NULLing these handles
		case PDERR_PRINTERNOTFOUND:
		case PDERR_DNDMMISMATCH:
		case PDERR_DEFAULTDIFFERENT:
			if (pd.m_pd.hDevNames != NULL)
			{
				ASSERT(m_hDevNames == pd.m_pd.hDevNames);
				g_GlobalFree(pd.m_pd.hDevNames);
				pd.m_pd.hDevNames = NULL;
				m_hDevNames = NULL;
			}

			if (pd.m_pd.hDevMode)
			{
				ASSERT(m_hDevMode == pd.m_pd.hDevMode);
				g_GlobalFree(pd.m_pd.hDevMode);
				pd.m_pd.hDevMode = NULL;
				m_hDevMode = NULL;
			}
			break;

		default:
			return;
		}
		nResponse = pd.DoModal();
	}
	// refresh current CWinApp cache of printer device information
	m_hDevMode = pd.m_pd.hDevMode;
	m_hDevNames = pd.m_pd.hDevNames;
	IniWritePrinterSetup();

}

void CBSchApp::UpdatePrinterSelection(BOOL bForceDefaults)
{
	BOOL fSet1st = (m_hDevNames == NULL);
	CWinApp::UpdatePrinterSelection(bForceDefaults);

	if(fSet1st && !bForceDefaults && m_hDevNames != NULL && m_hDevMode != NULL){
		CString strDriver	= AfxGetApp()->GetProfileString(lpszPrinterSetupInfo,"Driver","");
		CString strDevice	= AfxGetApp()->GetProfileString(lpszPrinterSetupInfo,"Device","");
		CString strOutput	= AfxGetApp()->GetProfileString(lpszPrinterSetupInfo,"Output","");
		int nOrientation	= AfxGetApp()->GetProfileInt(lpszPrinterSetupInfo,"Orientation",0);
		int nPaperSize		= AfxGetApp()->GetProfileInt(lpszPrinterSetupInfo,"PaperSize",0);
		DEVNAMES* lpDevNames = (DEVNAMES*)::GlobalLock(m_hDevNames);
		if(
				strcmp((LPCSTR)lpDevNames+lpDevNames->wDriverOffset,strDriver)==0
			&&	strcmp((LPCSTR)lpDevNames+lpDevNames->wDeviceOffset,strDevice)==0
			&&	strcmp((LPCSTR)lpDevNames+lpDevNames->wOutputOffset,strOutput)==0
			){
			DEVMODE* lpDevMode = (DEVMODE*)::GlobalLock(m_hDevMode);
			if(nOrientation!=0) lpDevMode->dmOrientation = nOrientation;
			if(nPaperSize!=0)	lpDevMode->dmPaperSize   = nPaperSize;
			GlobalUnlock(m_hDevMode);
		}
		GlobalUnlock(m_hDevNames);
	}
}


void CAboutDlg::OnBnClickedButtonSuigyodo()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	CString url;
	url.LoadString(IDS_URL);
	::ShellExecute(
		NULL,              // eEBhẼnh
		_T("open"),         // 
		url,         // Ώۂ̃t@C
		NULL,   // ̃p[^
		NULL,    // ̃fBNg
		SW_SHOWDEFAULT            // \
	);
}




BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	CString msg;
	CString strVersion;
	strVersion.LoadString(IDS_VERSION);
	msg = "BSch3V Version ";
	msg += strVersion;
	SetDlgItemText(IDC_STATIC_VERSION,msg);


	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CBSchApp::OnIdle(LONG lCount)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if(g_pViewWindow){
		if(g_pViewWindow->GetSafeHwnd()){
			((CBSchView*)g_pViewWindow)->DisplayMessageLine();
		}
	}
	//ł͑ʖځBvr[̓vr[EBhEANeBur[ɂȂB
	//((CBSchView*)(((CMainFrame*)(AfxGetApp()->GetMainWnd()))->GetActiveView()))->DisplayMessageLine();
	return CWinApp::OnIdle(lCount);
}
