{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: JvAutoSizeCompo.PAS, released on 2001-02-28.

The Initial Developer of the Original Code is Sbastien Buysse [sbuysse att buypin dott com]
Portions created by Sbastien Buysse are Copyright (C) 2001 Sbastien Buysse.
All Rights Reserved.

Contributor(s): Michael Beck [mbeck att bigfoot dott com].

You may retrieve the latest version of this file at the Project JEDI's JVCL home page,
located at http://jvcl.delphi-jedi.org

Known Issues:
-----------------------------------------------------------------------------}
// $Id: JvFormAutoSize.pas 13102 2011-09-07 05:46:34Z obones $

unit JvFormAutoSize;

{$I jvcl.inc}

interface

uses
  {$IFDEF UNITVERSIONING}
  JclUnitVersioning,
  {$ENDIF UNITVERSIONING}
  SysUtils, Classes, Windows, Messages, Graphics, Controls, Forms, StdCtrls,
  JvComponentBase;

type
  {$IFDEF RTL230_UP}
  [ComponentPlatformsAttribute(pidWin32 or pidWin64 or pidOSX32)]
  {$ENDIF RTL230_UP}
  TJvFormAutoSize = class(TJvComponent)
  private
    FForm: TForm;
    FActive: Boolean;
    FResize: TNotifyEvent;
    FOldWidth: Integer;
    FOldHeight: Integer;
    procedure Resize(Sender: TObject);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    // (p3) default here should be false!!!
    property Active: Boolean read FActive write FActive default False;
  end;

{$IFDEF UNITVERSIONING}
const
  UnitVersioning: TUnitVersionInfo = (
    RCSfile: '$URL: https://jvcl.svn.sourceforge.net/svnroot/jvcl/tags/JVCL3_45/run/JvFormAutoSize.pas $';
    Revision: '$Revision: 13102 $';
    Date: '$Date: 2011-09-07 07:46:34 +0200 (mer., 07 sept. 2011) $';
    LogPath: 'JVCL\run'
  );
{$ENDIF UNITVERSIONING}

implementation


constructor TJvFormAutoSize.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  // (p3) dangerous: True can create problems without user being aware
  FActive := False;
  FForm := GetParentForm(TControl(AOwner)) as TForm;
  if FForm <> nil then
  begin
    FOldWidth := FForm.Width;
    FOldHeight := FForm.Height;
    FResize := FForm.OnResize;
    FForm.OnResize := Resize;
  end;
end;

destructor TJvFormAutoSize.Destroy;
begin
  if FForm <> nil then
    FForm.OnResize := nil;
  FForm := nil;
  inherited Destroy;
end;

procedure TJvFormAutoSize.Resize(Sender: TObject);
var
  WidthRatio, HeightRatio: Double;
  CompIndex: Integer;
begin
  if FForm = nil then
    FForm := GetParentForm(Owner as TControl) as TForm;
  if FActive and (FForm <> nil) then
  begin
    // (p3) this code is slightly dangerous: no sanity checks -
    // values can become really large or really small
    if (FOldWidth <> 0) and (FOldHeight <> 0) then
    begin
      WidthRatio := FForm.Width / FOldWidth;
      HeightRatio := FForm.Height / FOldHeight;
      for CompIndex := 0 to FForm.ComponentCount - 1 do
      begin
        if FForm.Components[CompIndex] is TControl then
        begin
          with FForm.Components[CompIndex] as TControl do
          begin
            if not (FForm.Components[CompIndex] is TButton) then
            begin
              Width := Round(Width * WidthRatio);
              Height := Round(Height * HeightRatio);
            end;
            Left := Round(Left * WidthRatio);
            Top := Round(Top * HeightRatio);
          end;
        end;
      end;
    end;
    FOldWidth := FForm.Width;
    FOldHeight := FForm.Height;
  end;
  if Assigned(FResize) then
    FResize(Sender);
end;

{$IFDEF UNITVERSIONING}
initialization
  RegisterUnitVersion(HInstance, UnitVersioning);

finalization
  UnregisterUnitVersion(HInstance);
{$ENDIF UNITVERSIONING}

end.