{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: JvDBActionsEngineControlcxTreeList.Pas, released on 2004-12-30.

The Initial Developer of the Original Code is Jens Fudickar [jens dott fudicker  att oratool dott de]
Portions created by Jens Fudickar are Copyright (C) 2002 Jens Fudickar.
All Rights Reserved.

Contributor(s): -

You may retrieve the latest version of this file at the Project JEDI's JVCL home page,
located at http://jvcl.delphi-jedi.org

Known Issues:
-----------------------------------------------------------------------------}
// $Id: JvControlActionsEngineCxTreeList.pas 13015 2011-04-10 17:19:12Z jfudickar $

unit JvControlActionsEngineCxTreeList;

{$I jvcl.inc}

interface

uses
  {$IFDEF UNITVERSIONING}
  JclUnitVersioning,
  {$ENDIF UNITVERSIONING}
  Forms, Controls, Classes, DB,
  {$IFDEF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}
  cxTL,
  {$ENDIF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}
  JvControlActionsEngine, JvActionsEngine;

{$IFDEF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}
type
  TJvControlActioncxTreeListEngine = class(TJvControlActionEngine)
  private
  protected
    procedure ExportTreeList(aTreeList: TcxCustomTreeList);
    function GetSupportedOperations: TJvControlActionOperations; override;
    function GetTreeList(AActionComponent: TComponent): TcxCustomTreeList;
  public
    function ExecuteOperation(const aOperation: TJvControlActionOperation; const aActionControl: TControl): Boolean; override;
    function SupportsComponent(aActionComponent: TComponent): Boolean; override;
    function UpdateAction(Action: TBasicAction): boolean; override;
  end;

{$ENDIF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}

{$IFDEF UNITVERSIONING}
const
  UnitVersioning: TUnitVersionInfo = (
    RCSfile: '$URL: https://jvcl.svn.sourceforge.net/svnroot/jvcl/tags/JVCL3_45/run/JvControlActionsEngineCxTreeList.pas $';
    Revision: '$Revision: 13015 $';
    Date: '$Date: 2011-04-10 19:19:12 +0200 (dim., 10 avr. 2011) $';
    LogPath: 'JVCL\run'
    );
{$ENDIF UNITVERSIONING}

implementation

uses
  {$IFDEF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}
  cxTLExportLink,
  {$ENDIF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}
  Variants, SysUtils, Grids, Dialogs, JvControlActions;

//=== { TJvDatabaseActionDevExpcxTreeListControlEngine } =========================

{$IFDEF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}

function TJvControlActioncxTreeListEngine.ExecuteOperation(const aOperation: TJvControlActionOperation; const
    aActionControl: TControl): Boolean;
begin
  Result := false;
  if Assigned(GetTreeList(aActionControl)) then
    Case aOperation of
      caoCollapse : GetTreeList(aActionControl).FullCollapse;
      caoExpand : GetTreeList(aActionControl).FullExpand;
      caoOptimizeColumns : GetTreeList(aActionControl).ApplyBestFit;
      caoCustomizeColumns : GetTreeList(aActionControl).Customizing.Visible := not GetTreeList(aActionControl).Customizing.Visible;
      caoExport : ExportTreeList(GetTreeList(aActionControl));
    End;
end;

procedure TJvControlActioncxTreeListEngine.ExportTreeList(aTreeList: TcxCustomTreeList);
var
  SaveDialog: TSaveDialog;
begin
  if not Assigned(aTreeList) then
    Exit;
  SaveDialog := TSaveDialog.Create(Self);
  try
    SaveDialog.Name    := 'SaveDialog';
    SaveDialog.DefaultExt := 'XLS';
    SaveDialog.Filter  := 'MS-Excel-Files (*.XLS)|*.XLS|XML-Files (*.XML)|*.HTM|HTML-Files (*.HTM)|*.HTM|Text-Files (*.TXT)|*.TXT|All Files (*.*)|*.*';
    SaveDialog.Options := [ofOverwritePrompt, ofHideReadOnly, ofPathMustExist];
    if SaveDialog.Execute then
      if SaveDialog.FileName <> '' then
      begin
        if (Pos('.XLS', UpperCase(SaveDialog.FileName)) = Length(SaveDialog.FileName) - 3) then
          cxExportTLToExcel(SaveDialog.FileName, aTreeList)
        else if (Pos('.XML', UpperCase(SaveDialog.FileName)) = Length(SaveDialog.FileName) - 3) then
          cxExportTLToXML(SaveDialog.FileName, aTreeList)
        else if ((Pos('.HTM', UpperCase(SaveDialog.FileName)) = Length(SaveDialog.FileName) - 3) or
          (Pos('.HTML', UpperCase(SaveDialog.FileName)) = Length(SaveDialog.FileName) - 4)) then
          cxExportTLToHTML(SaveDialog.FileName, aTreeList)
        else
          cxExportTLToText(SaveDialog.FileName, aTreeList);
      end;
  finally
    SaveDialog.Free;
  end;
end;

function TJvControlActioncxTreeListEngine.GetSupportedOperations: TJvControlActionOperations;
begin
  Result := [caoExport, caoCollapse, caoExpand, caoOptimizeColumns, caoCustomizeColumns];
end;

function TJvControlActioncxTreeListEngine.GetTreeList(AActionComponent: TComponent): TcxCustomTreeList;
begin
  if Assigned(AActionComponent) and (AActionComponent is TcxCustomTreeList) then
    Result := TcxCustomTreeList(AActionComponent)
  else
    Result := nil;
end;

function TJvControlActioncxTreeListEngine.SupportsComponent(aActionComponent: TComponent): Boolean;
begin
  Result := Assigned(GetTreeList(AActionComponent));
end;

function TJvControlActioncxTreeListEngine.UpdateAction(Action: TBasicAction): boolean;
begin
  if Assigned(Action) and (Action is TJvControlBaseAction) and
    Assigned(GetTreeList(TJvControlBaseAction(Action).ActionComponent)) and (TJvControlBaseAction(Action).ControlOperation = caoCustomizeColumns) then
    TJvControlBaseAction(Action).SetChecked(GetTreeList(TJvControlBaseAction(Action).ActionComponent).Customizing.Visible);

end;

{$ENDIF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}

procedure InitActionEngineList;
begin
  {$IFDEF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}
  RegisterControlActionEngine(TJvControlActioncxTreeListEngine);
  {$ENDIF USE_3RDPARTY_DEVEXPRESS_CXTREELIST}
end;


initialization
  {$IFDEF UNITVERSIONING}
  RegisterUnitVersion(HInstance, UnitVersioning);
  {$ENDIF UNITVERSIONING}
  InitActionEngineList;

finalization
  {$IFDEF UNITVERSIONING}
  UnregisterUnitVersion(HInstance);
  {$ENDIF UNITVERSIONING}

end.
