{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: JvgProcessUtils.PAS, released on 2003-01-15.

The Initial Developer of the Original Code is Andrey V. Chudin,  [chudin att yandex dott ru]
Portions created by Andrey V. Chudin are Copyright (C) 2003 Andrey V. Chudin.
All Rights Reserved.

Contributor(s):
Michael Beck [mbeck att bigfoot dott com].

You may retrieve the latest version of this file at the Project JEDI's JVCL home page,
located at http://jvcl.sourceforge.net

Known Issues:
-----------------------------------------------------------------------------}
// $Id: JvgProcessUtils.pas 10610 2006-05-19 13:35:08Z elahn $

unit JvgProcessUtils;

{$I jvcl.inc}

interface

uses
  {$IFDEF USEJVCL}
  {$IFDEF UNITVERSIONING}
  JclUnitVersioning,
  {$ENDIF UNITVERSIONING}
  {$ENDIF USEJVCL}
  Windows, Classes;

// (rom) definitely goes to JCL

procedure GetProcessList(const SList: TStrings);
procedure KillProcessByName(const Name: string);

const
  // (rom) from WINNT.h
  PROCESS_TERMINATE         = $0001;
  {$EXTERNALSYM PROCESS_TERMINATE}
  PROCESS_CREATE_THREAD     = $0002;
  {$EXTERNALSYM PROCESS_CREATE_THREAD}
  PROCESS_SET_SESSIONID     = $0004;
  {$EXTERNALSYM PROCESS_SET_SESSIONID}
  PROCESS_VM_OPERATION      = $0008;
  {$EXTERNALSYM PROCESS_VM_OPERATION}
  PROCESS_VM_READ           = $0010;
  {$EXTERNALSYM PROCESS_VM_READ}
  PROCESS_VM_WRITE          = $0020;
  {$EXTERNALSYM PROCESS_VM_WRITE}
  PROCESS_DUP_HANDLE        = $0040;
  {$EXTERNALSYM PROCESS_DUP_HANDLE}
  PROCESS_CREATE_PROCESS    = $0080;
  {$EXTERNALSYM PROCESS_CREATE_PROCESS}
  PROCESS_SET_QUOTA         = $0100;
  {$EXTERNALSYM PROCESS_SET_QUOTA}
  PROCESS_SET_INFORMATION   = $0200;
  {$EXTERNALSYM PROCESS_SET_INFORMATION}
  PROCESS_QUERY_INFORMATION = $0400;
  {$EXTERNALSYM PROCESS_QUERY_INFORMATION}
  PROCESS_ALL_ACCESS        = STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or $0FFF;
  {$EXTERNALSYM PROCESS_ALL_ACCESS}

{$IFDEF USEJVCL}
{$IFDEF UNITVERSIONING}
const
  UnitVersioning: TUnitVersionInfo = (
    RCSfile: '$RCSfile$';
    Revision: '$Revision: 10610 $';
    Date: '$Date: 2006-05-19 15:35:08 +0200 (ven., 19 mai 2006) $';
    LogPath: 'JVCL\run'
  );
{$ENDIF UNITVERSIONING}
{$ENDIF USEJVCL}

implementation

uses
  TLHelp32,
  {$IFDEF BCB5}
  JvVCL5Utils,
  {$ENDIF BCB5}
  {$IFDEF COMPILER5}
  JvgUtils, // SameFileName() for Delphi 5
  {$ENDIF COMPILER5}
  SysUtils;

procedure GetProcessList(const SList: TStrings);
var
  hSnapshot: THandle;
  Pe32: TProcessEntry32;
begin
  SList.BeginUpdate;
  try
    SList.Clear;
    hSnapshot := CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
    Pe32.dwSize := SizeOf(TProcessEntry32);

    if Process32First(hSnapshot, Pe32) then
      repeat
        SList.Add(Format('%x, %x: %s', [Pe32.th32ProcessID, Pe32.th32ParentProcessID, Pe32.szExeFile]));
      until not Process32Next(hSnapshot, Pe32);

    CloseHandle(hSnapshot);
  finally
    SList.EndUpdate;
  end;
end;

procedure KillProcessByName(const Name: string);
var
  hProc, hSnapshot: THandle;
  Pe32: TProcessEntry32;
begin
  hSnapshot := CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
  Pe32.dwSize := SizeOf(TProcessEntry32);

  if Process32First(hSnapshot, Pe32) then
    repeat
      if SameFileName(ExtractFileName(Pe32.szExeFile), Name) then
      begin
        hProc := OpenProcess(PROCESS_TERMINATE, False, Pe32.th32ProcessID);
        if hProc <> 0 then
          TerminateProcess(hProc, 0);
      end;
    until not Process32Next(hSnapshot, Pe32);

  CloseHandle(hSnapshot);
end;

{$IFDEF USEJVCL}
{$IFDEF UNITVERSIONING}
initialization
  RegisterUnitVersion(HInstance, UnitVersioning);

finalization
  UnregisterUnitVersion(HInstance);
{$ENDIF UNITVERSIONING}
{$ENDIF USEJVCL}

end.

