{**************************************************************************************************}
{                                                                                                  }
{ Project JEDI Code Library (JCL)                                                                  }
{                                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1 (the "License"); }
{ you may not use this file except in compliance with the License. You may obtain a copy of the    }
{ License at http://www.mozilla.org/MPL/                                                           }
{                                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF   }
{ ANY KIND, either express or implied. See the License for the specific language governing rights  }
{ and limitations under the License.                                                               }
{                                                                                                  }
{ The Original Code is JclContainerKnownTypes.pas.                                                 }
{                                                                                                  }
{ The Initial Developer of the Original Code is Florent Ouchet                                     }
{         <outchy att users dott sourceforge dott net>                                             }
{ Portions created by Florent Ouchet are Copyright (C) of Florent Ouchet. All rights reserved.     }
{                                                                                                  }
{ Contributors:                                                                                    }
{                                                                                                  }
{**************************************************************************************************}
{                                                                                                  }
{ Last modified: $Date:: 2011-09-02 23:25:25 +0200 (ven., 02 sept. 2011)                         $ }
{ Revision:      $Rev:: 3594                                                                     $ }
{ Author:        $Author:: outchy                                                                $ }
{                                                                                                  }
{**************************************************************************************************}

unit JclPreProcessorContainerKnownTypes;

interface

{$I jcl.inc}

uses
  {$IFDEF UNITVERSIONING}
  JclUnitVersioning,
  {$ENDIF UNITVERSIONING}
  JclPreProcessorContainerTypes;

const
  IInterfaceKnownType: TKnownTypeAttributes =
    ({taTypeName} 'IInterface',
     {taCondition} '',
     {taDefines} 'REFCOUNTED',
     {taUndefs} '',
     {taAlias} '',
     {taAliasCondition} '',
     {taDefaultValue} 'nil',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclIntfOwner',
     {taOwnershipInterfaceGUID} '{17C1D3FB-BB32-48F2-BD1C-D43EA05A86A8}',
     {taReleaserName} 'FreeObject',
     {taReleaseEventName} 'OnFreeObject',
     {taReleaseEventTypeName} 'TFreeIntfEvent',
     {taGetterName} 'GetObject',
     {taSetterName} 'SetObject',
     {taParameterName} 'AInterface',
     {taDynArrayTypeName} 'TDynIInterfaceArray',
     {taArrayName} 'Objects',
     {taBaseContainer} 'TJclIntfAbstractContainer',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TIntfIterateProcedure',
     {taApplyFunctionName} 'TIntfApplyFunction',
     {taCompareFunctionName} 'TIntfCompare',
     {taSimpleCompareFunctionName} 'IntfSimpleCompare',
     {taEqualityCompareFunctionName} 'TIntfEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'IntfSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TIntfHashConvert',
     {taSimpleHashConvertFunctionName} 'IntfSimpleHashConvert',
     {taContainerInterfaceName} '',
     {taContainerInterfaceGUID} '',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclIntfEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{5CC2DF51-BE56-4D02-A171-31BAAC097632}',
     {taComparerInterfaceName} 'IJclIntfComparer',
     {taComparerInterfaceGUID} '{EB41B843-184B-420D-B5DA-27D055B4CD55}',
     {taHashConverterInterfaceName} 'IJclIntfHashConverter',
     {taHashConverterInterfaceGUID} '{7BAA0791-3B45-4D0F-9CD8-D13B81694786}',
     {taIteratorInterfaceName} 'IJclIntfIterator',
     {taIteratorInterfaceGUID} '{E121A98A-7C43-4587-806B-9189E8B2F106}',
     {taBinaryTreeIteratorInterfaceName} 'IJclIntfBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{8BE874B2-0075-4EE0-8F49-665FC894D923}',
     {taBinaryTreeNodeTypeName} 'TJclIntfBinaryNode',
     {taBinaryTreeClassName} 'TJclIntfBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclIntfBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderIntfBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderIntfBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderIntfBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclIntfCollection',
     {taCollectionInterfaceGUID} '{8E178463-4575-487A-B4D5-DC2AED3C7ACA}',
     {taListInterfaceName} 'IJclIntfList',
     {taListInterfaceGUID} '{E14EDA4B-1DAA-4013-9E6C-CDCB365C7CF9}',
     {taSortProcedureName} 'TIntfSortProc',
     {taArrayInterfaceName} 'IJclIntfArray',
     {taArrayInterfaceGUID} '{B055B427-7817-43FC-97D4-AD1845643D63}',
     {taArrayListClassName} 'TJclIntfArrayList',
     {taArrayIteratorClassName} 'TJclIntfArrayIterator',
     {taLinkedListItemClassName} 'TJclIntfLinkedListItem',
     {taLinkedListClassName} 'TJclIntfLinkedList',
     {taLinkedListIteratorClassName} 'TJclIntfLinkedListIterator',
     {taVectorClassName} 'TJclIntfVector',
     {taVectorIteratorClassName} 'TJclIntfVectorIterator',
     {taSetInterfaceName} 'IJclIntfSet',
     {taSetInterfaceGUID} '{E2D28852-9774-49B7-A739-5DBA2B705924}',
     {taArraySetClassName} 'TJclIntfArraySet',
     {taTreeIteratorInterfaceName} 'IJclIntfTreeIterator',
     {taTreeIteratorInterfaceGUID} '{C97379BF-C6A9-4A90-9D7A-152E9BAD314F}',
     {taTreeInterfaceName} 'IJclIntfTree',
     {taTreeInterfaceGUID} '{5A21688F-113D-41B4-A17C-54BDB0BD6559}',
     {taTreeNodeClassName} 'TJclIntfTreeNode',
     {taTreeClassName} 'TJclIntfTree',
     {taTreeBaseIteratorClassName} 'TJclIntfTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderIntfTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderIntfTreeIterator',
     {taQueueInterfaceName} 'IJclIntfQueue',
     {taQueueInterfaceGUID} '{B88756FE-5553-4106-957E-3E33120BFA99}',
     {taQueueClassName} 'TJclIntfQueue',
     {taSortedSetInterfaceName} 'IJclIntfSortedSet',
     {taSortedSetInterfaceGUID} '{159BE5A7-7349-42FF-BE55-9CA1B9DBA991}',
     {taStackInterfaceName} 'IJclIntfStack',
     {taStackInterfaceGUID} '{CA1DC7A1-8D8F-4A5D-81D1-0FE32E9A4E84}',
     {taStackClassName} 'TJclIntfStack'
    );

  AnsiStringKnownType: TKnownTypeAttributes =
    ({taTypeName} 'AnsiString',
     {taCondition} '',
     {taDefines} 'REFCOUNTED',
     {taUndefs} '',
     {taAlias} 'string',
     {taAliasCondition} 'CONTAINER_ANSISTR',
     {taDefaultValue} '''''',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclAnsiStrOwner',
     {taOwnershipInterfaceGUID} '{4F64F1F6-766A-4CFA-B51B-654116E308A8}',
     {taReleaserName} 'FreeString',
     {taReleaseEventName} 'OnFreeString',
     {taReleaseEventTypeName} 'TFreeAnsiStrEvent',
     {taGetterName} 'GetString',
     {taSetterName} 'SetString',
     {taParameterName} 'AString',
     {taDynArrayTypeName} 'TDynAnsiStringArray',
     {taArrayName} 'Strings',
     {taBaseContainer} 'TJclAnsiStrAbstractContainer',
     {taBaseCollection} 'TJclAnsiStrAbstractCollection',
     {taIterateProcedureName} 'TAnsiStrIterateProcedure',
     {taApplyFunctionName} 'TAnsiStrApplyFunction',
     {taCompareFunctionName} 'TAnsiStrCompare',
     {taSimpleCompareFunctionName} 'AnsiStrSimpleCompare',
     {taEqualityCompareFunctionName} 'TAnsiStrEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'AnsiStrSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TAnsiStrHashConvert',
     {taSimpleHashConvertFunctionName} 'AnsiStrSimpleHashConvert',
     {taContainerInterfaceName} 'IJclAnsiStrContainer',
     {taContainerInterfaceGUID} '{F8239357-B96F-46F1-A48E-B5DF25B5F1FA}',
     {taFlatContainerInterfaceName} 'IJclAnsiStrFlatContainer',
     {taFlatContainerInterfaceGUID} '{8A45A4D4-6317-4CDF-8314-C3E5CC6899F4}',
     {taEqualityComparerInterfaceName} 'IJclAnsiStrEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{E3DB9016-F0D0-4CE0-B156-4C5DCA47FD3B}',
     {taComparerInterfaceName} 'IJclAnsiStrComparer',
     {taComparerInterfaceGUID} '{09063CBB-9226-4734-B2A0-A178C2343176}',
     {taHashConverterInterfaceName} 'IJclAnsiStrHashConverter',
     {taHashConverterInterfaceGUID} '{9841014E-8A31-4C79-8AD5-EB03C4E85533}',
     {taIteratorInterfaceName} 'IJclAnsiStrIterator',
     {taIteratorInterfaceGUID} '{D5D4B681-F902-49C7-B9E1-73007C9D64F0}',
     {taBinaryTreeIteratorInterfaceName} 'IJclAnsiStrBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{34A4A300-042C-43A9-AC23-8FC1B76BFB25}',
     {taBinaryTreeNodeTypeName} 'TJclAnsiStrBinaryNode',
     {taBinaryTreeClassName} 'TJclAnsiStrBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclAnsiStrBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderAnsiStrBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderAnsiStrBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderAnsiStrBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclAnsiStrCollection',
     {taCollectionInterfaceGUID} '{3E3CFC19-E8AF-4DD7-91FA-2DF2895FC7B9}',
     {taListInterfaceName} 'IJclAnsiStrList',
     {taListInterfaceGUID} '{07DD7644-EAC6-4059-99FC-BEB7FBB73186}',
     {taSortProcedureName} 'TAnsiStrSortProc',
     {taArrayInterfaceName} 'IJclAnsiStrArray',
     {taArrayInterfaceGUID} '{4953EA83-9288-4537-9D10-544D1C992B62}',
     {taArrayListClassName} 'TJclAnsiStrArrayList',
     {taArrayIteratorClassName} 'TJclAnsiStrArrayIterator',
     {taLinkedListItemClassName} 'TJclAnsiStrLinkedListItem',
     {taLinkedListClassName} 'TJclAnsiStrLinkedList',
     {taLinkedListIteratorClassName} 'TJclAnsiStrLinkedListIterator',
     {taVectorClassName} 'TJclAnsiStrVector',
     {taVectorIteratorClassName} 'TJclAnsiStrVectorIterator',
     {taSetInterfaceName} 'IJclAnsiStrSet',
     {taSetInterfaceGUID} '{72204D85-2B68-4914-B9F2-09E5180C12E9}',
     {taArraySetClassName} 'TJclAnsiStrArraySet',
     {taTreeIteratorInterfaceName} 'IJclAnsiStrTreeIterator',
     {taTreeIteratorInterfaceGUID} '{66BC5C76-758C-4E72-ABF1-EB02CF851C6D}',
     {taTreeInterfaceName} 'IJclAnsiStrTree',
     {taTreeInterfaceGUID} '{1E1896C0-0497-47DF-83AF-A9422084636C}',
     {taTreeNodeClassName} 'TJclAnsiStrTreeNode',
     {taTreeClassName} 'TJclAnsiStrTree',
     {taTreeBaseIteratorClassName} 'TJclAnsiStrTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderAnsiStrTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderAnsiStrTreeIterator',
     {taQueueInterfaceName} 'IJclAnsiStrQueue',
     {taQueueInterfaceGUID} '{5BA0ED9A-5AF3-4F79-9D80-34FA7FF15D1F}',
     {taQueueClassName} 'TJclAnsiStrQueue',
     {taSortedSetInterfaceName} 'IJclAnsiStrSortedSet',
     {taSortedSetInterfaceGUID} '{03198146-F967-4310-868B-7AD3D52D5CBE}',
     {taStackInterfaceName} 'IJclAnsiStrStack',
     {taStackInterfaceGUID} '{649BB74C-D7BE-40D9-9F4E-32DDC3F13F3B}',
     {taStackClassName} 'TJclAnsiStrStack'
    );

  WideStringKnownType: TKnownTypeAttributes =
    ({taTypeName} 'WideString',
     {taCondition} '',
     {taDefines} 'REFCOUNTED',
     {taUndefs} '',
     {taAlias} 'string',
     {taAliasCondition} 'CONTAINER_WIDESTR',
     {taDefaultValue} '''''',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclWideStrOwner',
     {taOwnershipInterfaceGUID} '{282B7A64-BCD0-4EAE-8776-4EF92D7E3D8B}',
     {taReleaserName} 'FreeString',
     {taReleaseEventName} 'OnFreeString',
     {taReleaseEventTypeName} 'TFreeWideStrEvent',
     {taGetterName} 'GetString',
     {taSetterName} 'SetString',
     {taParameterName} 'AString',
     {taDynArrayTypeName} 'TDynWideStringArray',
     {taArrayName} 'Strings',
     {taBaseContainer} 'TJclWideStrAbstractContainer',
     {taBaseCollection} 'TJclWideStrAbstractCollection',
     {taIterateProcedureName} 'TWideStrIterateProcedure',
     {taApplyFunctionName} 'TWideStrApplyFunction',
     {taCompareFunctionName} 'TWideStrCompare',
     {taSimpleCompareFunctionName} 'WideStrSimpleCompare',
     {taEqualityCompareFunctionName} 'TWideStrEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'WideStrSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TWideStrHashConvert',
     {taSimpleHashConvertFunctionName} 'WideStrSimpleHashConvert',
     {taContainerInterfaceName} 'IJclWideStrContainer',
     {taContainerInterfaceGUID} '{875E1AC4-CA22-46BC-8999-048E5B9BF11D}',
     {taFlatContainerInterfaceName} 'IJclWideStrFlatContainer',
     {taFlatContainerInterfaceGUID} '{5B001B93-CA1C-47A8-98B8-451CCB444930}',
     {taEqualityComparerInterfaceName} 'IJclWideStrEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{2E5696C9-8374-4347-9DC9-B3722F47F5FB}',
     {taComparerInterfaceName} 'IJclWideStrComparer',
     {taComparerInterfaceGUID} '{7A24AEDA-25B1-4E73-B2E9-5D74011E4C9C}',
     {taHashConverterInterfaceName} 'IJclWideStrHashConverter',
     {taHashConverterInterfaceGUID} '{2584118F-19AE-443E-939B-0DB18BCD0117}',
     {taIteratorInterfaceName} 'IJclWideStrIterator',
     {taIteratorInterfaceGUID} '{F03BC7D4-CCDA-4C4A-AF3A-E51FDCDE8ADE}',
     {taBinaryTreeIteratorInterfaceName} 'IJclWideStrBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{17C08EB9-6880-469E-878A-8F5EBFE905B1}',
     {taBinaryTreeNodeTypeName} 'TJclWideStrBinaryNode',
     {taBinaryTreeClassName} 'TJclWideStrBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclWideStrBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderWideStrBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderWideStrBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderWideStrBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclWideStrCollection',
     {taCollectionInterfaceGUID} '{CDCC0F94-4DD0-4F25-B441-6AE55D5C7466}',
     {taListInterfaceName} 'IJclWideStrList',
     {taListInterfaceGUID} '{C9955874-6AC0-4CE0-8CC0-606A3F1702C6}',
     {taSortProcedureName} 'TWideStrSortProc',
     {taArrayInterfaceName} 'IJclWideStrArray',
     {taArrayInterfaceGUID} '{3CE09F9A-5CB4-4867-80D5-C2313D278D69}',
     {taArrayListClassName} 'TJclWideStrArrayList',
     {taArrayIteratorClassName} 'TJclWideStrArrayIterator',
     {taLinkedListItemClassName} 'TJclWideStrLinkedListItem',
     {taLinkedListClassName} 'TJclWideStrLinkedList',
     {taLinkedListIteratorClassName} 'TJclWideStrLinkedListIterator',
     {taVectorClassName} 'TJclWideStrVector',
     {taVectorIteratorClassName} 'TJclWideStrVectorIterator',
     {taSetInterfaceName} 'IJclWideStrSet',
     {taSetInterfaceGUID} '{08009E0A-ABDD-46AB-8CEE-407D4723E17C}',
     {taArraySetClassName} 'TJclWideStrArraySet',
     {taTreeIteratorInterfaceName} 'IJclWideStrTreeIterator',
     {taTreeIteratorInterfaceGUID} '{B3168A3B-5A90-4ABF-855F-3D2B3AB6EE7F}',
     {taTreeInterfaceName} 'IJclWideStrTree',
     {taTreeInterfaceGUID} '{E325615A-7A20-4788-87FA-9051002CCD91}',
     {taTreeNodeClassName} 'TJclWideStrTreeNode',
     {taTreeClassName} 'TJclWideStrTree',
     {taTreeBaseIteratorClassName} 'TJclWideStrTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderWideStrTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderWideStrTreeIterator',
     {taQueueInterfaceName} 'IJclWideStrQueue',
     {taQueueInterfaceGUID} '{058BBFB7-E9B9-44B5-B676-D5B5B9A79BEF}',
     {taQueueClassName} 'TJclWideStrQueue',
     {taSortedSetInterfaceName} 'IJclWideStrSortedSet',
     {taSortedSetInterfaceGUID} '{ED9567E2-C1D3-4C00-A1D4-90D5C7E27C2D}',
     {taStackInterfaceName} 'IJclWideStrStack',
     {taStackInterfaceGUID} '{B2C3B165-33F1-4B7D-A2EC-0B19D12CE33C}',
     {taStackClassName} 'TJclWideStrStack'
    );

  UnicodeStringKnownType: TKnownTypeAttributes =
    ({taTypeName} 'UnicodeString',
     {taCondition} 'SUPPORTS_UNICODE_STRING',
     {taDefines} 'REFCOUNTED',
     {taUndefs} '',
     {taAlias} 'string',
     {taAliasCondition} 'CONTAINER_UNICODESTR',
     {taDefaultValue} '''''',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclUnicodeStrOwner',
     {taOwnershipInterfaceGUID} '{07F402E6-DD97-4AA4-83D8-4CCD419FCCFC}',
     {taReleaserName} 'FreeString',
     {taReleaseEventName} 'OnFreeString',
     {taReleaseEventTypeName} 'TFreeUnicodeStrEvent',
     {taGetterName} 'GetString',
     {taSetterName} 'SetString',
     {taParameterName} 'AString',
     {taDynArrayTypeName} 'TDynUnicodeStringArray',
     {taArrayName} 'Strings',
     {taBaseContainer} 'TJclUnicodeStrAbstractContainer',
     {taBaseCollection} 'TJclUnicodeStrAbstractCollection',
     {taIterateProcedureName} 'TUnicodeStrIterateProcedure',
     {taApplyFunctionName} 'TUnicodeStrApplyFunction',
     {taCompareFunctionName} 'TUnicodeStrCompare',
     {taSimpleCompareFunctionName} 'UnicodeStrSimpleCompare',
     {taEqualityCompareFunctionName} 'TUnicodeStrEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'UnicodeStrSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TUnicodeStrHashConvert',
     {taSimpleHashConvertFunctionName} 'UnicodeStrSimpleHashConvert',
     {taContainerInterfaceName} 'IJclUnicodeStrContainer',
     {taContainerInterfaceGUID} '{619BA29F-5E05-464D-B472-1C8453DBC707}',
     {taFlatContainerInterfaceName} 'IJclUnicodeStrFlatContainer',
     {taFlatContainerInterfaceGUID} '{3343D73E-4ADC-458E-8289-A4B83D1479D1}',
     {taEqualityComparerInterfaceName} 'IJclUnicodeStrEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{EDFCC1C7-79DB-4F58-BD64-5016B44EEAC0}',
     {taComparerInterfaceName} 'IJclUnicodeStrComparer',
     {taComparerInterfaceGUID} '{E81E2705-0CA0-4DBD-BECC-5F9AA623A6E4}',
     {taHashConverterInterfaceName} 'IJclUnicodeStrHashConverter',
     {taHashConverterInterfaceGUID} '{08CD8171-DBAF-405F-9802-46D955C8BBE6}',
     {taIteratorInterfaceName} 'IJclUnicodeStrIterator',
     {taIteratorInterfaceGUID} '{B913FFDC-792A-48FB-B58E-763EFDEBA15C}',
     {taBinaryTreeIteratorInterfaceName} 'IJclUnicodeStrBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{CA32B126-AD4B-4C33-BC47-52B09FE093BE}',
     {taBinaryTreeNodeTypeName} 'TJclUnicodeStrBinaryNode',
     {taBinaryTreeClassName} 'TJclUnicodeStrBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclUnicodeStrBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderUnicodeStrBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderUnicodeStrBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderUnicodeStrBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclUnicodeStrCollection',
     {taCollectionInterfaceGUID} '{82EA7DDE-4EBF-4E0D-A380-CAF8A24C1A0D}',
     {taListInterfaceName} 'IJclUnicodeStrList',
     {taListInterfaceGUID} '{F4307EB4-D66E-4656-AC56-50883D0F2C83}',
     {taSortProcedureName} 'TUnicodeStrSortProc',
     {taArrayInterfaceName} 'IJclUnicodeStrArray',
     {taArrayInterfaceGUID} '{24312E5B-B61D-485C-9E57-AC36C93D8159}',
     {taArrayListClassName} 'TJclUnicodeStrArrayList',
     {taArrayIteratorClassName} 'TJclUnicodeStrArrayIterator',
     {taLinkedListItemClassName} 'TJclUnicodeStrLinkedListItem',
     {taLinkedListClassName} 'TJclUnicodeStrLinkedList',
     {taLinkedListIteratorClassName} 'TJclUnicodeStrLinkedListIterator',
     {taVectorClassName} 'TJclUnicodeStrVector',
     {taVectorIteratorClassName} 'TJclUnicodeStrVectorIterator',
     {taSetInterfaceName} 'IJclUnicodeStrSet',
     {taSetInterfaceGUID} '{440E9BCB-341F-40B6-8AED-479B2E98C92A}',
     {taArraySetClassName} 'TJclUnicodeStrArraySet',
     {taTreeIteratorInterfaceName} 'IJclUnicodeStrTreeIterator',
     {taTreeIteratorInterfaceGUID} '{0B0A60DE-0403-4EE1-B1F0-10D849924CF8}',
     {taTreeInterfaceName} 'IJclUnicodeStrTree',
     {taTreeInterfaceGUID} '{A378BC36-1FB1-4330-A335-037DD370E81B}',
     {taTreeNodeClassName} 'TJclUnicodeStrTreeNode',
     {taTreeClassName} 'TJclUnicodeStrTree',
     {taTreeBaseIteratorClassName} 'TJclUnicodeStrTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderUnicodeStrTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderUnicodeStrTreeIterator',
     {taQueueInterfaceName} 'IJclUnicodeStrQueue',
     {taQueueInterfaceGUID} '{94A09E52-424A-486E-846B-9C2C52DC3A8F}',
     {taQueueClassName} 'TJclUnicodeStrQueue',
     {taSortedSetInterfaceName} 'IJclUnicodeStrSortedSet',
     {taSortedSetInterfaceGUID} '{172BCD6F-D23C-4014-9C8C-A77A27D6E881}',
     {taStackInterfaceName} 'IJclUnicodeStrStack',
     {taStackInterfaceGUID} '{BC046C3D-E3D2-42BA-A96D-054834A70404}',
     {taStackClassName} 'TJclUnicodeStrStack'
    );

  StringKnownType: TKnownTypeAttributes =
    ({taTypeName} 'string',
     {taCondition} '',
     {taDefines} 'REFCOUNTED',
     {taUndefs} '',
     {taAlias} '',
     {taAliasCondition} '',
     {taDefaultValue} '''''',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclStrOwner',
     {taOwnershipInterfaceGUID} '',
     {taReleaserName} '',
     {taReleaseEventName} '',
     {taReleaseEventTypeName} 'TFreeStrEvent',
     {taGetterName} 'GetString',
     {taSetterName} 'SetString',
     {taParameterName} 'AString',
     {taDynArrayTypeName} 'TDynStringArray',
     {taArrayName} 'Strings',
     {taBaseContainer} '',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TStrIterateProcedure',
     {taApplyFunctionName} 'TStrApplyFunction',
     {taCompareFunctionName} 'TStrCompare',
     {taSimpleCompareFunctionName} 'StrSimpleCompare',
     {taEqualityCompareFunctionName} 'TStrEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'StrSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TStrHashConvert',
     {taSimpleHashConvertFunctionName} 'StrSimpleHashConvert',
     {taContainerInterfaceName} '',
     {taContainerInterfaceGUID} '',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclStrEqualityComparer',
     {taEqualityComparerInterfaceGUID} '',
     {taComparerInterfaceName} 'IJclStrComparer',
     {taComparerInterfaceGUID} '',
     {taHashConverterInterfaceName} 'IJclStrHashConverter',
     {taHashConverterInterfaceGUID} '',
     {taIteratorInterfaceName} 'IJclStrIterator',
     {taIteratorInterfaceGUID} '',
     {taBinaryTreeIteratorInterfaceName} 'IJclStrBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '',
     {taBinaryTreeNodeTypeName} 'TJclStrBinaryNode',
     {taBinaryTreeClassName} 'TJclStrBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclStrBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderStrBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderStrBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderStrBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclStrCollection',
     {taCollectionInterfaceGUID} '',
     {taListInterfaceName} 'IJclStrList',
     {taListInterfaceGUID} '',
     {taSortProcedureName} 'TStrSortProc',
     {taArrayInterfaceName} 'IJclStrArray',
     {taArrayInterfaceGUID} '',
     {taArrayListClassName} 'TJclStrArrayList',
     {taArrayIteratorClassName} 'TJclStrArrayIterator',
     {taLinkedListItemClassName} 'TJclStrLinkedListItem',
     {taLinkedListClassName} 'TJclStrLinkedList',
     {taLinkedListIteratorClassName} 'TJclStrLinkedListIterator',
     {taVectorClassName} 'TJclStrVector',
     {taVectorIteratorClassName} 'TJclStrVectorIterator',
     {taSetInterfaceName} 'IJclStrSet',
     {taSetInterfaceGUID} '',
     {taArraySetClassName} 'TJclStrArraySet',
     {taTreeIteratorInterfaceName} 'IJclStrTreeIterator',
     {taTreeIteratorInterfaceGUID} '',
     {taTreeInterfaceName} 'IJclStrTree',
     {taTreeInterfaceGUID} '',
     {taTreeNodeClassName} 'TJclStrTreeNode',
     {taTreeClassName} 'TJclStrTree',
     {taTreeBaseIteratorClassName} 'TJclStrTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderStrTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderStrTreeIterator',
     {taQueueInterfaceName} 'IJclStrQueue',
     {taQueueInterfaceGUID} '',
     {taQueueClassName} 'TJclStrQueue',
     {taSortedSetInterfaceName} 'IJclStrSortedSet',
     {taSortedSetInterfaceGUID} '',
     {taStackInterfaceName} 'IJclStrStack',
     {taStackInterfaceGUID} '',
     {taStackClassName} 'TJclStrStack'
    );

  SingleKnownType: TKnownTypeAttributes =
    ({taTypeName} 'Single',
     {taCondition} '',
     {taDefines} 'ZEROINIT',
     {taUndefs} 'REFCOUNTED',
     {taAlias} 'Float',
     {taAliasCondition} 'MATH_SINGLE_PRECISION',
     {taDefaultValue} '0.0',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclSingleOwner',
     {taOwnershipInterfaceGUID} '{B002C201-70D7-4FA8-B44A-6D18E82580E5}',
     {taReleaserName} 'FreeSingle',
     {taReleaseEventName} 'OnFreeSingle',
     {taReleaseEventTypeName} 'TFreeSingleEvent',
     {taGetterName} 'GetValue',
     {taSetterName} 'SetValue',
     {taParameterName} 'AValue',
     {taDynArrayTypeName} 'TDynSingleArray',
     {taArrayName} 'Values',
     {taBaseContainer} 'TJclSingleAbstractContainer',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TSingleIterateProcedure',
     {taApplyFunctionName} 'TSingleApplyFunction',
     {taCompareFunctionName} 'TSingleCompare',
     {taSimpleCompareFunctionName} 'SingleSimpleCompare',
     {taEqualityCompareFunctionName} 'TSingleEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'SingleSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TSingleHashConvert',
     {taSimpleHashConvertFunctionName} 'SingleSimpleHashConvert',
     {taContainerInterfaceName} 'IJclSingleContainer',
     {taContainerInterfaceGUID} '{22BE88BD-87D1-4B4D-9FAB-F1B6D555C6A9}',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclSingleEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{4835BC5B-1A87-4864-BFE1-778F3BAF26B1}',
     {taComparerInterfaceName} 'IJclSingleComparer',
     {taComparerInterfaceGUID} '{008225CE-075E-4450-B9DE-9863CB6D347C}',
     {taHashConverterInterfaceName} 'IJclSingleHashConverter',
     {taHashConverterInterfaceGUID} '{20F0E481-F1D2-48B6-A95D-FBB56AF119F5}',
     {taIteratorInterfaceName} 'IJclSingleIterator',
     {taIteratorInterfaceGUID} '{FD1124F8-CB2B-4AD7-B12D-C05702F4204B}',
     {taBinaryTreeIteratorInterfaceName} 'IJclSingleBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{BC6FFB13-FA1C-4077-8273-F25A3119168B}',
     {taBinaryTreeNodeTypeName} 'TJclSingleBinaryNode',
     {taBinaryTreeClassName} 'TJclSingleBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclSingleBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderSingleBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderSingleBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderSingleBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclSingleCollection',
     {taCollectionInterfaceGUID} '{1D34D474-6588-441E-B2B3-8C021A37ED89}',
     {taListInterfaceName} 'IJclSingleList',
     {taListInterfaceGUID} '{D081324C-70A4-4AAC-BA42-7557F0262826}',
     {taSortProcedureName} 'TSingleSortProc',
     {taArrayInterfaceName} 'IJclSingleArray',
     {taArrayInterfaceGUID} '{B96E2A4D-D750-4B65-B975-C619A05A29F6}',
     {taArrayListClassName} 'TJclSingleArrayList',
     {taArrayIteratorClassName} 'TJclSingleArrayIterator',
     {taLinkedListItemClassName} 'TJclSingleLinkedListItem',
     {taLinkedListClassName} 'TJclSingleLinkedList',
     {taLinkedListIteratorClassName} 'TJclSingleLinkedListIterator',
     {taVectorClassName} 'TJclSingleVector',
     {taVectorIteratorClassName} 'TJclSingleVectorIterator',
     {taSetInterfaceName} 'IJclSingleSet',
     {taSetInterfaceGUID} '{36E34A78-6A29-4503-97D5-4BF53538CEC0}',
     {taArraySetClassName} 'TJclSingleArraySet',
     {taTreeIteratorInterfaceName} 'IJclSingleTreeIterator',
     {taTreeIteratorInterfaceGUID} '{17BFDE9D-DBF7-4DC8-AC74-919C717B4726}',
     {taTreeInterfaceName} 'IJclSingleTree',
     {taTreeInterfaceGUID} '{A90A51BC-EBD7-40D3-B0A0-C9987E7A83D0}',
     {taTreeNodeClassName} 'TJclSingleTreeNode',
     {taTreeClassName} 'TJclSingleTree',
     {taTreeBaseIteratorClassName} 'TJclSingleTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderSingleTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderSingleTreeIterator',
     {taQueueInterfaceName} 'IJclSingleQueue',
     {taQueueInterfaceGUID} '{67D74314-9967-4C99-8A48-6E0ADD73EC29}',
     {taQueueClassName} 'TJclSingleQueue',
     {taSortedSetInterfaceName} 'IJclSingleSortedSet',
     {taSortedSetInterfaceGUID} '{65EDA801-9E04-4119-BF9E-D7DD4AF82144}',
     {taStackInterfaceName} 'IJclSingleStack',
     {taStackInterfaceGUID} '{8DCE45C8-B5B3-43AB-BA08-DAD531CEB9CF}',
     {taStackClassName} 'TJclSingleStack'
    );

  DoubleKnownType: TKnownTypeAttributes =
    ({taTypeName} 'Double',
     {taCondition} '',
     {taDefines} 'ZEROINIT',
     {taUndefs} 'REFCOUNTED',
     {taAlias} 'Float',
     {taAliasCondition} 'MATH_DOUBLE_PRECISION',
     {taDefaultValue} '0.0',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclDoubleOwner',
     {taOwnershipInterfaceGUID} '{3BEFEDB0-C904-4400-ABEF-40FC928BB258}',
     {taReleaserName} 'FreeDouble',
     {taReleaseEventName} 'OnFreeDouble',
     {taReleaseEventTypeName} 'TFreeDoubleEvent',
     {taGetterName} 'GetValue',
     {taSetterName} 'SetValue',
     {taParameterName} 'AValue',
     {taDynArrayTypeName} 'TDynDoubleArray',
     {taArrayName} 'Values',
     {taBaseContainer} 'TJclDoubleAbstractContainer',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TDoubleIterateProcedure',
     {taApplyFunctionName} 'TDoubleApplyFunction',
     {taCompareFunctionName} 'TDoubleCompare',
     {taSimpleCompareFunctionName} 'DoubleSimpleCompare',
     {taEqualityCompareFunctionName} 'TDoubleEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'DoubleSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TDoubleHashConvert',
     {taSimpleHashConvertFunctionName} 'DoubleSimpleHashConvert',
     {taContainerInterfaceName} 'IJclDoubleContainer',
     {taContainerInterfaceGUID} '{372B9354-DF6D-4CAA-A5A9-C50E1FEE5525}',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclDoubleEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{15F0A9F0-D5DC-4978-8CDB-53B6E510262C}',
     {taComparerInterfaceName} 'IJclDoubleComparer',
     {taComparerInterfaceGUID} '{BC245D7F-7EB9-43D0-81B4-EE215486A5AA}',
     {taHashConverterInterfaceName} 'IJclDoubleHashConverter',
     {taHashConverterInterfaceGUID} '{193A2881-535B-4AF4-B0C3-6845A2800F80}',
     {taIteratorInterfaceName} 'IJclDoubleIterator',
     {taIteratorInterfaceGUID} '{004C154A-281C-4DA7-BF64-F3EE80ACF640}',
     {taBinaryTreeIteratorInterfaceName} 'IJclDoubleBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{CE48083C-D60C-4315-BC14-8CE77AC3269E}',
     {taBinaryTreeNodeTypeName} 'TJclDoubleBinaryNode',
     {taBinaryTreeClassName} 'TJclDoubleBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclDoubleBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderDoubleBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderDoubleBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderDoubleBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclDoubleCollection',
     {taCollectionInterfaceGUID} '{E54C7717-C33A-4F1B-860C-4F60F303EAD3}',
     {taListInterfaceName} 'IJclDoubleList',
     {taListInterfaceGUID} '{ECA58515-3903-4312-9486-3214E03F35AB}',
     {taSortProcedureName} 'TDoubleSortProc',
     {taArrayInterfaceName} 'IJclDoubleArray',
     {taArrayInterfaceGUID} '{67E66324-9757-4E85-8ECD-53396910FB39}',
     {taArrayListClassName} 'TJclDoubleArrayList',
     {taArrayIteratorClassName} 'TJclDoubleArrayIterator',
     {taLinkedListItemClassName} 'TJclDoubleLinkedListItem',
     {taLinkedListClassName} 'TJclDoubleLinkedList',
     {taLinkedListIteratorClassName} 'TJclDoubleLinkedListIterator',
     {taVectorClassName} 'TJclDoubleVector',
     {taVectorIteratorClassName} 'TJclDoubleVectorIterator',
     {taSetInterfaceName} 'IJclDoubleSet',
     {taSetInterfaceGUID} '{4E1E4847-E934-4811-A26C-5FC8E772A623}',
     {taArraySetClassName} 'TJclDoubleArraySet',
     {taTreeIteratorInterfaceName} 'IJclDoubleTreeIterator',
     {taTreeIteratorInterfaceGUID} '{EB39B84E-D3C5-496E-A521-B8BF24579252}',
     {taTreeInterfaceName} 'IJclDoubleTree',
     {taTreeInterfaceGUID} '{69DA85B1-A0DD-407B-B5CF-5EB7C6D4B82D}',
     {taTreeNodeClassName} 'TJclDoubleTreeNode',
     {taTreeClassName} 'TJclDoubleTree',
     {taTreeBaseIteratorClassName} 'TJclDoubleTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderDoubleTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderDoubleTreeIterator',
     {taQueueInterfaceName} 'IJclDoubleQueue',
     {taQueueInterfaceGUID} '{FA1B6D25-3456-4963-87DC-5A2E53B2963F}',
     {taQueueClassName} 'TJclDoubleQueue',
     {taSortedSetInterfaceName} 'IJclDoubleSortedSet',
     {taSortedSetInterfaceGUID} '{DA0E689F-BAFE-4BCE-85E4-C38E780BC84C}',
     {taStackInterfaceName} 'IJclDoubleStack',
     {taStackInterfaceGUID} '{46DF2701-16F0-453C-B938-F04E9C1CEBF8}',
     {taStackClassName} 'TJclDoubleStack'
    );

  ExtendedKnownType: TKnownTypeAttributes =
    ({taTypeName} 'Extended',
     {taCondition} '',
     {taDefines} 'ZEROINIT',
     {taUndefs} 'REFCOUNTED',
     {taAlias} 'Float',
     {taAliasCondition} 'MATH_EXTENDED_PRECISION',
     {taDefaultValue} '0.0',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclExtendedOwner',
     {taOwnershipInterfaceGUID} '{4501B203-6784-479D-8A8E-FBE3E1249CCF}',
     {taReleaserName} 'FreeExtended',
     {taReleaseEventName} 'OnFreeExtended',
     {taReleaseEventTypeName} 'TFreeExtendedEvent',
     {taGetterName} 'GetValue',
     {taSetterName} 'SetValue',
     {taParameterName} 'AValue',
     {taDynArrayTypeName} 'TDynExtendedArray',
     {taArrayName} 'Values',
     {taBaseContainer} 'TJclExtendedAbstractContainer',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TExtendedIterateProcedure',
     {taApplyFunctionName} 'TExtendedApplyFunction',
     {taCompareFunctionName} 'TExtendedCompare',
     {taSimpleCompareFunctionName} 'ExtendedSimpleCompare',
     {taEqualityCompareFunctionName} 'TExtendedEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'ExtendedSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TExtendedHashConvert',
     {taSimpleHashConvertFunctionName} 'ExtendedSimpleHashConvert',
     {taContainerInterfaceName} 'IJclExtendedContainer',
     {taContainerInterfaceGUID} '{431A6482-FD5C-45A7-BE53-339A3CF75AC9}',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclExtendedEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{149883D5-4138-4570-8C5C-99F186B7E646}',
     {taComparerInterfaceName} 'IJclExtendedComparer',
     {taComparerInterfaceGUID} '{92657C66-C18D-4BF8-A538-A3B0140320BB}',
     {taHashConverterInterfaceName} 'IJclExtendedHashConverter',
     {taHashConverterInterfaceGUID} '{77CECDB9-2774-4FDC-8E5A-A80325626434}',
     {taIteratorInterfaceName} 'IJclExtendedIterator',
     {taIteratorInterfaceGUID} '{B89877A5-DED4-4CD9-AB90-C7D062111DE0}',
     {taBinaryTreeIteratorInterfaceName} 'IJclExtendedBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{8A9FAE2A-5EF5-4165-8E8D-51F2102A4580}',
     {taBinaryTreeNodeTypeName} 'TJclExtendedBinaryNode',
     {taBinaryTreeClassName} 'TJclExtendedBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclExtendedBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderExtendedBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderExtendedBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderExtendedBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclExtendedCollection',
     {taCollectionInterfaceGUID} '{2A1341CB-B997-4E3B-B1CA-6D60AE853C55}',
     {taListInterfaceName} 'IJclExtendedList',
     {taListInterfaceGUID} '{7463F954-F8DF-4B02-A284-FCB98746248E}',
     {taSortProcedureName} 'TExtendedSortProc',
     {taArrayInterfaceName} 'IJclExtendedArray',
     {taArrayInterfaceGUID} '{D43E8D18-26B3-41A2-8D52-ED7EA2FE1AB7}',
     {taArrayListClassName} 'TJclExtendedArrayList',
     {taArrayIteratorClassName} 'TJclExtendedArrayIterator',
     {taLinkedListItemClassName} 'TJclExtendedLinkedListItem',
     {taLinkedListClassName} 'TJclExtendedLinkedList',
     {taLinkedListIteratorClassName} 'TJclExtendedLinkedListIterator',
     {taVectorClassName} 'TJclExtendedVector',
     {taVectorIteratorClassName} 'TJclExtendedVectorIterator',
     {taSetInterfaceName} 'IJclExtendedSet',
     {taSetInterfaceGUID} '{3B9CF52D-1C49-4388-A7B3-9BEE1821FFD4}',
     {taArraySetClassName} 'TJclExtendedArraySet',
     {taTreeIteratorInterfaceName} 'IJclExtendedTreeIterator',
     {taTreeIteratorInterfaceGUID} '{1B40A544-FC5D-454C-8E42-CE17B015E65C}',
     {taTreeInterfaceName} 'IJclExtendedTree',
     {taTreeInterfaceGUID} '{9ACCCAFD-B617-43DC-AAF9-916BE324A17E}',
     {taTreeNodeClassName} 'TJclExtendedTreeNode',
     {taTreeClassName} 'TJclExtendedTree',
     {taTreeBaseIteratorClassName} 'TJclExtendedTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderExtendedTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderExtendedTreeIterator',
     {taQueueInterfaceName} 'IJclExtendedQueue',
     {taQueueInterfaceGUID} '{76F349C0-7681-4BE8-9E94-280C962780D8}',
     {taQueueClassName} 'TJclExtendedQueue',
     {taSortedSetInterfaceName} 'IJclExtendedSortedSet',
     {taSortedSetInterfaceGUID} '{A9875ED3-81A4-43A3-86BB-3429F51B278B}',
     {taStackInterfaceName} 'IJclExtendedStack',
     {taStackInterfaceGUID} '{A2A30585-F561-4757-ABE1-CA511AE72CC5}',
     {taStackClassName} 'TJclExtendedStack'
    );

  FloatKnownType: TKnownTypeAttributes =
    ({taTypeName} 'Float',
     {taCondition} '',
     {taDefines} 'ZEROINIT',
     {taUndefs} 'REFCOUNTED',
     {taAlias} '',
     {taAliasCondition} '',
     {taDefaultValue} '0.0',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclFloatOwner',
     {taOwnershipInterfaceGUID} '',
     {taReleaserName} '',
     {taReleaseEventName} '',
     {taReleaseEventTypeName} 'TFreeFloatEvent',
     {taGetterName} 'GetValue',
     {taSetterName} 'SetValue',
     {taParameterName} 'AValue',
     {taDynArrayTypeName} 'TDynFloatArray',
     {taArrayName} 'Values',
     {taBaseContainer} '',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TFloatIterateProcedure',
     {taApplyFunctionName} 'TFloatApplyFunction',
     {taCompareFunctionName} 'TFloatCompare',
     {taSimpleCompareFunctionName} 'FloatSimpleCompare',
     {taEqualityCompareFunctionName} 'TFloatEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'FloatSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TFloatHashConvert',
     {taSimpleHashConvertFunctionName} 'FloatSimpleHashConvert',
     {taContainerInterfaceName} 'IJclFloatContainer',
     {taContainerInterfaceGUID} '',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclFloatEqualityComparer',
     {taEqualityComparerInterfaceGUID} '',
     {taComparerInterfaceName} 'IJclFloatComparer',
     {taComparerInterfaceGUID} '',
     {taHashConverterInterfaceName} 'IJclFloatHashConverter',
     {taHashConverterInterfaceGUID} '',
     {taIteratorInterfaceName} 'IJclFloatIterator',
     {taIteratorInterfaceGUID} '',
     {taBinaryTreeIteratorInterfaceName} 'IJclFloatBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '',
     {taBinaryTreeNodeTypeName} 'TJclFloatBinaryNode',
     {taBinaryTreeClassName} 'TJclFloatBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclFloatBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderFloatBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderFloatBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderFloatBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclFloatCollection',
     {taCollectionInterfaceGUID} '',
     {taListInterfaceName} 'IJclFloatList',
     {taListInterfaceGUID} '',
     {taSortProcedureName} 'TFloatSortProc',
     {taArrayInterfaceName} 'IJclFloatArray',
     {taArrayInterfaceGUID} '',
     {taArrayListClassName} 'TJclFloatArrayList',
     {taArrayIteratorClassName} 'TJclFloatArrayIterator',
     {taLinkedListItemClassName} 'TJclFloatLinkedListItem',
     {taLinkedListClassName} 'TJclFloatLinkedList',
     {taLinkedListIteratorClassName} 'TJclFloatLinkedListIterator',
     {taVectorClassName} 'TJclFloatVector',
     {taVectorIteratorClassName} 'TJclFloatVectorIterator',
     {taSetInterfaceName} 'IJclFloatSet',
     {taSetInterfaceGUID} '',
     {taArraySetClassName} 'TJclFloatArraySet',
     {taTreeIteratorInterfaceName} 'IJclFloatTreeIterator',
     {taTreeIteratorInterfaceGUID} '',
     {taTreeInterfaceName} 'IJclFloatTree',
     {taTreeInterfaceGUID} '',
     {taTreeNodeClassName} 'TJclFloatTreeNode',
     {taTreeClassName} 'TJclFloatTree',
     {taTreeBaseIteratorClassName} 'TJclFloatTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderFloatTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderFloatTreeIterator',
     {taQueueInterfaceName} 'IJclFloatQueue',
     {taQueueInterfaceGUID} '',
     {taQueueClassName} 'TJclFloatQueue',
     {taSortedSetInterfaceName} 'IJclFloatSortedSet',
     {taSortedSetInterfaceGUID} '',
     {taStackInterfaceName} 'IJclFloatStack',
     {taStackInterfaceGUID} '',
     {taStackClassName} 'TJclFloatStack'
    );

  IntegerKnownType: TKnownTypeAttributes =
    ({taTypeName} 'Integer',
     {taCondition} '',
     {taDefines} 'ZEROINIT',
     {taUndefs} 'REFCOUNTED',
     {taAlias} '',
     {taAliasCondition} '',
     {taDefaultValue} '0',
     {taConstKeyword} '',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclIntegerOwner',
     {taOwnershipInterfaceGUID} '{00E37ECB-0FF0-4833-8143-EB7FBEF9E208}',
     {taReleaserName} 'FreeInteger',
     {taReleaseEventName} 'OnFreeInteger',
     {taReleaseEventTypeName} 'TFreeIntegerEvent',
     {taGetterName} 'GetValue',
     {taSetterName} 'SetValue',
     {taParameterName} 'AValue',
     {taDynArrayTypeName} 'TDynIntegerArray',
     {taArrayName} 'Values',
     {taBaseContainer} 'TJclIntegerAbstractContainer',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TIntegerIterateProcedure',
     {taApplyFunctionName} 'TIntegerApplyFunction',
     {taCompareFunctionName} 'TIntegerCompare',
     {taSimpleCompareFunctionName} 'IntegerSimpleCompare',
     {taEqualityCompareFunctionName} 'TIntegerEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'IntegerSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TIntegerHashConvert',
     {taSimpleHashConvertFunctionName} 'IntegerSimpleHashConvert',
     {taContainerInterfaceName} '',
     {taContainerInterfaceGUID} '',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclIntegerEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{AABC35E6-A779-4A44-B748-27BFCB34FDFB}',
     {taComparerInterfaceName} 'IJclIntegerComparer',
     {taComparerInterfaceGUID} '{362C3A6A-CBC1-4D5F-8652-158913DC9865}',
     {taHashConverterInterfaceName} 'IJclIntegerHashConverter',
     {taHashConverterInterfaceGUID} '{92C540B2-C16C-47E4-995A-644BE71878B1}',
     {taIteratorInterfaceName} 'IJclIntegerIterator',
     {taIteratorInterfaceGUID} '{1406A991-4574-48A1-83FE-2EDCA03908BE}',
     {taBinaryTreeIteratorInterfaceName} 'IJclIntegerBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{FE2BF57D-D10D-4B0C-903D-BB61700FBA0A}',
     {taBinaryTreeNodeTypeName} 'TJclIntegerBinaryNode',
     {taBinaryTreeClassName} 'TJclIntegerBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclIntegerBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderIntegerBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderIntegerBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderIntegerBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclIntegerCollection',
     {taCollectionInterfaceGUID} '{AF69890D-22D1-4D89-8FFD-5FAD7E0638BA}',
     {taListInterfaceName} 'IJclIntegerList',
     {taListInterfaceGUID} '{339BE91B-557D-4CE0-A854-1CBD4FE31725}',
     {taSortProcedureName} 'TIntegerSortProc',
     {taArrayInterfaceName} 'IJclIntegerArray',
     {taArrayInterfaceGUID} '{2B7C8B33-C0BD-4EC3-9764-63866E174781}',
     {taArrayListClassName} 'TJclIntegerArrayList',
     {taArrayIteratorClassName} 'TJclIntegerArrayIterator',
     {taLinkedListItemClassName} 'TJclIntegerLinkedListItem',
     {taLinkedListClassName} 'TJclIntegerLinkedList',
     {taLinkedListIteratorClassName} 'TJclIntegerLinkedListIterator',
     {taVectorClassName} 'TJclIntegerVector',
     {taVectorIteratorClassName} 'TJclIntegerVectorIterator',
     {taSetInterfaceName} 'IJclIntegerSet',
     {taSetInterfaceGUID} '{5E4D29AF-F508-465B-9008-D11FF82F25FE}',
     {taArraySetClassName} 'TJclIntegerArraySet',
     {taTreeIteratorInterfaceName} 'IJclIntegerTreeIterator',
     {taTreeIteratorInterfaceGUID} '{88EDC5C5-CA41-41AF-9838-AA19D07E69F5}',
     {taTreeInterfaceName} 'IJclIntegerTree',
     {taTreeInterfaceGUID} '{40A6F934-E5F3-4C74-AC02-227035C8C3C6}',
     {taTreeNodeClassName} 'TJclIntegerTreeNode',
     {taTreeClassName} 'TJclIntegerTree',
     {taTreeBaseIteratorClassName} 'TJclIntegerTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderIntegerTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderIntegerTreeIterator',
     {taQueueInterfaceName} 'IJclIntegerQueue',
     {taQueueInterfaceGUID} '{4C4E174E-5D19-44CE-A248-B5589A9B68DF}',
     {taQueueClassName} 'TJclIntegerQueue',
     {taSortedSetInterfaceName} 'IJclIntegerSortedSet',
     {taSortedSetInterfaceGUID} '{E086C54B-4FA3-426D-AC4E-FF8E8CA3D663}',
     {taStackInterfaceName} 'IJclIntegerStack',
     {taStackInterfaceGUID} '{9190BF0E-5B0C-4D6C-A107-20A933C9B56A}',
     {taStackClassName} 'TJclIntegerStack'
    );

  CardinalKnownType: TKnownTypeAttributes =
    ({taTypeName} 'Cardinal',
     {taCondition} '',
     {taDefines} 'ZEROINIT',
     {taUndefs} 'REFCOUNTED',
     {taAlias} '',
     {taAliasCondition} '',
     {taDefaultValue} '0',
     {taConstKeyword} '',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclCardinalOwner',
     {taOwnershipInterfaceGUID} '{27B3EDEF-0ACD-4592-95F2-52A1DF5E7A39}',
     {taReleaserName} 'FreeCardinal',
     {taReleaseEventName} 'OnFreeCardinal',
     {taReleaseEventTypeName} 'TFreeCardinalEvent',
     {taGetterName} 'GetValue',
     {taSetterName} 'SetValue',
     {taParameterName} 'AValue',
     {taDynArrayTypeName} 'TDynCardinalArray',
     {taArrayName} 'Values',
     {taBaseContainer} 'TJclCardinalAbstractContainer',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TCardinalIterateProcedure',
     {taApplyFunctionName} 'TCardinalApplyFunction',
     {taCompareFunctionName} 'TCardinalCompare',
     {taSimpleCompareFunctionName} 'CardinalSimpleCompare',
     {taEqualityCompareFunctionName} 'TCardinalEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'CardinalSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TCardinalHashConvert',
     {taSimpleHashConvertFunctionName} 'CardinalSimpleHashConvert',
     {taContainerInterfaceName} '',
     {taContainerInterfaceGUID} '',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclCardinalEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{B2DECF81-6ECE-4D9F-80E1-C8C884DB407C}',
     {taComparerInterfaceName} 'IJclCardinalComparer',
     {taComparerInterfaceGUID} '{56E44725-00B9-4530-8CC2-72DCA9171EE0}',
     {taHashConverterInterfaceName} 'IJclCardinalHashConverter',
     {taHashConverterInterfaceGUID} '{2DF04C8A-16B8-4712-BC5D-AD35014EC9F7}',
     {taIteratorInterfaceName} 'IJclCardinalIterator',
     {taIteratorInterfaceGUID} '{72847A34-C8C4-4592-9447-CEB8161E33AD}',
     {taBinaryTreeIteratorInterfaceName} 'IJclCardinalBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{AAA358F5-95A1-480F-8E2A-09028BA6C397}',
     {taBinaryTreeNodeTypeName} 'TJclCardinalBinaryNode',
     {taBinaryTreeClassName} 'TJclCardinalBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclCardinalBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderCardinalBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderCardinalBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderCardinalBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclCardinalCollection',
     {taCollectionInterfaceGUID} '{CFBD0344-58C8-4FA2-B4D7-D21D77DFBF80}',
     {taListInterfaceName} 'IJclCardinalList',
     {taListInterfaceGUID} '{02B09EA8-DE6F-4A18-AA57-C3533E6AC4E3}',
     {taSortProcedureName} 'TCardinalSortProc',
     {taArrayInterfaceName} 'IJclCardinalArray',
     {taArrayInterfaceGUID} '{C451F2F8-65C6-4C29-99A0-CC9C15356418}',
     {taArrayListClassName} 'TJclCardinalArrayList',
     {taArrayIteratorClassName} 'TJclCardinalArrayIterator',
     {taLinkedListItemClassName} 'TJclCardinalLinkedListItem',
     {taLinkedListClassName} 'TJclCardinalLinkedList',
     {taLinkedListIteratorClassName} 'TJclCardinalLinkedListIterator',
     {taVectorClassName} 'TJclCardinalVector',
     {taVectorIteratorClassName} 'TJclCardinalVectorIterator',
     {taSetInterfaceName} 'IJclCardinalSet',
     {taSetInterfaceGUID} '{09858637-CE8F-42E6-97E0-2786CD68387B}',
     {taArraySetClassName} 'TJclCardinalArraySet',
     {taTreeIteratorInterfaceName} 'IJclCardinalTreeIterator',
     {taTreeIteratorInterfaceGUID} '{FDBF493F-F79D-46EB-A59D-7193B6E6A860}',
     {taTreeInterfaceName} 'IJclCardinalTree',
     {taTreeInterfaceGUID} '{6C76C668-50C8-42A2-B72B-79BF102E270D}',
     {taTreeNodeClassName} 'TJclCardinalTreeNode',
     {taTreeClassName} 'TJclCardinalTree',
     {taTreeBaseIteratorClassName} 'TJclCardinalTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderCardinalTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderCardinalTreeIterator',
     {taQueueInterfaceName} 'IJclCardinalQueue',
     {taQueueInterfaceGUID} '{CC1D4358-E259-4FB0-BA83-5180A0F8A6C0}',
     {taQueueClassName} 'TJclCardinalQueue',
     {taSortedSetInterfaceName} 'IJclCardinalSortedSet',
     {taSortedSetInterfaceGUID} '{2D7995C6-A784-48B6-87E9-55D394A72362}',
     {taStackInterfaceName} 'IJclCardinalStack',
     {taStackInterfaceGUID} '{94F9EDB3-602B-49CE-9990-0AFDAC556F83}',
     {taStackClassName} 'TJclCardinalStack'
    );

  Int64KnownType: TKnownTypeAttributes =
    ({taTypeName} 'Int64',
     {taCondition} '',
     {taDefines} 'ZEROINIT',
     {taUndefs} 'REFCOUNTED',
     {taAlias} '',
     {taAliasCondition} '',
     {taDefaultValue} '0',
     {taConstKeyword} 'const ',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclInt64Owner',
     {taOwnershipInterfaceGUID} '{7D4A1375-057A-42B8-8DAA-52DE30058864}',
     {taReleaserName} 'FreeInt64',
     {taReleaseEventName} 'OnFreeInt64',
     {taReleaseEventTypeName} 'TFreeInt64Event',
     {taGetterName} 'GetValue',
     {taSetterName} 'SetValue',
     {taParameterName} 'AValue',
     {taDynArrayTypeName} 'TDynInt64Array',
     {taArrayName} 'Values',
     {taBaseContainer} 'TJclInt64AbstractContainer',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TInt64IterateProcedure',
     {taApplyFunctionName} 'TInt64ApplyFunction',
     {taCompareFunctionName} 'TInt64Compare',
     {taSimpleCompareFunctionName} 'Int64SimpleCompare',
     {taEqualityCompareFunctionName} 'TInt64EqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'Int64SimpleEqualityCompare',
     {taHashConvertFunctionName} 'TInt64HashConvert',
     {taSimpleHashConvertFunctionName} 'Int64SimpleHashConvert',
     {taContainerInterfaceName} '',
     {taContainerInterfaceGUID} '',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclInt64EqualityComparer',
     {taEqualityComparerInterfaceGUID} '{8B2825E2-0C81-42BA-AC0D-104344CE7E56}',
     {taComparerInterfaceName} 'IJclInt64Comparer',
     {taComparerInterfaceGUID} '{87C935BF-3A42-4F1F-A474-9C823939EE1C}',
     {taHashConverterInterfaceName} 'IJclInt64HashConverter',
     {taHashConverterInterfaceGUID} '{96CF2A71-9185-4E26-B283-457ABC3584E7}',
     {taIteratorInterfaceName} 'IJclInt64Iterator',
     {taIteratorInterfaceGUID} '{573E5A51-BF76-43D7-9F93-46305BED20A8}',
     {taBinaryTreeIteratorInterfaceName} 'IJclInt64BinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{5605E164-5CDD-40B1-9323-DE1CB584E289}',
     {taBinaryTreeNodeTypeName} 'TJclInt64BinaryNode',
     {taBinaryTreeClassName} 'TJclInt64BinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclInt64BinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderInt64BinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderInt64BinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderInt64BinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclInt64Collection',
     {taCollectionInterfaceGUID} '{93A45BDE-3C4C-48D6-9874-5322914DFDDA}',
     {taListInterfaceName} 'IJclInt64List',
     {taListInterfaceGUID} '{E8D49200-91D3-4BD0-A59B-B93EC7E2074B}',
     {taSortProcedureName} 'TInt64SortProc',
     {taArrayInterfaceName} 'IJclInt64Array',
     {taArrayInterfaceGUID} '{D947C43D-2D04-442A-A707-39EDE7D96FC9}',
     {taArrayListClassName} 'TJclInt64ArrayList',
     {taArrayIteratorClassName} 'TJclInt64ArrayIterator',
     {taLinkedListItemClassName} 'TJclInt64LinkedListItem',
     {taLinkedListClassName} 'TJclInt64LinkedList',
     {taLinkedListIteratorClassName} 'TJclInt64LinkedListIterator',
     {taVectorClassName} 'TJclInt64Vector',
     {taVectorIteratorClassName} 'TJclInt64VectorIterator',
     {taSetInterfaceName} 'IJclInt64Set',
     {taSetInterfaceGUID} '{ACB3127A-48EE-4F9F-B988-6AE9057780E9}',
     {taArraySetClassName} 'TJclInt64ArraySet',
     {taTreeIteratorInterfaceName} 'IJclInt64TreeIterator',
     {taTreeIteratorInterfaceGUID} '{C5A5E504-E19B-43AC-90B9-E4B8984BFA23}',
     {taTreeInterfaceName} 'IJclInt64Tree',
     {taTreeInterfaceGUID} '{1925B973-8B75-4A79-A993-DF2598FF19BE}',
     {taTreeNodeClassName} 'TJclInt64TreeNode',
     {taTreeClassName} 'TJclInt64Tree',
     {taTreeBaseIteratorClassName} 'TJclInt64TreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderInt64TreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderInt64TreeIterator',
     {taQueueInterfaceName} 'IJclInt64Queue',
     {taQueueInterfaceGUID} '{96B620BB-9A90-43D5-82A7-2D818A11C8E1}',
     {taQueueClassName} 'TJclInt64Queue',
     {taSortedSetInterfaceName} 'IJclInt64SortedSet',
     {taSortedSetInterfaceGUID} '{4C1C3FCA-6169-4A2F-B044-91AC2AA2E954}',
     {taStackInterfaceName} 'IJclInt64Stack',
     {taStackInterfaceGUID} '{D689EB8F-2746-40E9-AD1B-7E656475FC64}',
     {taStackClassName} 'TJclInt64Stack'
    );

  PointerKnownType: TKnownTypeAttributes =
    ({taTypeName} 'Pointer',
     {taCondition} '',
     {taDefines} 'ZEROINIT',
     {taUndefs} 'REFCOUNTED',
     {taAlias} '',
     {taAliasCondition} '',
     {taDefaultValue} 'nil',
     {taConstKeyword} '',
     {taOwnershipParameter} '',
     {taOwnershipInterfaceName} 'IJclPtrOwner',
     {taOwnershipInterfaceGUID} '{28340328-34AD-4632-9BAC-A7387A822200}',
     {taReleaserName} 'FreePointer',
     {taReleaseEventName} 'OnFreePointer',
     {taReleaseEventTypeName} 'TFreePtrEvent',
     {taGetterName} 'GetPointer',
     {taSetterName} 'SetPointer',
     {taParameterName} 'APtr',
     {taDynArrayTypeName} 'TDynPointerArray',
     {taArrayName} 'Pointers',
     {taBaseContainer} 'TJclPtrAbstractContainer',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TPtrIterateProcedure',
     {taApplyFunctionName} 'TPtrApplyFunction',
     {taCompareFunctionName} 'TPtrCompare',
     {taSimpleCompareFunctionName} 'PtrSimpleCompare',
     {taEqualityCompareFunctionName} 'TPtrEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'PtrSimpleEqualityCompare',
     {taHashConvertFunctionName} 'TPtrHashConvert',
     {taSimpleHashConvertFunctionName} 'PtrSimpleHashConvert',
     {taContainerInterfaceName} '',
     {taContainerInterfaceGUID} '',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclPtrEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{C6B7CBF9-ECD9-4D70-85CC-4E2367A1D806}',
     {taComparerInterfaceName} 'IJclPtrComparer',
     {taComparerInterfaceGUID} '{85557D4C-A036-477E-BA73-B5EEF43A8696}',
     {taHashConverterInterfaceName} 'IJclPtrHashConverter',
     {taHashConverterInterfaceGUID} '{D704CC67-CFED-44E6-9504-65D5E468FCAF}',
     {taIteratorInterfaceName} 'IJclPtrIterator',
     {taIteratorInterfaceGUID} '{62B5501C-07AA-4D00-A85B-713B39912CDF}',
     {taBinaryTreeIteratorInterfaceName} 'IJclPtrBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{75D3DF0D-C491-43F7-B078-E658197E8051}',
     {taBinaryTreeNodeTypeName} 'TJclPtrBinaryNode',
     {taBinaryTreeClassName} 'TJclPtrBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclPtrBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderPtrBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderPtrBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderPtrBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclPtrCollection',
     {taCollectionInterfaceGUID} '{02E909A7-5B1D-40D4-82EA-A0CD97D5C811}',
     {taListInterfaceName} 'IJclPtrList',
     {taListInterfaceGUID} '{2CF5CF1F-C012-480C-A4CE-38BDAFB15D05}',
     {taSortProcedureName} 'TPtrSortProc',
     {taArrayInterfaceName} 'IJclPtrArray',
     {taArrayInterfaceGUID} '{D43E8D18-26B3-41A2-8D52-ED7EA2FE1AB7}',
     {taArrayListClassName} 'TJclPtrArrayList',
     {taArrayIteratorClassName} 'TJclPtrArrayIterator',
     {taLinkedListItemClassName} 'TJclPtrLinkedListItem',
     {taLinkedListClassName} 'TJclPtrLinkedList',
     {taLinkedListIteratorClassName} 'TJclPtrLinkedListIterator',
     {taVectorClassName} 'TJclPtrVector',
     {taVectorIteratorClassName} 'TJclPtrVectorIterator',
     {taSetInterfaceName} 'IJclPtrSet',
     {taSetInterfaceGUID} '{26717C68-4F83-4CCB-973A-7324FBD09632}',
     {taArraySetClassName} 'TJclPtrArraySet',
     {taTreeIteratorInterfaceName} 'IJclPtrTreeIterator',
     {taTreeIteratorInterfaceGUID} '{ED4C08E6-60FC-4ED3-BD19-E6605B9BD943}',
     {taTreeInterfaceName} 'IJclPtrTree',
     {taTreeInterfaceGUID} '{2C1ACA3E-3F23-4E3C-984D-151CF9776E14}',
     {taTreeNodeClassName} 'TJclPtrTreeNode',
     {taTreeClassName} 'TJclPtrTree',
     {taTreeBaseIteratorClassName} 'TJclPtrTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderPtrTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderPtrTreeIterator',
     {taQueueInterfaceName} 'IJclPtrQueue',
     {taQueueInterfaceGUID} '{1052DD37-3035-4C44-A793-54AC4B9C0B29}',
     {taQueueClassName} 'TJclPtrQueue',
     {taSortedSetInterfaceName} 'IJclPtrSortedSet',
     {taSortedSetInterfaceGUID} '{F3A3183C-0820-425C-9446-E0838F0ADAD8}',
     {taStackInterfaceName} 'IJclPtrStack',
     {taStackInterfaceGUID} '{AD11D06C-E0E1-4EDE-AA2F-BC8BDD972B73}',
     {taStackClassName} 'TJclPtrStack'
    );

  TObjectKnownType: TKnownTypeAttributes =
    ({taTypeName} 'TObject',
     {taCondition} '',
     {taDefines} 'OWNABLE;ZEROINIT',
     {taUndefs} 'REFCOUNTED',
     {taAlias} '',
     {taAliasCondition} '',
     {taDefaultValue} 'nil',
     {taConstKeyword} '',
     {taOwnershipParameter} 'AOwnsObjects',
     {taOwnershipInterfaceName} 'IJclObjectOwner',
     {taOwnershipInterfaceGUID} '{5157EA13-924E-4A56-995D-36956441025C}',
     {taReleaserName} 'FreeObject',
     {taReleaseEventName} 'OnFreeObject',
     {taReleaseEventTypeName} 'TFreeObjectEvent',
     {taGetterName} 'GetObject',
     {taSetterName} 'SetObject',
     {taParameterName} 'AObject',
     {taDynArrayTypeName} 'TDynObjectArray',
     {taArrayName} 'Objects',
     {taBaseContainer} 'TJclAbstractContainer',
     {taBaseCollection} '',
     {taIterateProcedureName} 'TIterateProcedure',
     {taApplyFunctionName} 'TApplyFunction',
     {taCompareFunctionName} 'TCompare',
     {taSimpleCompareFunctionName} 'SimpleCompare',
     {taEqualityCompareFunctionName} 'TEqualityCompare',
     {taSimpleEqualityCompareFunctionName} 'SimpleEqualityCompare',
     {taHashConvertFunctionName} 'THashConvert',
     {taSimpleHashConvertFunctionName} 'SimpleHashConvert',
     {taContainerInterfaceName} '',
     {taContainerInterfaceGUID} '',
     {taFlatContainerInterfaceName} '',
     {taFlatContainerInterfaceGUID} '',
     {taEqualityComparerInterfaceName} 'IJclEqualityComparer',
     {taEqualityComparerInterfaceGUID} '{82C67986-8365-44AB-8D56-7B0CF4F6B918}',
     {taComparerInterfaceName} 'IJclComparer',
     {taComparerInterfaceGUID} '{7B376028-56DC-4C4A-86A9-1AC19E3EDF75}',
     {taHashConverterInterfaceName} 'IJclHashConverter',
     {taHashConverterInterfaceGUID} '{2D0DD6F4-162E-41D6-8A34-489E7EACABCD}',
     {taIteratorInterfaceName} 'IJclIterator',
     {taIteratorInterfaceGUID} '{997DF9B7-9AA2-4239-8B94-14DFFD26D790}',
     {taBinaryTreeIteratorInterfaceName} 'IJclBinaryTreeIterator',
     {taBinaryTreeIteratorInterfaceGUID} '{821DE28D-631C-4F23-A0B2-CC0F35B4C64D}',
     {taBinaryTreeNodeTypeName} 'TJclBinaryNode',
     {taBinaryTreeClassName} 'TJclBinaryTree',
     {taBinaryTreeBaseIteratorClassName} 'TJclBinaryTreeIterator',
     {taBinaryTreePreOrderIteratorClassName} 'TJclPreOrderBinaryTreeIterator',
     {taBinaryTreeInOrderIteratorClassName} 'TJclInOrderBinaryTreeIterator',
     {taBinaryTreePostOrderIteratorClassName} 'TJclPostOrderBinaryTreeIterator',
     {taCollectionInterfaceName} 'IJclCollection',
     {taCollectionInterfaceGUID} '{58947EF1-CD21-4DD1-AE3D-225C3AAD7EE5}',
     {taListInterfaceName} 'IJclList',
     {taListInterfaceGUID} '{8ABC70AC-5C06-43EA-AFE0-D066379BCC28}',
     {taSortProcedureName} 'TSortProc',
     {taArrayInterfaceName} 'IJclArray',
     {taArrayInterfaceGUID} '{A69F6D35-54B2-4361-852E-097ED75E648A}',
     {taArrayListClassName} 'TJclArrayList',
     {taArrayIteratorClassName} 'TJclArrayIterator',
     {taLinkedListItemClassName} 'TJclLinkedListItem',
     {taLinkedListClassName} 'TJclLinkedList',
     {taLinkedListIteratorClassName} 'TJclLinkedListIterator',
     {taVectorClassName} 'TJclVector',
     {taVectorIteratorClassName} 'TJclVectorIterator',
     {taSetInterfaceName} 'IJclSet',
     {taSetInterfaceGUID} '{0B7CDB90-8588-4260-A54C-D87101C669EA}',
     {taArraySetClassName} 'TJclArraySet',
     {taTreeIteratorInterfaceName} 'IJclTreeIterator',
     {taTreeIteratorInterfaceGUID} '{8B4863B0-B6B9-426E-B5B8-7AF71D264237}',
     {taTreeInterfaceName} 'IJclTree',
     {taTreeInterfaceGUID} '{B0C658CC-FEF5-4178-A4C5-442C0DEDE207}',
     {taTreeNodeClassName} 'TJclTreeNode',
     {taTreeClassName} 'TJclTree',
     {taTreeBaseIteratorClassName} 'TJclTreeIterator',
     {taTreePreOrderIteratorClassName} 'TJclPreOrderTreeIterator',
     {taTreePostOrderIteratorClassName} 'TJclPostOrderTreeIterator',
     {taQueueInterfaceName} 'IJclQueue',
     {taQueueInterfaceGUID} '{7D0F9DE4-71EA-46EF-B879-88BCFD5D9610}',
     {taQueueClassName} 'TJclQueue',
     {taSortedSetInterfaceName} 'IJclSortedSet',
     {taSortedSetInterfaceGUID} '{A3D23E76-ADE9-446C-9B97-F49FCE895D9F}',
     {taStackInterfaceName} 'IJclStack',
     {taStackInterfaceGUID} '{E07E0BD8-A831-41B9-B9A0-7199BD4873B9}',
     {taStackClassName} 'TJclStack'
    );

  KnownAllTypes: array[0..13] of PKnownTypeAttributes =
    ( @IInterfaceKnownType,
      @AnsiStringKnownType,
      @WideStringKnownType,
      @UnicodeStringKnownType,
      @StringKnownType,
      @SingleKnownType,
      @DoubleKnownType,
      @ExtendedKnownType,
      @FloatKnownType,
      @IntegerKnownType,
      @CardinalKnownType,
      @Int64KnownType,
      @PointerKnownType,
      @TObjectKnownType );

  // same as previous, except without compiler magic types (string) and type aliases (float)
  KnownTrueTypes: array[0..11] of PKnownTypeAttributes =
    ( @IInterfaceKnownType,
      @AnsiStringKnownType,
      @WideStringKnownType,
      @UnicodeStringKnownType,
      @SingleKnownType,
      @DoubleKnownType,
      @ExtendedKnownType,
      @IntegerKnownType,
      @CardinalKnownType,
      @Int64KnownType,
      @PointerKnownType,
      @TObjectKnownType );

function IsKnownType(const TypeName: string): PKnownTypeAttributes;

{$IFDEF UNITVERSIONING}
const
  UnitVersioning: TUnitVersionInfo = (
    RCSfile: '$URL: https://jcl.svn.sourceforge.net/svnroot/jcl/tags/JCL-2.3-Build4197/jcl/source/common/JclPreProcessorContainerKnownTypes.pas $';
    Revision: '$Revision: 3594 $';
    Date: '$Date: 2011-09-02 23:25:25 +0200 (ven., 02 sept. 2011) $';
    LogPath: 'JCL\source\common';
    Extra: '';
    Data: nil
    );
{$ENDIF UNITVERSIONING}

implementation

uses
  {$IFDEF HAS_UNITSCOPE}
  System.SysUtils;
  {$ELSE ~HAS_UNITSCOPE}
  SysUtils;
  {$ENDIF ~HAS_UNITSCOPE}

function IsKnownType(const TypeName: string): PKnownTypeAttributes;
var
  I: Integer;
begin
  Result := nil;
  for I := Low(KnownAllTypes) to High(KnownAllTypes) do
    if SameText(TypeName, KnownAllTypes[I]^[taTypeName]) then
  begin
    Result := KnownAllTypes[I];
    Break;
  end;
end;

{$IFDEF UNITVERSIONING}
initialization
  RegisterUnitVersion(HInstance, UnitVersioning);

finalization
  UnregisterUnitVersion(HInstance);
{$ENDIF UNITVERSIONING}

end.
