/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// SetColor.cpp : t@C
//

#include "stdafx.h"
#include "BSch.h"
#include "SetColor.h"
#include ".\setcolor.h"


// CSetColor _CAO

IMPLEMENT_DYNAMIC(CSetColor, CDialog)
CSetColor::CSetColor(CWnd* pParent /*=NULL*/)
	: CDialog(CSetColor::IDD, pParent)
	, m_PRINTBG_WHITE(FALSE)
{
}

CSetColor::~CSetColor()
{
}

void CSetColor::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_PRINTBG_WHITE, m_PRINTBG_WHITE);
}


BEGIN_MESSAGE_MAP(CSetColor, CDialog)
	ON_WM_CTLCOLOR()
	ON_LBN_SELCHANGE(IDC_LIST, OnLbnSelchangeList)
	ON_BN_CLICKED(IDC_CHANGE_COL, OnBnClickedChangeCol)
	ON_BN_CLICKED(IDC_DEFAULT_COLOR, OnBnClickedDefaultColor)
END_MESSAGE_MAP()


// CSetColor bZ[W nh

BOOL CSetColor::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO :  ɏǉĂ
	CString str;
	int index;
	CListBox* pList=(CListBox*)GetDlgItem(IDC_LIST);

	str.LoadString(IDS_COL_BG);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_BG);	


	str.LoadString(IDS_COL_JUNC);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_JUNC);	

	str.LoadString(IDS_COL_WIRE);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_WIRE);

	str.LoadString(IDS_COL_BUS);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_BUS);

	str.LoadString(IDS_COL_DASH);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_DASH);

	str.LoadString(IDS_COL_TAG);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_TAG);

	str.LoadString(IDS_COL_TAG_NAME);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_TAG_NAME);

	str.LoadString(IDS_COL_COMMENT);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_COMMENT);

	str.LoadString(IDS_COL_LABEL);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_LABEL);

	str.LoadString(IDS_COL_XOR);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_XOR);

	str.LoadString(IDS_COL_PART);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_PART);

	str.LoadString(IDS_COL_PART_PIN);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_PART_PIN);

	str.LoadString(IDS_COL_PART_PINNAME);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_PART_PINNAME);

	str.LoadString(IDS_COL_PART_PINNUM);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_PART_PINNUM);

	str.LoadString(IDS_COL_PART_NAME);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_PART_NAME);

	str.LoadString(IDS_COL_PART_NUM);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_PART_NUM);

	str.LoadString(IDS_COL_PART_FRAME);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_PART_FRAME);

	str.LoadString(IDS_COL_SHEET_FRAME);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_SHEET_FRAME);

	str.LoadString(IDS_COL_SHEET_GRID);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_SHEET_GRID);

	str.LoadString(IDS_COL_ZLPIN);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_ZLPIN);

	str.LoadString(IDS_COL_DARK);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_DARK);

	str.LoadString(IDS_COL_NC_MARK);
	index = pList->AddString(str);	pList->SetItemDataPtr(index,&m_COL_NC_MARK);

	str.LoadString(IDS_COL_QUICKPROPVIEW);
	index = pList->AddString(str); pList->SetItemDataPtr(index,&m_COL_QUICKPROPVIEW);

	str.LoadString(IDS_COL_TEMPFRAME_FOCUSED);
	index = pList->AddString(str); pList->SetItemDataPtr(index,&m_COL_TEMPFRAME_FOCUSED);

	str.LoadString(IDS_COL_TEMPFRAME_NOT_FOCUSED);
	index = pList->AddString(str); pList->SetItemDataPtr(index,&m_COL_TEMPFRAME_NOT_FOCUSED);

	pList->SetCurSel(0);
	OnLbnSelchangeList();


	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

HBRUSH CSetColor::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO :   DC ̑ύXĂB
	int id=pWnd->GetDlgCtrlID();
	if(nCtlColor == CTLCOLOR_STATIC && id==IDC_STATIC_COL){
		return (HBRUSH) m_brush;
	}
	// TODO :  lgpȂꍇ͕ʂ̃uVԂ܂B
	return hbr;
}

void CSetColor::OnLbnSelchangeList()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	CListBox* pList=(CListBox*)GetDlgItem(IDC_LIST);
	int index = pList->GetCurSel();
	if(index==-1) return;
	COLORREF col_STATIC = *((COLORREF*)pList->GetItemDataPtr(index));
	m_brush.DeleteObject();
	m_brush.CreateSolidBrush(col_STATIC);
	CStatic* pStatic=(CStatic*)GetDlgItem(IDC_STATIC_COL);
	pStatic->Invalidate();
}


void CSetColor::OnBnClickedChangeCol()
{
	// TODO : ɃR}h nh R[hǉ܂B
	COLORREF* pColRef;
	CListBox* pList=(CListBox*)GetDlgItem(IDC_LIST);
	int index = pList->GetCurSel();
	if(index==-1) return;
	pColRef = (COLORREF*)pList->GetItemDataPtr(index);
	CColorDialog dlg;
	dlg.m_cc.Flags |= CC_FULLOPEN | CC_RGBINIT;
	dlg.m_cc.rgbResult = *pColRef;
	if(dlg.DoModal()==IDOK){
		COLORREF col = dlg.m_cc.rgbResult;
		//if(index == 0 && col != RGB(255,255,255)){
		//	AfxMessageBox(IDS_BG_NOT_PRINT,MB_ICONEXCLAMATION|MB_OK);
		//}
		*pColRef = col;
		m_brush.DeleteObject();
		m_brush.CreateSolidBrush(*pColRef);
		CStatic* pStatic=(CStatic*)GetDlgItem(IDC_STATIC_COL);
		pStatic->Invalidate();
	}
}


void CSetColor::OnBnClickedDefaultColor()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	if(AfxMessageBox(IDS_DEFAULT_COLOR,MB_ICONEXCLAMATION|MB_OKCANCEL|MB_DEFBUTTON2)==IDOK){
		m_COL_BG			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","BG",COL_BG));
		m_COL_JUNC			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Junction",COL_JUNC));
		m_COL_WIRE			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Wire",COL_WIRE));
		m_COL_BUS			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Bus",COL_BUS));
		m_COL_DASH			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Dash",COL_DASH));
		m_COL_TAG			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Tag",COL_TAG));
		m_COL_TAG_NAME		=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","TagName",COL_TAG_NAME));
		m_COL_COMMENT		=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Comment",COL_COMMENT));
		m_COL_LABEL			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Label",COL_LABEL));
		m_COL_XOR			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Select",COL_XOR));
		m_COL_PART			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Component",COL_PART));
		m_COL_PART_PIN		=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","ComponentPin",COL_PART_PIN));
		m_COL_PART_PINNAME	=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","PinName",COL_PART_PINNAME));
		m_COL_PART_PINNUM	=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","PinNum",COL_PART_PINNUM));
		m_COL_PART_NAME		=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","ComponentName",COL_PART_NAME));
		m_COL_PART_NUM		=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","ComponentNum",COL_PART_NUM));
		m_COL_PART_FRAME	=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","ComponentFrame",COL_PART_FRAME));
		m_COL_SHEET_FRAME	=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","SheetFrame",COL_SHEET_FRAME));
		m_COL_SHEET_GRID	=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","Grid",COL_SHEET_GRID));
		m_COL_DARK			=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","InactiveLayer",COL_DARK));
		m_COL_NC_MARK		=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","NcMark",COL_NC_MARK));
		m_COL_QUICKPROPVIEW	=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","QuickPropView",COL_QUICKPROPVIEW));
		m_COL_TEMPFRAME_FOCUSED		=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","TempFrameFocused",COL_TEMPFRAME_FOCUSED));
		m_COL_TEMPFRAME_NOT_FOCUSED	=(COLORREF)(AfxGetApp()->GetProfileInt("DefaultColor","TempFrameNotFocused",COL_TEMPFRAME_NOT_FOCUSED));

/*
		m_COL_BG			=	COL_BG;
		m_COL_JUNC			=	COL_JUNC;
		m_COL_WIRE			=	COL_WIRE;
		m_COL_BUS			=	COL_BUS;
		m_COL_DASH			=	COL_DASH;
		m_COL_TAG			=	COL_TAG;
		m_COL_TAG_NAME		=	COL_TAG_NAME;
		m_COL_COMMENT		=	COL_COMMENT;
		m_COL_LABEL			=	COL_LABEL;
		m_COL_XOR			=	COL_XOR;
		m_COL_PART			=	COL_PART;
		m_COL_PART_PIN		=	COL_PART_PIN;
		m_COL_PART_PINNAME	=	COL_PART_PINNAME;	
		m_COL_PART_PINNUM	=	COL_PART_PINNUM;
		m_COL_PART_NAME		=	COL_PART_NAME;	
		m_COL_PART_NUM		=	COL_PART_NUM;
		m_COL_PART_FRAME	=	COL_PART_FRAME;
		m_COL_SHEET_FRAME	=	COL_SHEET_FRAME;
		m_COL_SHEET_GRID	=	COL_SHEET_GRID;
		m_COL_DARK			=	COL_DARK;
*/

		COLORREF colRef;
		CListBox* pList=(CListBox*)GetDlgItem(IDC_LIST);
		int index = pList->GetCurSel();
		if(index==-1) return;
		colRef = *((COLORREF*)pList->GetItemDataPtr(index));
		m_brush.DeleteObject();
		m_brush.CreateSolidBrush(colRef);
		CStatic* pStatic=(CStatic*)GetDlgItem(IDC_STATIC_COL);
		pStatic->Invalidate();
	}
}

void CSetColor::OnOK()
{
	// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB


	CDialog::OnOK();
}
