//
// DataSnap vLV WFl[^ɂ쐬B
// 

unit uClientClasses;

interface

uses DBXCommon, Classes, SysUtils, DB, SqlExpr, DBXDBReaders;

type
  TDSServerModule1Client = class
  private
    FDBXConnection: TDBXConnection;
    FInstanceOwner: Boolean;
    FSayHelloCommand: TDBXCommand;
    FGetCountryDataSetCommand: TDBXCommand;
  public
    constructor Create(ADBXConnection: TDBXConnection); overload;
    constructor Create(ADBXConnection: TDBXConnection; AInstanceOwner: Boolean); overload;
    destructor Destroy; override;
    function SayHello: string;
    function GetCountryDataSet: TDataSet;
  end;

implementation

function TDSServerModule1Client.SayHello: string;
begin
  if FSayHelloCommand = nil then
  begin
    FSayHelloCommand := FDBXConnection.CreateCommand;
    FSayHelloCommand.CommandType := TDBXCommandTypes.DSServerMethod;
    FSayHelloCommand.Text := 'TDSServerModule1.SayHello';
    FSayHelloCommand.Prepare;
  end;
  FSayHelloCommand.ExecuteUpdate;
  Result := FSayHelloCommand.Parameters[0].Value.GetWideString;
end;

function TDSServerModule1Client.GetCountryDataSet: TDataSet;
begin
  if FGetCountryDataSetCommand = nil then
  begin
    FGetCountryDataSetCommand := FDBXConnection.CreateCommand;
    FGetCountryDataSetCommand.CommandType := TDBXCommandTypes.DSServerMethod;
    FGetCountryDataSetCommand.Text := 'TDSServerModule1.GetCountryDataSet';
    FGetCountryDataSetCommand.Prepare;
  end;
  FGetCountryDataSetCommand.ExecuteUpdate;
  Result := TCustomSQLDataSet.Create(nil, FGetCountryDataSetCommand.Parameters[0].Value.GetDBXReader(False), True);
  Result.Open;
  if FInstanceOwner then
    FGetCountryDataSetCommand.FreeOnExecute(Result);
end;


constructor TDSServerModule1Client.Create(ADBXConnection: TDBXConnection);
begin
  inherited Create;
  if ADBXConnection = nil then
    raise EInvalidOperation.Create('ڑ nil wł܂BڑJĂ邱ƂmFĂB');
  FDBXConnection := ADBXConnection;
FInstanceOwner := True;
end;


constructor TDSServerModule1Client.Create(ADBXConnection: TDBXConnection; AInstanceOwner: Boolean);
begin
  inherited Create;
  if ADBXConnection = nil then
    raise EInvalidOperation.Create('ڑ nil wł܂BڑJĂ邱ƂmFĂB');
  FDBXConnection := ADBXConnection;
FInstanceOwner := AInstanceOwner;
end;


destructor TDSServerModule1Client.Destroy;
begin
  FreeAndNil(FSayHelloCommand);
  FreeAndNil(FGetCountryDataSetCommand);
  inherited;
end;

end.
