unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, SyncObjs;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Button2: TButton;
    SpinEdit1: TSpinEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    L: TList;
  public
    constructor Create(AOwner:TComponent);Override;
    destructor Destroy;Override;
  end;

  TMythread = class(TThread)
  private
     FMemo:TMemo;
     FMsg:String;
     FCmd:String;
     FLck:TCriticalSection;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean);
    destructor Destroy;override;
    property Memo: TMemo read FMemo write FMemo;
    property Msg : String read FMsg write FMsg;
    property Lck : TCriticalSection read FLck;
    property Cmd : String read FCmd write FCmd;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ TFrom1 }

procedure TForm1.Button1Click(Sender: TObject);
var
  idx, i, t:  Integer;
begin
  if (SpinEdit1.Value < 1) then Exit;
  idx := 0;
  Button1.Enabled := False;
  Button2.Enabled := False;
  t := gettickcount;
  for i := 0 to SpinEdit1.Value - 1 do
  begin
    try
      idx := L.Add(TMyThread.Create(True));
    except
      break;
    end;
    TMyThread(L[idx]).Memo := Memo1;
    TMyThread(L[idx]).FreeOnTerminate := True;
    TMyThread(L[idx]).Priority := tpNormal;
    TMyThread(L[idx]).Resume;
    Application.ProcessMessages;
  end;
  t := gettickcount - t;
  Memo1.Lines.Add(IntToStr(idx + 1) + ' Threads Started');
  Memo1.Lines.Add( 'Elaped time is ' + IntToStr(t) + ' mSec');
  Button2.Enabled := True;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Button2.Enabled := False;
  while L.Count > 0 do
  begin
    TMyThread(L[0]).Lck.Enter;
    TMyThread(L[0]).Cmd := 'E';
    TMyThread(L[0]).Lck.Leave;
    L.Delete(0);
  end;
  Button1.Enabled := True;
  Button2.Enabled := True;
end;

constructor TForm1.Create(AOwner: TComponent);
begin
  inherited;
  L := TList.Create;
end;

destructor TForm1.Destroy;
begin
  if L.Count > 0 then Self.Button2Click(nil);
  L.Free;
  inherited;
end;

{ TMythread }


constructor TMythread.Create(CreateSuspended: Boolean);
begin
  inherited;
  FLck := TCriticalSection.Create;
  FCmd := '';
end;

destructor TMythread.Destroy;
begin
  FLck.Free;
  inherited;
end;

procedure TMythread.Execute;
var
  f:TThreadProcedure;
begin
  FMsg := 'Start thread ID = ' + IntToStr(ThreadID);
  f := procedure
  begin
    FMemo.Lines.Add(FMsg);
  end;
  Synchronize(f);
  while not terminated do
  begin
    sleep(100);
    Lck.Enter;
    if (Cmd = 'E') then
    begin
      Lck.Leave;
      break;
    end;
    Lck.Leave;
  end;
  FMsg := 'Terminated thread ID = ' + IntToStr(ThreadID);
  Synchronize(f);
end;

end.
