unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Button2: TButton;
    SpinEdit1: TSpinEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    L: TList;
  public
    constructor Create(AOwner:TComponent);Override;
    destructor Destroy;Override;
  end;

  TMythread = class(TThread)
  private
     FMemo:TMemo;
     FMsg:String;
  protected
    procedure Execute; override;
  public
    property Memo: TMemo read FMemo write FMemo;
    property Msg : String read FMsg write FMsg;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ TFrom1 }

procedure TForm1.Button1Click(Sender: TObject);
var
  idx, i, t:  Integer;
begin
  if (SpinEdit1.Value < 1) then Exit;
  idx := 0;
  Button1.Enabled := False;
  Button2.Enabled := False;
  t := gettickcount;
  for i := 0 to SpinEdit1.Value - 1 do
  begin
    try
      idx := L.Add(TMyThread.Create(True));
    except
      break;
    end;
    TMyThread(L[idx]).Memo := Memo1;
    TMyThread(L[idx]).FreeOnTerminate := True;
    TMyThread(L[idx]).Priority := tpIdle;
    TMyThread(L[idx]).Resume;
    Application.ProcessMessages;
  end;
  t := gettickcount - t;
  Memo1.Lines.Add(IntToStr(idx + 1) + ' Threads Started');
  Memo1.Lines.Add( 'Elaped time is ' + IntToStr(t) + ' mSec');
  Button2.Enabled := True;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Button2.Enabled := False;
  while L.Count > 0 do
  begin
    TMyThread(L[0]).Terminate;
    L.Delete(0);
  end;
  Button1.Enabled := True;
  Button2.Enabled := True;
end;

constructor TForm1.Create(AOwner: TComponent);
begin
  inherited;
  L := TList.Create;
end;

destructor TForm1.Destroy;
begin
  if L.Count > 0 then Self.Button2Click(nil);
  L.Free;
  inherited;
end;

{ TMythread }

procedure TMythread.Execute;
var
  f:TThreadProcedure;
begin
  FMsg := 'Start thread ID = ' + IntToStr(ThreadID);
  f := procedure
  begin
    FMemo.Lines.Add(FMsg);
  end;
  Queue(f);
  while not terminated do
  begin
    sleep(0);
  end;
  FMsg := 'Terminated thread ID = ' + IntToStr(ThreadID);
  Queue(f);
end;

end.
