unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, SyncObjs;

type
  Param = record
    id  : Integer;
    obj : TObject;
    cmd : Char;
  end;
  pParam = ^Param;

  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Button2: TButton;
    SpinEdit1: TSpinEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    L: TList;
  public
    constructor Create(AOwner:TComponent);Override;
    destructor Destroy;Override;
  end;

  function ThreadFunction(p:pParam):integer;

var
  Form1 : TForm1;
  Cs    : TCriticalSection;
  Evnt  : TEvent;

const
  //CREATE_SUSPENDED                =    $00000004;  windows.pasŒ`Ă
  STACK_SIZE_PARAM_IS_A_RESERVATION  = $00010000;

implementation

{$R *.dfm}

{ TFrom1 }

procedure TForm1.Button1Click(Sender: TObject);
var
  i, t:  Integer;
  tID : LongWord;
  p : pParam;
begin
  if (SpinEdit1.Value < 1) then Exit;
  Button1.Enabled := False;
  Button2.Enabled := False;
  Cs.Enter;
  t := gettickcount;
  for i := 0 to SpinEdit1.Value - 1 do
  begin
    try
      new(p);
      p^.id := i;
      p^.obj := TObject(Memo1);
      p^.cmd := 'S';
      CloseHandle(
        BeginThread(
          nil,
          4*1024,
          @ThreadFunction,
          p,
          STACK_SIZE_PARAM_IS_A_RESERVATION ,
          tID
        )
      );
      L.add(p);
    except
      break;
    end;
    Application.ProcessMessages;
  end;
  t := gettickcount - t;
  Memo1.Lines.Add(IntToStr(L.Count) + ' Threads Started');
  Memo1.Lines.Add( 'Elaped time is ' + IntToStr(t) + ' mSec');
  Cs.Leave;
  Button2.Enabled := True;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Button2.Enabled := False;
  while L.Count > 0 do
  begin
    pParam(L[0])^.cmd := 'E';
    L.Delete(0);
  end;
  Cs.Enter;
  Memo1.Lines.Add('ALL Threads were terminated.');
  Cs.Leave;
  Button1.Enabled := True;
  Button2.Enabled := True;
end;

constructor TForm1.Create(AOwner: TComponent);
begin
  inherited;
  L := TList.Create;
end;

destructor TForm1.Destroy;
begin
  if L.Count > 0 then Self.Button2Click(nil);
  L.Free;
  inherited;
end;

function ThreadFunction(p:pParam):Integer;
begin
  try
    Cs.Enter;
    TMemo(p.obj).Lines.Add('Thread ID=' + IntToStr(p^.id) + ' Started');
    Cs.Leave;
    while p^.cmd = 'S' do
    begin
      Sleep(0);
    end;
    Cs.Enter;
    TMemo(p.obj).Lines.Add('Thread ID=' + IntToStr(p^.id) + ' Stopped');
    Cs.Leave;

  finally
    result := 0;
    dispose(p);
    EndThread(0);
  end;
end;


initialization
  Cs := TCriticalSection.Create;
  Evnt := TEvent.Create(nil, true, false, 'EndThreads');

finalization
  Cs.Free;
  Evnt.Free;

end.
