#pragma warning(disable:4996)

#include "IntelHEXRecord.hpp"

#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <vector>
//#include <iostream>
#include <boost/tokenizer.hpp>
#include <boost/algorithm/string.hpp>

using namespace std;
using namespace boost;
using namespace boost::algorithm;


class IntelHEXRecordImpl {
public:
	string record;
	int length;
	string address;
	string type;
	string data;
};

IntelHEXRecord::IntelHEXRecord(string record)
		: impl_(new IntelHEXRecordImpl()) {
	/*
	if (record.at(0) == ':') {
		record = record.substr(1);
	}
	*/

	char* e;
	impl_->length = strtol(record.substr(0, 2).c_str(), &e, 16);
	//impl_->record = record.substr(0, 2 + 4 + 2 + (impl_->length * 2));
	impl_->record = record.substr(0);

	/*
	record = record.substr(2);
	impl_->address = record.substr(0, 4);
	record = record.substr(4);
	impl_->type = record.substr(0, 2);
	record = record.substr(2);
	impl_->data = record.substr(0, impl_->length * 2);
	*/

	
	//escaped_list_separator<char>	esc;
	//tokenizer< escaped_list_separator<char> > tokens( record, esc );

	char_separator<char>	sep(" ");


	
	//ʂ̕\
	
	
	string record_test;

	typedef
		tokenizer< char_separator<char> >::iterator Iter;

	tokenizer< char_separator<char> > tokens( record, sep );
	for( Iter it=tokens.begin(); it!=tokens.end(); ++it )
		record_test = record_test + *it + ",";

	
	impl_->record = record_test.substr(0);

	iterator_range<string::iterator> r = find_first( impl_->record,"------" );

	if(r)
		impl_->record = "\r\n";
	//impl_->data << *it << ",";

}

IntelHEXRecord::~IntelHEXRecord() {
	delete impl_;
}

int IntelHEXRecord::length() {
	return impl_->length;
}

string IntelHEXRecord::address() {
	return impl_->address;
}

string IntelHEXRecord::type() {
	return impl_->type;
}

string IntelHEXRecord::data() {
	return impl_->data;
}

string IntelHEXRecord::checksum() {
	// Q𑫂킹
	int total = 0;
	for (size_t i = 0; i < impl_->record.size(); i += 2) {
		char* e;
		total += strtol(impl_->record.substr(i, 2).c_str(), &e, 16);
	}

	// Q̕␔̂PUi\ĽQ̕擾
	char char_buffer[128];
	_itoa_s((~total) + 1, char_buffer, 128, 16);
	string result(char_buffer);
	result = result.substr(result.size() - 2);
	for (size_t i = 0; i < result.size(); ++i) {
		result[i] = toupper(result.at(i));
	}
	return result;
}

string IntelHEXRecord::record(bool colon) {
	string result;
	/*
	if (colon) {
		result.append(":");
	}
	*/

	result.append(impl_->record);
	//result.append(checksum());

	return result;
}
