#include "IntelHEXFile.hpp"
#include "IntelHEXRecord.hpp"

#include <fstream>
#include <iostream>
#include <map>
#include <sstream>
using namespace std;

#include <boost/regex.hpp>
using namespace boost;

map<string, string> get_params(char** argv) {
	ifstream stream(argv[1]);

	map<string, string> result;

	regex pattern(".*\\(([0-9a-zA-Z_]+)\\).*=.*?([0-9a-zA-Z]+).*?");

	string line;
	while (getline(stream, line)) {
		smatch match_result;
		if (regex_match(line, match_result, pattern)) {
			string param_name;
			param_name += "\\$\\{";
			param_name += match_result[1];
			param_name += "\\}";
			result[param_name] = match_result[2];
		}
	}

	return result;
}

string translate(string content, map<string, string> params) {
	for (map<string, string>::iterator i = params.begin(); i != params.end(); ++i) {
		content = regex_replace(content, regex(i->first), i->second);

		cout << "translate:" << endl;
		cout << content << endl;
	}
	return content;
}

int main(int argc, char** argv) {
	map<string, string> params(get_params(argv));

	ostringstream buffer;
	buffer << ":10000000${adj_freq}${freq_add_sub}000037${adj_temper}${temper_add_sub}FFFFFFFFFFFFFFFFFF68" << endl;
	buffer << ":10001000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0" << endl;
	buffer << ":10002000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0" << endl;
	buffer << ":10003000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD0" << endl;
	buffer << ":10004000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0" << endl;
	buffer << ":10005000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFB0" << endl;
	buffer << ":10006000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA0" << endl;
	buffer << ":10007000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF90" << endl;
	buffer << ":10008000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80" << endl;
	buffer << ":10009000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF70" << endl;
	buffer << ":1000A000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF60" << endl;
	buffer << ":1000B000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF50" << endl;
	buffer << ":1000C000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF40" << endl;
	buffer << ":1000D000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF30" << endl;
	buffer << ":1000E000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF20" << endl;
	buffer << ":1000F000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF10" << endl;
	buffer << ":10010000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" << endl;
	buffer << ":10011000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF" << endl;
	buffer << ":10012000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDF" << endl;
	buffer << ":10013000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCF" << endl;
	buffer << ":10014000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFBF" << endl;
	buffer << ":10015000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFAF" << endl;
	buffer << ":10016000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF9F" << endl;
	buffer << ":10017000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8F" << endl;
	buffer << ":10018000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7F" << endl;
	buffer << ":10019000FFFFFFFFFFFF${temp_neg10}${temp_neg5}${temp_0}${temp_5}${temp_10}" << endl;
	buffer << ":1001A000${temp_15}${temp_20}${temp_25}${temp_30}${temp_35}${temp_40}${temp_45}${temp_50}" << endl;
	buffer << ":1001B000${temp_55}00FFFFFF${f0_dis}FFFFFFFFFFFFFFFFFF9B" << endl;
	buffer << ":1001C000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F" << endl;
	buffer << ":1001D000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF2F" << endl;
	buffer << ":1001E000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF1F" << endl;
	buffer << ":1001F000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0F" << endl;
	buffer << ":00000001FF" << endl;

	ofstream out("output.hex");

	istringstream buffer2(translate(buffer.str(), params));
	IntelHEXFilePtr file(new IntelHEXFile(buffer2));

	if (out) {
		for (IntelHEXFile::const_iterator i = file->begin(); i != file->end(); ++i) {
			const IntelHEXRecordPtr& record = *i;
			out << record->record() << endl;		
		}
	}

	return 0;
}
