#include "IntelHEXFile.hpp"
#include "IntelHEXRecord.hpp"

#include <fstream>
#include <iostream>
using namespace std;

IntelHEXFilePtr get_file(int argc, char** argv) {
	if (argc == 2) {
		return IntelHEXFilePtr(new IntelHEXFile(ifstream(argv[1])));
	} else {
		return IntelHEXFilePtr(new IntelHEXFile(cin));
	}
}

int main(int argc, char** argv) {

	//argc = 1;
	//argv[0] = C:\mywork\new_wireless_module\open\cc1101driver\trunk\VC_test\intelhexutil\eeprom_data_sn11002.hex;

	/*
	string adj_freq;
	string serial;
	string freq_add_sub;
	string adj_temper;
	string temper_add_sub;
	*/


	EepromValue EepromValue;


	IntelHEXFilePtr file(get_file(argc, argv));
	ofstream out("output.hex");




	#if 1

	if (out) {
		for (IntelHEXFile::const_iterator i = file->begin(); i != file->end(); ++i) {
			const IntelHEXRecordPtr& record = *i;



			if(record->address()=="0000")
			{
				if (record->type() == "00" && record->data().length() == 32)
				{



					//EepromValue.serial = record->data().substr( 4,  6);

					EepromValue.serial = record->data().substr( 4,  6);
					EepromValue.adj_freq = record->data().substr( 0,  2);
					EepromValue.freq_add_sub = record->data().substr( 2,  2);
					EepromValue.adj_temper = record->data().substr(10,  2);
					EepromValue.temper_add_sub = record->data().substr(12,  2);


				}
			}


			if(record->address()=="0190")
			{
				if (record->type() == "00" && record->data().length() == 32)
				{
					EepromValue.temp_neg10 = record->data().substr( 12,  4);
					EepromValue.temp_neg5 = record->data().substr( 16,  4);
					EepromValue.temp_0 = record->data().substr( 16,  4);
					EepromValue.temp_5 = record->data().substr( 24,  4);
					EepromValue.temp_10 = record->data().substr( 28,  4);

				}
			}

			if(record->address()=="01A0")
			{
				if (record->type() == "00" && record->data().length() == 32)
				{
					EepromValue.temp_15 = record->data().substr(  0,  4);
					EepromValue.temp_20 = record->data().substr(  4,  4);
					EepromValue.temp_25 = record->data().substr(  8,  4);
					EepromValue.temp_30 = record->data().substr( 12,  4);
					EepromValue.temp_35 = record->data().substr( 16,  4);
					EepromValue.temp_40 = record->data().substr( 20,  4);
					EepromValue.temp_45 = record->data().substr( 24,  4);
					EepromValue.temp_50 = record->data().substr( 28,  4);

				}
			}


			if(record->address()=="01B0")
			{
				if (record->type() == "00" && record->data().length() == 32)
				{

					EepromValue.temp_55 = record->data().substr(  0,  4);
					EepromValue.f0_dis = record->data().substr( 12,  2);



					out << "VAID(serial)                       = " <<  ","   << EepromValue.serial            <<  ","   << endl;
					out << "LAgl(adj_freq)           = " <<  ","   << EepromValue.adj_freq          <<  ","   << endl;
					out << "gZZtO(freq_add_sub)   = " <<  ","   << EepromValue.freq_add_sub      <<  ","   << endl;
					out << "xvl(adj_temper)                 = " <<  ","   << EepromValue.adj_temper        <<  ","   << endl;
					out << "xvZZtO(temper_add_sub) = " <<  ","   << EepromValue.temper_add_sub    <<  ","   << endl;
					out << "exł̎gl                     " <<  ","                                    <<  ","   << endl;
					out << "-10(temp_neg10)                        = " <<  ","   << EepromValue.temp_neg10        <<  ","   << endl;
					out << "- 5(temp_neg5)                         = " <<  ","   << EepromValue.temp_neg5         <<  ","   << endl;
					out << "  0(temp_0)                            = " <<  ","   << EepromValue.temp_0            <<  ","   << endl;
					out << "  5(temp_5)                            = " <<  ","   << EepromValue.temp_5            <<  ","   << endl;
					out << " 10(temp_10)                           = " <<  ","   << EepromValue.temp_10           <<  ","   << endl;
					out << " 15(temp_15)                           = " <<  ","   << EepromValue.temp_15           <<  ","   << endl;
					out << " 20(temp_20)                           = " <<  ","   << EepromValue.temp_20           <<  ","   << endl;
					out << " 25(temp_25)                           = " <<  ","   << EepromValue.temp_25           <<  ","   << endl;
					out << " 30(temp_30)                           = " <<  ","   << EepromValue.temp_30           <<  ","   << endl;
					out << " 35(temp_35)                           = " <<  ","   << EepromValue.temp_35           <<  ","   << endl;
					out << " 40(temp_40)                           = " <<  ","   << EepromValue.temp_40           <<  ","   << endl;
					out << " 45(temp_45)                           = " <<  ","   << EepromValue.temp_45           <<  ","   << endl;
					out << " 50(temp_50)                           = " <<  ","   << EepromValue.temp_50           <<  ","   << endl;
					out << " 55(temp_55)                           = " <<  ","   << EepromValue.temp_55           <<  ","   << endl;
					out << "LAo͋֎~tO(f0_dis)           = " <<  ","   << EepromValue.f0_dis            <<  ","   << endl;

				}
			}



		}
	}

	#endif



	for (IntelHEXFile::const_iterator i = file->begin(); i != file->end(); ++i)
	{
		const IntelHEXRecordPtr& record = *i;

		#if 0
		if(record->address()=="0000")
		{
			if (record->type() == "00" && record->data().length() == 32)
			{
				record->data() = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
			}
		}
		#endif

		//record->data() = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
		//record->record("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
		//IntelHEXRecord("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
		file->add("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");

	}

	//IntelHEXFile test1;

	//test1.impl_ ;

	ofstream out02("output02.hex");

	if (out02) {
		for (IntelHEXFile::const_iterator i = file->begin(); i != file->end(); ++i) {
			const IntelHEXRecordPtr& record = *i;
			out02 << record->record() << endl;		
		}
	}

	return 0;
}
