#ifndef __INTEL_HEX_RECORD_HPP_
#define __INTEL_HEX_RECORD_HPP_

#include <string>
#include <boost/shared_ptr.hpp>

class IntelHEXRecordImpl;

class IntelHEXRecord {
private:
	IntelHEXRecordImpl* impl_;

public:
	IntelHEXRecord(std::string record);
	virtual ~IntelHEXRecord();

public:
	IntelHEXRecord(const IntelHEXRecord& record);
	IntelHEXRecord& operator=(const IntelHEXRecord& record);

public:
	int length();
	std::string address();
	std::string type();
	std::string data();
	std::string checksum();

public:
	std::string record(bool column = true);
};




#if 1

class EepromValue {
public:
	std::string serial;
	std::string adj_freq;
	std::string freq_add_sub;
	std::string adj_temper;
	std::string temper_add_sub;
	std::string temp_neg10;
	std::string temp_neg5;
	std::string temp_0;
	std::string temp_5;
	std::string temp_10;
	std::string temp_15;
	std::string temp_20;
	std::string temp_25;
	std::string temp_30;
	std::string temp_35;
	std::string temp_40;
	std::string temp_45;
	std::string temp_50;
 	std::string temp_55;
	std::string f0_dis;

};


#endif





#endif
