#include "IntelHEXFile.hpp"
#include "IntelHEXRecord.hpp"

#include <fstream>
#include <iostream>
#include <vector>

#include <boost/algorithm/string.hpp>

using namespace std;
using namespace boost;
using namespace boost::algorithm;



IntelHEXFilePtr get_file(int argc, char** argv) {
	if (argc == 2) {
		return IntelHEXFilePtr(new IntelHEXFile(ifstream(argv[1])));
	} else {
		return IntelHEXFilePtr(new IntelHEXFile(cin));
	}
}

int main(int argc, char** argv) {

	//argc = 1;
	//argv[0] = C:\mywork\new_wireless_module\open\cc1101driver\trunk\VC_test\intelhexutil\eeprom_data_sn11002.hex;


	IntelHEXFilePtr file(get_file(argc, argv));
	ofstream out("output.hex");
	int j=0;
	if (out) {
		for (IntelHEXFile::const_iterator i = file->begin(); i != file->end(); ++i) {
			const IntelHEXRecordPtr& record = *i;
			//out << record->record() << endl;


			string s = record->record();
			iterator_range<string::iterator> r = find_first( s,"\r\n" );

			if(r.begin() - s.begin() != 0)
			{
				out << record->record();
				j=0;
			}
			else
			{
				if(j==0)
				{
					out << endl;
					j++;
				}
			}
		}
	}

	return 0;
}
