//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------

const wchar_t *gPluginFiles[] = {
  L"ifjpeg.spi",NULL,
};


//PictureInfo\
struct PictureInfo{
		long left, top;
		long width, height;
		WORD x_density,y_density;
		short colorDepth;
		HLOCAL hInfo;

};



typedef int __stdcall (*ProcGetPluginInfo)(int,LPSTR,int);
typedef int __stdcall (*ProcIsSupported)(LPSTR,DWORD);
typedef int __stdcall (*ProcGetPictureInfo)(LPSTR,long,unsigned int,struct PictureInfo*);
typedef int __stdcall (*ProcGetPicture)(LPSTR,long,unsigned int,
						HANDLE*,HANDLE*,FARPROC,long);





__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
	AnsiString theFilter = "";
	char buf[81];

	//gPluginFilesɂČJԂ
	for( int i=0; gPluginFiles[i] != NULL; i++ ){

		HINSTANCE hSPI = LoadLibrary( gPluginFiles[i] );
		if( hSPI == NULL ) continue;
		//GetPluginInfo
		ProcGetPluginInfo GetPluginInfo = (ProcGetPluginInfo)
							GetProcAddress(hSPI, "GetPluginInfo");

    	if( GetPluginInfo == NULL ){
			FreeLibrary(hSPI);
			continue;
		}
		//t@C`̓o^
		for( int j=0; GetPluginInfo(j*2+3,buf,80) > 0; j++){
			theFilter += buf;
			theFilter += "(";
			GetPluginInfo(j*2+2,buf,80);
			theFilter += buf;
			theFilter +=")|";
			theFilter += buf;
			theFilter += "|";

		}
		//
		FreeLibrary(hSPI);
	}
	//ׂẴt@C(*.*)
	theFilter += "ׂẴt@C(*.*)|*.*";
	OpenDialog->Filter = theFilter;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FileOpenMenuClick(TObject *Sender)
{
	if(OpenDialog->Execute() == false ) return;
	//t@CJ
	int theFile = FileOpen( OpenDialog->FileName, fmOpenRead );
	//gPluginFilesɂČJԂ
	for( int i=0; gPluginFiles[i] != NULL; i++ ){

		HINSTANCE hSPI = LoadLibrary( gPluginFiles[i] );
		if( hSPI == NULL ) continue;
		//t@C̐擪Ƀt@C|C^ړ
		FileSeek(theFile,0,0);
		//IsSupported

		ProcIsSupported IsSupported =
						(ProcIsSupported)GetProcAddress(hSPI, "IsSupported");

		if( IsSupported == NULL ){
			FreeLibrary(hSPI);
			continue;
		}

		//t@CT|[gĂ΁At@Cǂݍ
		if( IsSupported(static_cast<AnsiString>(OpenDialog->FileName).c_str(),theFile) != 0 ){
			FileClose(theFile);
			ProcGetPictureInfo GetPictureInfo =
						(ProcGetPictureInfo)GetProcAddress(hSPI, "GetPictureInfo");

			if( GetPictureInfo == NULL ){
				FreeLibrary(hSPI);
				continue;
			}

			PictureInfo thePictureInfo;
			GetPictureInfo(static_cast<AnsiString>(OpenDialog->FileName).c_str(),0,0,&thePictureInfo);

			//GetPicture
			HLOCAL theHBm;
			HLOCAL theHBInfo;
			ProcGetPicture GetPicture = (ProcGetPicture)GetProcAddress(hSPI,"GetPicture");

			if( GetPicture == NULL ){
				FreeLibrary(hSPI);
				continue;

			}

			GetPicture(static_cast<AnsiString>(OpenDialog->FileName).c_str(),0,0, &theHBInfo,
						&theHBm,NULL,0);

			BITMAPINFO *theBInfo = (BITMAPINFO*)LocalLock(theHBInfo);
			void *theData = LocalLock(theHBm);
			Graphics::TBitmap *theBitmap = new Graphics::TBitmap();

			theBitmap->Width = thePictureInfo.width;
			theBitmap->Height = thePictureInfo.height;
			SetDIBits(theBitmap->Canvas->Handle, theBitmap->Handle,
						0,theBInfo->bmiHeader.biHeight,
						theData,theBInfo,DIB_RGB_COLORS);

			Image->Picture->Assign(theBitmap);
			//J
			LocalUnlock(theHBm);
			LocalFree(theHBm);
			LocalUnlock(theHBInfo);
			LocalFree(theHBInfo);
			FreeLibrary(hSPI);
			return;
		}
		FreeLibrary(hSPI);

	}
	FileClose(theFile);

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FileExitMenuClick(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------

