#
# makefile to make bzip2 .obj files using Borland's C++ compiler bcc32
# derived from a makefile generated by BCB6' bpr2mak
#
# if bzip2 source directory is different from ..\..\..\..\..\thirdparty\bzip2\bzip2-1.0.6, use
# "make -Dbzip2src=<path to bzip2 sources>" to tell make where to find the 
# source files
#
# Make.exe needs to reside in the same directory as bcc32.exe.
# For example, if you have Borlands free C++ v. 5.5 compiler (available from
# http://www.borland.com/products/downloads/download_cbuilder.html#) installed:
#
# >C:\Program Files\Borland\BCC55\Bin\make
#
# or, if you want to use C++ Builder 6:
#
# >C:\Program Files\Borland\CBuilder6\Bin\make
#
# or, if you want to use Borland Developer Studio 2006:
#
# >C:\Program files\Borland\BDS\4.0\bin\make
#
# To choose the target CPU, pass "-DCPU=n" as option to make, with n being a
# number between 3 and 6, with the following meanings:
#
#   n   Target CPU (or compatible)
# --------------------------------
#   3   80386
#   4   80486
#   5   Pentium (default)
#   6   Pentium Pro
#
# Robert Rossmair, 2004-10-16
#

CallingConvention = -pc

!if !$d(BCB)
BCB = $(MAKEDIR)\..
!endif

BCC = $(BCB)

!if !$d(bzip2src)
bzip2src = ..\..\..\..\..\thirdparty\bzip2\bzip2-1.0.6
!endif

!if !$d(CPU)
CPU = 5         # Pentium
!endif

# ---------------------------------------------------------------------------
# IDE SECTION
# ---------------------------------------------------------------------------
# The following section of the project makefile is managed by the BCB IDE.
# It is recommended to use the IDE to change any of the values in this
# section.
# ---------------------------------------------------------------------------

VERSION = BCB.06.00
# ---------------------------------------------------------------------------
OBJFILES = .\bzlib.obj .\randtable.obj .\crctable.obj .\compress.obj \
           .\decompress.obj .\huffman.obj .\blocksort.obj
# ---------------------------------------------------------------------------
DEBUGLIBPATH = $(BCB)\lib\debug
RELEASELIBPATH = $(BCB)\lib\release
USERDEFINES = 
SYSDEFINES = BZ_EXPORT;BZ_NO_STDIO
INCLUDEPATH = $(bzip2src);$(BCC)\include;$(BCB)\include\vcl
# LIBPATH = $(bzip2src)
WARNINGS= -w-par -w-aus
PATHC = .;$(bzip2src)
# PATHOBJ = .;$(LIBPATH)
# ---------------------------------------------------------------------------
CFLAG1 = -O2 -Ve -X- -a8 -$(CPU) -b -d -k- -vi -tWM $(CallingConvention)

# ---------------------------------------------------------------------------
# MAKE SECTION
# ---------------------------------------------------------------------------
# This section of the project file is not used by the BCB IDE.  It is for
# the benefit of building from the command-line using the MAKE utility.
# ---------------------------------------------------------------------------

.autodepend
# ---------------------------------------------------------------------------

!if !$d(BCC32)
BCC32 = bcc32
!endif

# ---------------------------------------------------------------------------
!if $d(PATHC)
.PATH.C   = $(PATHC)
!endif

# ---------------------------------------------------------------------------
bzip2: $(OBJFILES)

# ---------------------------------------------------------------------------
.c.obj:
    $(BCC)\BIN\$(BCC32) -c $(CFLAG1) $(WARNINGS) -I$(INCLUDEPATH) -D$(USERDEFINES);$(SYSDEFINES) -n$(@D) {$< }
# ---------------------------------------------------------------------------




