﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void buttonCOMOpen_Click(object sender, EventArgs e)
        {
            try
            {
                if (serialPort1.IsOpen)
                {
                    MessageBox.Show(this.textBox_Portname.Text + " はすでに開かれています。", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                {
                    // ポート番号文字列=this.textBox1.Text, 115200bps/N81/ハードウェアフロー/UTF8/改行=CR
                    this.serialPort1.PortName = this.textBox_Portname.Text;
                    this.serialPort1.BaudRate = 115200;
                    this.serialPort1.Parity = System.IO.Ports.Parity.None;
                    this.serialPort1.DataBits = 8;
                    this.serialPort1.StopBits = System.IO.Ports.StopBits.One;
                    this.serialPort1.Handshake = System.IO.Ports.Handshake.RequestToSend;
                    this.serialPort1.Encoding = Encoding.UTF8;
                    this.serialPort1.NewLine = "\r";
                    serialPort1.Open();

                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);


            }

        }

        private void textBox_Portname_TextChanged(object sender, EventArgs e)
        {

        }

        private void buttonSend_Click(object sender, EventArgs e)
        {
            SendString();           


        }

        private void Form1_Load(object sender, EventArgs e)
        {
            SendString();
        }

        private void buttonCOMClose_Click(object sender, EventArgs e)
        {
            if (serialPort1.IsOpen)
            {
                serialPort1.Close();
            }
       
        }


        private void SendString(string text)
        {
            try
            {
                this.serialPort1.Write(text);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void SendString()
        {
            string str = this.textBox2.Text;
            str = str.Replace("\r\n", serialPort1.NewLine);
            SendString(str);

            this.textBox2.Text = "";
            this.textBox2.Focus();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }


        /// <summary>
        /// 受信処理。本メソッドはFormとは別スレッドで処理されるため、
        /// Formの値の書き換えを行う場合にはdelegateを利用してForm側のスレッドで処理させる。
        /// </summary>
        private void serialPort1_DataReceived(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)
        {
            // 受信文字列の取得
            string receivedData;
            try
            {
                receivedData = this.serialPort1.ReadExisting();
                receivedData = receivedData.Replace(this.serialPort1.NewLine, "\r\n");
            }
            catch (Exception ex)
            {
                receivedData = ex.Message;
            }

            // richTextBox側のスレッドに AddRecievedDataメソッドのポインタを渡して、
            // 受信文字列を追加させる
            AddRecievedDataDelegate add = new AddRecievedDataDelegate(AddRecievedData);
            this.richTextBox1.Invoke(add, receivedData);
        }
        private delegate void AddRecievedDataDelegate(string data);
        private void AddRecievedData(string data)
        {
            this.richTextBox1.Text += data;

            // 表示部の最後までスクロール
            this.richTextBox1.Focus();
            this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
            this.richTextBox1.ScrollToCaret();

            // 入力フォームへフォーカスを移動
            this.textBox2.Focus();
        }

    }
}
