unit uLineDrawer;

interface

uses
  Messages, Classes, Controls;

type
  TLineDrawerKind = (lkHorz, lkVert);

  TLineDrawer = class(TCustomControl)
  (*
   *
   *)
  private
    FKind: TLineDrawerKind;
    procedure SetKind(const Value: TLineDrawerKind);
  protected
    // Methods
    procedure Paint; override;
    // Message Handlers
    procedure CMCtl3DChanged(var vMsg: TMessage); message CM_CTL3DCHANGED;
  public
    // Constructor & Destructor
    constructor Create(vOwner: TComponent); override;
  published
    // Properties
    property Kind: TLineDrawerKind read FKind write SetKind default lkHorz;
    // Inherited Properties
    property Anchors;
    property Color;
    property Ctl3D;
    property ParentColor;
    property ParentCtl3D;
    property Visible;
    property OnClick;
    property OnDblClick;
  end;

procedure Register;

implementation

uses
  Graphics, uGraphUtils;

//***** Global Functions *******************************************************

procedure Register;
begin
  RegisterComponents('Sample', [TLineDrawer]);
end;

//***** TLineDrawer ************************************************************

procedure TLineDrawer.CMCtl3DChanged(var vMsg: TMessage);
(*
 * Tv
 * 
 *)
begin
  inherited;

  Invalidate;
end;

constructor TLineDrawer.Create(vOwner: TComponent);
(*
 * Tv
 * 
 *)
begin
  inherited Create(vOwner);

  SetBounds(Left, Top, 100, 2);
end;

procedure TLineDrawer.SetKind(const Value: TLineDrawerKind);
begin
  if (FKind <> Value) then begin
    FKind := Value;

    if not (csLoading in ComponentState) then
      SetBounds(Left, Top, Height, Width);
  end;
end;

procedure TLineDrawer.Paint;
(*
 * Tv
 *)
var
  Half: Integer;
  Dark, Light: TColor;
begin
  with Canvas do begin
    Brush.Style := bsSolid;
    Dark := Darker(Color);
    Light := Lighter(Color);

    if (Ctl3D) then
      case FKind of
        lkHorz: begin
          Half := Height div 2;

          Brush.Color := Dark;
          FillRect(Rect(0, 0, Width, Half));

          Brush.Color := Light;
          FillRect(Rect(0, Half, Width, Height));
        end;

        lkVert: begin
          Half := Width div 2;

          Brush.Color := Dark;
          FillRect(Rect(0, 0, Half, Height));

          Brush.Color := Light;
          FillRect(Rect(Half, 0, Width, Height));
        end;
      end
    else begin
      Brush.Color := Color;
      FillRect(ClientRect);
    end;
  end;
end;

end.
