unit uFileEmbedderEditor;

interface

uses
  DesignIntf, DesignEditors;

type
  TFileEmbedderEditor = class(TStringProperty)
  private
    // Variables
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

procedure Register;

implementation

uses
  Forms, Dialogs, uFileEmbedder;

procedure Register;
begin
  RegisterPropertyEditor(
    TypeInfo(String),
    TFileEmbedder,
    'FileName',
    TFileEmbedderEditor);
end;

{ TFileEmbedderEditor }

procedure TFileEmbedderEditor.Edit;
begin
  with TOpenDialog.Create(Application) do
    try
      FileName := GetStrValue;
      Filter := 'ׂẴt@C (*.*)|*.*';

      if (Execute) then
        SetStrValue(FileName);
    finally
      Free;
    end;
end;

function TFileEmbedderEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

end.
