/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// Place.cpp : CBSchView NX̂}ʗvf̔zu̒`s܂B

#include "stdafx.h"
#include <assert.h>
#include <string>
#include <list>
using namespace std;

#include "BSch.h"

#include "SetLib.h"
#include "TagAtrb.h"
#include "CmntAtrb.h"
#include "LblAtrb.h"
#include "MarkerLineAtrb.h"

#include "xbschglobal.h"


//#include "BSchObj.h"
//#include "BSchJunc.h"
//#include "BSchEntr.h"
//#include "BSchLine.h"
//#include "BSchWire.h"
//#include "BSchBus.h"
//#include "BSchDash.h"
//#include "BSchTag.h"
//#include "BSchLbl.h"
//#include "BSchCmnt.h"





#include "BSchDoc.h"
#include "BSchView.h"
#include "drawobj.h"

#include "complib.h"
#include "BSchFont.h"
#include "Global.h"

//#include "BSchPart.h"
#include "Preview.h"
#include "SelPart.h"

#include "coord2.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//WNV̔zu
//W m_pointOcccasional
//BOOL CBSchView::PlaceJunction(CDC* pDC,CBSchDoc* pDoc)
BOOL CBSchView::PlaceJunction(CBSchDoc* pDoc)
{
	SXBSchJunc* pObj=new SXBSchJunc;
	if(!pObj) return FALSE;
	pObj->setP1(CPoint2SPoint(m_pointOccasional));		//W̐ݒ
	pObj->setLayer(pDoc->editLayer());

	pDoc->AddData(pObj);				//ꎞf[^ɂ
	//pDoc->FixSelection();				//ꎞf[^tBbNX
	FixSelection(SXBSchDoc::RESET_SELECT_NORMAL);				//ꎞf[^tBbNX
	if(g_bDisplayNcPinMark) pDoc->setNcPinFlag();//NCs̃tO̐ݒ
//	g_DrawJunc(pDC,pObj,DRAW_ON,m_nVExt,m_nWExt);
	return TRUE;
}

//Gg[̔zu
//W m_pointOcccasional
//ނ m_nCurrentTool
BOOL CBSchView::PlaceEntry(CBSchDoc* pDoc)
{
	SXBSchEntry* pObj = NULL;
	if(m_nCurrentTool==ID_TOOL_ENTRY_BL || m_nCurrentTool==ID_TOOL_ENTRY_BR){
		pObj = new SXBSchBusEntry; 
	}else if(m_nCurrentTool==ID_TOOL_ENTRY_WL || m_nCurrentTool==ID_TOOL_ENTRY_WR){
		pObj = new SXBSchEntry; 
	}
	if(!pObj) return FALSE;
	pObj->setP1(CPoint2SPoint(m_pointOccasional));		//W̐ݒ
	if(m_nCurrentTool==ID_TOOL_ENTRY_BL || m_nCurrentTool==ID_TOOL_ENTRY_WL){
		pObj->setAspect(SXBSchEntry::LEFT_DOWN);
	}else{
		pObj->setAspect(SXBSchEntry::RIGHT_DOWN);
	}
	pObj->setLayer(pDoc->editLayer());

	pDoc->AddData(pObj);		//ꎞf[^ɂ
	FixSelection(SXBSchDoc::RESET_SELECT_NORMAL);		//ꎞf[^tBbNX
//	pDoc->FixSelection();		//ꎞf[^tBbNX
//	g_DrawEntry(pDC,pObj,DRAW_ON,m_nVExt,m_nWExt);
	return TRUE;
}


//^O̔zu
//PDAgr[g̃_CAOŕƘg߂
//QDo^
//
//LZ{^ꍇ̓
//      uPɃ_CAOvuZN^c[ɖ߂vɕύX 1997/01/06
//BOOL CBSchView::PlaceTag(CDC* pDC,CBSchDoc* pDoc,CPoint* ppoint)
BOOL CBSchView::PlaceTag(CBSchDoc* pDoc,CPoint* ppoint)
{
	CTagAtrb dlg;
	dlg.m_rName.Empty();
	dlg.m_nType=0;
	if(dlg.DoModal()==IDCANCEL){
		PostMessage(WM_COMMAND,ID_TOOL_SELECTOR,0); //ZN^c[Ɉڍs郁bZ[W
		return TRUE;
	}

	SXBSchTag* pObj=new SXBSchTag;
	CPoint point=*ppoint;
	SnapToGrid(&point);			//Obhւ̃Xibv
	pObj->setP1(CPoint2SPoint(point));		//W̐ݒ

	pObj->setTagType(dlg.m_nType);
	pObj->setText(dlg.m_rName);
	pObj->setLayer(pDoc->editLayer());

	pDoc->AddData(pObj);					//ꎞf[^ɒǉ
//	pDoc->SetDirty();
	return TRUE;
}

//x̔zu
//PDAgr[g̃_CAOŕ߂
//QDo^
//
//LZ{^ꍇ̓
//      uPɃ_CAOvuZN^c[ɖ߂vɕύX 1997/01/06
//BOOL CBSchView::PlaceLabel(CDC* pDC,CBSchDoc* pDoc,CPoint* ppoint)
BOOL CBSchView::PlaceLabel(CBSchDoc* pDoc,CPoint* ppoint)
{
	CLblAtrb dlg;
	dlg.m_rText.Empty();
	if(dlg.DoModal()==IDCANCEL){
		PostMessage(WM_COMMAND,ID_TOOL_SELECTOR,0); //ZN^c[Ɉڍs郁bZ[W
		return TRUE;
	}
	if(dlg.m_rText.IsEmpty()) return TRUE;
	SXBSchLabel* pObj=new SXBSchLabel;
	pObj->setText(dlg.m_rText);
	pObj->setLayer(pDoc->editLayer());
	CPoint point=*ppoint;
	SnapToGrid(&point);					//Obhւ̃Xibv
	pObj->setP1(CPoint2SPoint(point));	//W̐ݒ
	pDoc->AddData(pObj);				//ꎞf[^ɒǉ
//	pDoc->SetDirty();
	return TRUE;
}



//Rg̔zu
//PDAgr[g̃_CAOŕƕ̎ނ߂
//QDo^
//
//LZ{^ꍇ̓
//      uPɃ_CAOvuZN^c[ɖ߂vɕύX 1997/01/06
//BOOL CBSchView::PlaceComment(CDC* pDC,CBSchDoc* pDoc,CPoint* ppoint)
BOOL CBSchView::PlaceComment(CBSchDoc* pDoc,CPoint* ppoint)
{
//	int n;
	CCmntAtrb dlg;
	dlg.m_rText.Empty();
	g_IniReadFontInfo(&dlg.m_logfont);

	if(dlg.DoModal()==IDCANCEL){
		PostMessage(WM_COMMAND,ID_TOOL_SELECTOR,0); //ZN^c[Ɉڍs郁bZ[W
		return TRUE;
	}

	if(dlg.m_rText.IsEmpty()) return TRUE;
	SXBSchComment* pObj=new SXBSchComment;

	CPoint point=*ppoint;
	SnapToGrid(&point);			//Obhւ̃Xibv
	pObj->setP1(CPoint2SPoint(point));		//W̐ݒ

	pObj->setText(dlg.m_rText);
	pObj->setFontSize(abs(dlg.m_logfont.lfHeight));
	pObj->setFontBold(dlg.m_logfont.lfWeight>=FW_BOLD);
	pObj->setFontItalic(dlg.m_logfont.lfItalic!=0);
	pObj->setFontName(dlg.m_logfont.lfFaceName);
	pObj->setEnableTag(dlg.m_enableTag);
	if(dlg.m_enableWidthSetting){
		pObj->setWidth(dlg.m_width);
	}else{
		pObj->setWidth(-1);
	}


	
	pObj->setLayer(pDoc->editLayer());
//	m_bDrawTmpData=TRUE;		//ꎞf[^`悵Ƃɂ
	pDoc->AddData(pObj);		//ꎞf[^ɒǉ
//	pDoc->SetDirty();		//ĂȂƏIɕۑ𕷂ėȂƂ
	return TRUE;
}



//i̔zu
//PDiĨ_CAOŕi̖O𓾂
//QDi̖O畔iCfbNXւ̃|C^𓾂
//RDiNXmۂ
//SDo^
//
//LZ{^ꍇ̓
//      uPɃ_CAOvuZN^c[ɖ߂vɕύX 1997/01/06
//BOOL CBSchView::PlacePart(CDC* pDC,CBSchDoc* pDoc,CPoint* ppoint)
BOOL CBSchView::PlacePart(CBSchDoc* pDoc,CPoint* ppoint)
{
	CSelPart dlg;
	dlg.m_bUsePreview=TRUE;		//vr[gǂ̐ݒ
//	dlg.m_bUsePreview=m_bUsePreview;	//vr[gǂ̐ݒ
//	dlg.m_nLastSelectPart=m_nLastSelectPart;
//
//  CPartLib.m_nLastSelectLibraryV݂ł̂荬CBKv
//					1997/01/28
	if(g_LibraryInfo(m_nLastSelectLibrary)){//NULLłȂ...
//		dlg.m_nLastSelectPart=g_pPartLib[m_nLastSelectLibrary]->m_nLastSelectIndex;
		dlg.m_nLastSelectLibrary=m_nLastSelectLibrary;
		dlg.m_nLastSelectPart=m_nLastSelectPart;
	}else{
//		dlg.m_nLastSelectPart=0;
		dlg.m_nLastSelectLibrary=0;
		dlg.m_nLastSelectPart=0;
	}
	if(dlg.DoModal()==IDCANCEL){
		PostMessage(WM_COMMAND,ID_TOOL_SELECTOR,0); //ZN^c[Ɉڍs郁bZ[W
		return TRUE;
	}

	const SCompIndex* pPartIndex = dlg.m_pCompIndex;
	if(pPartIndex==NULL){
		CString rString;
		//bZ[W{bNXp̃bZ[W̍쐬
		AfxFormatString1(rString,IDS_NOT_FOUND_PART,dlg.m_rStrPartName); 
		AfxMessageBox(rString,MB_OK|MB_ICONEXCLAMATION);
		return TRUE;
	}
	m_nLastSelectPart=    dlg.m_nLastSelectPart;
	m_nLastSelectLibrary= dlg.m_nLastSelectLibrary;

	
//	int nLib;
//	int nPart;
//
//
//	const SCompIndex* pPartIndex = g_SearchComponentIndex(dlg.m_rStrPartName,&nLib,&nPart,NULL);
//	if(pPartIndex==NULL){
//		CString rString;
//		//bZ[W{bNXp̃bZ[W̍쐬
//		AfxFormatString1(rString,IDS_NOT_FOUND_PART,dlg.m_rStrPartName); 
//		AfxMessageBox(rString,MB_OK|MB_ICONEXCLAMATION);
//		return TRUE;
//	}
//	m_nLastSelectPart=nPart;
//	m_nLastSelectLibrary=nLib;
//	g_pPartLib[nLib]->m_nLastSelectIndex=nPart;
	

	SXBSchComponent* pObj=new SXBSchComponent;
	if(!pObj) return FALSE;
	pObj->setCompInfoIndex(pPartIndex);
	pObj->setName(pPartIndex->name());
	pObj->setRefnum(pPartIndex->number());
	pObj->setMfr(pPartIndex->Mfr());
	pObj->setMFrPNum(pPartIndex->MfrPn());
	pObj->setPackageName(pPartIndex->Pkg());

//	pObj->SetPartIndex(pPartIndex);
	//W̌
	//PD(0,0)ɉzuĂ GetPointLT()ōW𓾂
	//QDzuԂEɂ炷
	CPoint point=CPoint(0,0);	//(0,0)ɉzu
	pObj->setLayer(pDoc->editLayer());

//	pObj->SetPoint(&point);		//W̐ݒ
//	point=pObj->GetPointLT();	//W𓾂
	SnapToGrid(ppoint);			//Obhւ̃Xibv
//	point.x=ppoint->x - point.x;//Eւ炷
//	point.y=ppoint->y - point.y;
	pObj->setP1(CPoint2SPoint(*ppoint));		//W̐ݒ
//	m_bDrawTmpData=TRUE;		//ꎞf[^`悵Ƃɂ
	m_nFocusedTo = FOCUSED_TO_BODY;
	pDoc->AddData(pObj);		//ꎞf[^ɒǉ
//	pDoc->SetDirty();		//ĂȂƏIɕۑ𕷂ėȂƂ
	return TRUE;
}



//C[̔zu
//zuẂAm_bMoveFrom,m_bMoveTo,m_bWireHorizon1st vZ
//BOOL CBSchView::PlaceWire(CDC* pDC,CBSchDoc* pDoc)
BOOL CBSchView::PlaceWire(CBSchDoc* pDoc)
{
	CPoint point;
	if(m_bWireHorizon1st){		//ɐ
		point.x=m_ptMoveTo.x;
		point.y=m_ptMoveFrom.y;
	}else{
		point.x=m_ptMoveFrom.x;
		point.y=m_ptMoveTo.y;
	}
	SXBSchWire* pObj;
	bool bPlace = false;
	//P{ڂ̃C[IuWFNg̍쐬Ɠo^
	if(m_ptMoveFrom!=point){
		pObj=new SXBSchWire;
		if(!pObj) return FALSE;
		pObj->setP1(CPoint2SPoint(m_ptMoveFrom));
		pObj->setP2(CPoint2SPoint(point));
		pObj->setLayer(pDoc->editLayer());
		pDoc->AddData(pObj);
		//pDoc->SetDirty();
		//pDoc->FixSelection();	//ꎞf[^tBbNX
		FixSelection(SXBSchDoc::RESET_SELECT_NORMAL);	//ꎞf[^tBbNX
		//g_DrawWire(pDC,pObj,DRAW_ON,m_nVExt,m_nWExt);
		bPlace = true;
	}
	//Q{ڂ̃C[IuWFNg̍쐬Ɠo^
	if(point!=m_ptMoveTo){
		pObj=new SXBSchWire;
		if(!pObj) return FALSE;
		pObj->setP1(CPoint2SPoint(point));
		pObj->setP2(CPoint2SPoint(m_ptMoveTo));
		pObj->setLayer(pDoc->editLayer());
		pDoc->AddData(pObj);
		//pDoc->SetDirty();
		//pDoc->FixSelection();	//ꎞf[^tBbNX
		FixSelection(SXBSchDoc::RESET_SELECT_NORMAL);	//ꎞf[^tBbNX
		bPlace = true;
		//g_DrawWire(pDC,pObj,DRAW_ON,m_nVExt,m_nWExt);
	}
	if(bPlace){
		if(g_bDisplayNcPinMark) pDoc->setNcPinFlag();//NCs̃tO̐ݒ
	}
	return TRUE;
}	

//oX̔zu
//zuẂAm_bMoveFrom,m_bMoveTo,m_bWireHorizon1st vZ
//BOOL CBSchView::PlaceBus(CDC* pDC,CBSchDoc* pDoc)
BOOL CBSchView::PlaceBus(CBSchDoc* pDoc)
{
	CPoint point;
	if(m_bWireHorizon1st){		//ɐ
		point.x=m_ptMoveTo.x;
		point.y=m_ptMoveFrom.y;
	}else{
		point.x=m_ptMoveFrom.x;
		point.y=m_ptMoveTo.y;
	}
	SXBSchBus* pObj;
	//P{ڂ̃oXIuWFNg̍쐬Ɠo^
	if(m_ptMoveFrom!=point){
		pObj=new SXBSchBus;
		if(!pObj) return FALSE;
		pObj->setP1(CPoint2SPoint(m_ptMoveFrom));
		pObj->setP2(CPoint2SPoint(point));
		pObj->setLayer(pDoc->editLayer());
		pDoc->AddData(pObj);
		//pDoc->SetDirty();
		//pDoc->FixSelection();	//ꎞf[^tBbNX
		FixSelection(SXBSchDoc::RESET_SELECT_NORMAL);	//ꎞf[^tBbNX
		//g_DrawBus(pDC,pObj,DRAW_ON,m_nVExt,m_nWExt);
	}
	//Q{ڂ̃oXIuWFNg̍쐬Ɠo^
	if(point!=m_ptMoveTo){
		pObj=new SXBSchBus;
		if(!pObj) return FALSE;
		pObj->setP1(CPoint2SPoint(point));
		pObj->setP2(CPoint2SPoint(m_ptMoveTo));
		pObj->setLayer(pDoc->editLayer());

		pDoc->AddData(pObj);
		//pDoc->SetDirty();
		//pDoc->FixSelection();	//ꎞf[^tBbNX
		FixSelection(SXBSchDoc::RESET_SELECT_NORMAL);	//ꎞf[^tBbNX
		//g_DrawBus(pDC,pObj,DRAW_ON,m_nVExt,m_nWExt);
	}
	return TRUE;
}	

//j̔zu
//zuẂAm_bMoveFrom,m_bMoveTo
//BOOL CBSchView::PlaceDash(CDC* pDC,CBSchDoc* pDoc)
BOOL CBSchView::PlaceDash(CBSchDoc* pDoc)
{
	SXBSchDash* pObj;
	//jIuWFNg̍쐬Ɠo^
	if(m_ptMoveFrom!=m_ptMoveTo){
		pObj=new SXBSchDash;
		if(!pObj) return FALSE;
		pObj->setP1(CPoint2SPoint(m_ptMoveFrom));
		pObj->setP2(CPoint2SPoint(m_ptMoveTo));
		pObj->setLayer(pDoc->editLayer());

		pObj->setLineStyle(	m_tempDecoLine.lineStyle());
		pObj->setLineWidth( m_tempDecoLine.lineWidth());
		pObj->setStartPointStyle( m_tempDecoLine.startPointStyle());
		pObj->setEndPointStyle( m_tempDecoLine.endPointStyle());
		pObj->setEndMarkSize( m_tempDecoLine.endMarkSize());
		pObj->setCurve( m_tempDecoLine.curve());

		pDoc->AddData(pObj);
		//pDoc->SetDirty();
		//pDoc->FixSelection();	//ꎞf[^tBbNX
		FixSelection(SXBSchDoc::RESET_SELECT_NORMAL);	//ꎞf[^tBbNX
		//g_DrawDash(pDC,pObj,DRAW_ON,m_nVExt,m_nWExt);
	}
	return TRUE;
}

//}[J[C̔zu
//zuẂAm_bMoveFrom,m_bMoveTo
BOOL CBSchView::PlaceMarkerLine(CBSchDoc* pDoc)
{
	SXBSchObj* pObj;
	//}[J[CIuWFNg̍쐬Ɠo^
	if(m_ptMoveFrom!=m_ptMoveTo){
		m_tempMarkerLine.setX1(m_ptMoveFrom.x);
		m_tempMarkerLine.setY1(m_ptMoveFrom.y);
		m_tempMarkerLine.setX2(m_ptMoveTo.x);
		m_tempMarkerLine.setY2(m_ptMoveTo.y);

		pObj=m_tempMarkerLine.duplicate();
		if(!pObj) return FALSE;
		pObj->setLayer(pDoc->editLayer());
		pDoc->AddData(pObj);
		//pDoc->FixSelection();	//ꎞf[^tBbNX
		FixSelection(SXBSchDoc::RESET_SELECT_NORMAL);	//ꎞf[^tBbNX
	}else{
		//if(DoAttributeDialogMarkerLine(&m_tempMarkerLine)){
		//	IniWriteMarkerLineInitValue();
		//}
		//CMarkerLineAtrb dlg;
		//dlg.m_nColor = m_tempMarkerLine.m_nColor;
		//dlg.m_nWidth = m_tempMarkerLine.m_width;
		//if(dlg.DoModal()==IDOK){
		//	m_tempMarkerLine.m_nColor = dlg.m_nColor;
		//	m_tempMarkerLine.m_width = dlg.m_nWidth;
		//	IniWriteMarkerLineInitValue();
		//}
	}
	return TRUE;
}

