/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2007 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/


// MainFrm.cpp : CMainFrame NX̎
//

#include "stdafx.h"
#include "LCoV.h"

#include "MainFrm.h"

#include "coord.h"
#include "ce3io.h"

#include "bschfont.h"
#include ".\mainfrm.h"
#include "CompProperty.h"
#include "PropLib.h"
#include "AddAlias.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_BN_CLICKED(IDC_BUTTON_UP, OnButtonUp)
	ON_BN_CLICKED(IDC_BUTTON_DOWN, OnButtonDown)
	ON_LBN_SELCHANGE(IDC_LIST_NAME, OnSelchangeNameList)
	ON_WM_SIZE()
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_UPDATE_COMMAND_UI(IDC_BUTTON_UP, OnUpdateButtonUp)
	ON_UPDATE_COMMAND_UI(IDC_BUTTON_DOWN, OnUpdateButtonDown)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_EDIT_COPY_COMP, OnEditCopyComp)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY_COMP, OnUpdateEditCopyComp)
	ON_COMMAND(ID_EDIT_CUT_COMP, OnEditCutComp)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT_COMP, OnUpdateEditCutComp)
	ON_COMMAND(ID_EDIT_PASTE_COMP, OnEditPasteComp)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_COMP, OnUpdateEditPasteComp)
//	ON_COMMAND(ID_VIEW_TOOLBAR, OnViewToolbar)
ON_COMMAND(ID_TOOL_SELECT, OnToolSelect)
ON_UPDATE_COMMAND_UI(ID_TOOL_SELECT, OnUpdateToolSelect)
ON_COMMAND(ID_TOOL_PIN, OnToolPin)
ON_UPDATE_COMMAND_UI(ID_TOOL_PIN, OnUpdateToolPin)
ON_COMMAND(ID_TOOL_LINE, OnToolLine)
ON_UPDATE_COMMAND_UI(ID_TOOL_LINE, OnUpdateToolLine)
ON_COMMAND(ID_TOOL_CIRCLE, OnToolCircle)
ON_UPDATE_COMMAND_UI(ID_TOOL_CIRCLE, OnUpdateToolCircle)
ON_COMMAND(ID_TOOL_POLYGON, OnToolPolygon)
ON_UPDATE_COMMAND_UI(ID_TOOL_POLYGON, OnUpdateToolPolygon)
ON_COMMAND(ID_TOOL_ARC, OnToolArc)
ON_UPDATE_COMMAND_UI(ID_TOOL_ARC, OnUpdateToolArc)
ON_COMMAND(ID_EDIT_PROPERTY, OnEditProperty)
ON_UPDATE_COMMAND_UI(ID_EDIT_PROPERTY, OnUpdateEditProperty)
ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
ON_COMMAND(ID_EDIT_CUT, OnEditCut)
ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO, OnUpdateEditUndo)
ON_COMMAND(ID_EDIT_NEW_COMP, OnEditNewComp)
ON_COMMAND(ID_EDIT_PROPERTY_COMP, OnEditPropertyComp)
ON_UPDATE_COMMAND_UI(ID_EDIT_PROPERTY_COMP, OnUpdateEditPropertyComp)
ON_UPDATE_COMMAND_UI(ID_EDIT_MIRROR, OnUpdateEditMirror)
ON_UPDATE_COMMAND_UI(ID_EDIT_ROTATE, OnUpdateEditRotate)
ON_COMMAND(ID_EDIT_ROTATE, OnEditRotate)
ON_COMMAND(ID_EDIT_MIRROR, OnEditMirror)
ON_COMMAND(ID_EDIT_NODE_MODE, OnEditNodeMode)
ON_UPDATE_COMMAND_UI(ID_EDIT_NODE_MODE, OnUpdateEditNodeMode)
ON_COMMAND(ID_TOOL_CREATE_BPTN, OnToolCreateBptn)
ON_UPDATE_COMMAND_UI(ID_TOOL_CREATE_BPTN, OnUpdateToolCreateBptn)
ON_WM_CLOSE()
ON_COMMAND(ID_EDIT_CLEAR, OnEditClear)
ON_UPDATE_COMMAND_UI(ID_EDIT_CLEAR, OnUpdateEditClear)
ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
ON_COMMAND(ID_EDIT_PROP_LIB, OnEditPropLib)
ON_COMMAND(ID_EDIT_ADD_ALIAS, OnEditAddAlias)
ON_UPDATE_COMMAND_UI(ID_EDIT_ADD_ALIAS, OnUpdateEditAddAlias)
ON_COMMAND(ID_EDIT_SORT_COMPONENT, OnEditSortComponent)
ON_UPDATE_COMMAND_UI(ID_EDIT_SORT_COMPONENT, OnUpdateEditSortComponent)
ON_COMMAND(ID_TOOL_TEXT, OnToolText)
ON_UPDATE_COMMAND_UI(ID_TOOL_TEXT, OnUpdateToolText)
ON_COMMAND(ID_EDIT_NEXTPINNAME, OnEditNextPinName)
ON_UPDATE_COMMAND_UI(ID_EDIT_NEXTPINNAME, OnUpdateEditNextPinName)
ON_COMMAND(ID_EDIT_NEXTPINNUM, OnEditNextPinNum)
ON_UPDATE_COMMAND_UI(ID_EDIT_NEXTPINNUM, OnUpdateNextPinNum)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // Xe[^X C CWP[^
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};


// CMainFrame RXgNV/fXgNV

CMainFrame::CMainFrame()
{
	// TODO: oR[hɒǉĂB
	m_OldSelectedCompInfo = NULL;
}

CMainFrame::~CMainFrame()
{
	delete g_pFont;
}


void CMainFrame::setAppCaption(LPCSTR filename)
{
	CString title = "LCoV";
	if(filename!=NULL && filename[0]!=0){
		title += " - ";
		title += filename;
	}
	SetWindowText(title);
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	// t[̃NCAg̈Ŝ߂r[쐬܂B
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("r[ EBhE쐬ł܂łB\n");
		return -1;
	}

	//SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	//SetIcon(IDR_MAINFRAME,TRUE);

	HICON hAppIcon=AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	SetIcon(hAppIcon, TRUE);		// 傫ACRݒ

	if (!m_wndToolBar.CreateEx(this, 0/*TBSTYLE_FLAT*/, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("c[ o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬ł܂łB
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Xe[^X o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬ł܂łB
	}
	// TODO: c[ o[hbLO\ɂȂꍇ́A 3 s폜ĂB
	//m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	//EnableDocking(CBRS_ALIGN_ANY);
	//DockControlBar(&m_wndToolBar);


	if (!m_wndDlgBar.Create(this, IDD_DIALOGBAR,CBRS_LEFT, IDD_DIALOGBAR)){
		TRACE0("Failed to create DlgBar\n");
		return -1;      // Fail to create.
	}
	CRect rcLB(0,0,10,10);

	m_LBCompName.CreateEx(WS_EX_CLIENTEDGE,_T("LISTBOX"),"Name&List",
					  WS_CHILD|WS_TABSTOP|WS_VISIBLE|WS_VSCROLL|LBS_NOTIFY,rcLB,&m_wndDlgBar,IDC_LIST_NAME);

	CButton* pButton;
	pButton = (CButton*)m_wndDlgBar.GetDlgItem(IDC_BUTTON_UP);
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_ICON_UP);
	pButton->SetIcon(hIcon);
	pButton = (CButton*)m_wndDlgBar.GetDlgItem(IDC_BUTTON_DOWN);
	hIcon = AfxGetApp()->LoadIcon(IDI_ICON_DOWN);
	pButton->SetIcon(hIcon);
	
	g_pFont = new CBSchFont;

	bool nocheckPntRect = AfxGetApp()->GetProfileInt("Setting","NoCheckPtnRectOnSave",0);
	m_wndView.m_doc.m_noChechAreaOnSave = nocheckPntRect;
	AfxGetApp()->WriteProfileInt("Setting","NoCheckPtnRectOnSave",nocheckPntRect);

	m_wndView.setCompIndex(NULL);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);

	cs.cx = m_sizeInitialWindowSize.cx;
	cs.cy = m_sizeInitialWindowSize.cy;
	return TRUE;
}


// CMainFrame ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG


// CMainFrame bZ[W nh

void CMainFrame::OnSetFocus(CWnd* /*pOldWnd*/)
{
	// r[ EBhEɃtH[JX^܂B
	m_wndView.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// r[ɍŏɃR}h@^܂B
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// ȊȌꍇ́Ȁs܂B
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


void CMainFrame::OnSize(UINT nType, int cx, int cy)
{
	CFrameWnd::OnSize(nType, cx, cy);
	// TODO : ɃbZ[W nh R[hǉ܂B


	//>>>t[EBhETCY̕ BSch3VڐA 2008/02/09
	WINDOWPLACEMENT wp;
	this->GetWindowPlacement(&wp);
	int wpcx = wp.rcNormalPosition.right - wp.rcNormalPosition.left;
	int wpcy = wp.rcNormalPosition.bottom- wp.rcNormalPosition.top;
	IniWriteWindowPosition(wp.showCmd,wpcx,wpcy);
	//<<<t[EBhETCY̕ BSch3VڐA 2008/02/09

	CRect rcDlgBar;
	m_wndDlgBar.GetWindowRect(&rcDlgBar);
	CButton* pButton = (CButton*)m_wndDlgBar.GetDlgItem(IDC_BUTTON_UP);
	CRect rcButton;
	pButton->GetWindowRect(&rcButton);

	CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
	CRect rcNote;
	pEdit->GetWindowRect(&rcNote);
	int height =rcNote.bottom - rcNote.top;
	rcNote=CRect(rcNote.left,rcDlgBar.bottom-5-height,rcDlgBar.right-5,rcDlgBar.bottom-5);

	CListBox* pLB =(CListBox*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
//	CRect rcLBName(rcButton.left,rcButton.bottom+5,rcDlgBar.right-5,rcDlgBar.bottom-5);
	CRect rcLBName(rcButton.left,rcButton.bottom+5,rcDlgBar.right-5,rcNote.top+5);
//	pLB->GetWindowRect(&rcLBName);
//	rcLBName.bottom = rcDlgBar.bottom-5;
	m_wndDlgBar.ScreenToClient(&rcLBName);
	pLB->MoveWindow(&rcLBName);
	m_wndDlgBar.ScreenToClient(&rcNote);
	pEdit->MoveWindow(&rcNote);
}



void CMainFrame::OnFileNew()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(DoSaveChanged()){
		m_LCoVDoc.m_CompLib.deleteContent();
		m_LCoVDoc.m_bDirty = false;
		setCompIndexToListBox();
		m_wndView.setCompIndex(NULL);
		setAppCaption(NULL);
		CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
		pEdit->SetWindowText("");
	}
}

void CMainFrame::OnFileOpen()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(DoSaveChanged()){
		DoOpen();
	}
}

//Cut@C̃I[v
BOOL CMainFrame::DoOpen(LPCSTR pszFileName)
{
	CString strOpenName;
	if(!pszFileName){
		CFileDialog dlg(TRUE,						//J_CAO
						"LB3",						//gqtȂꍇ̃ftHg
						"*.LB3",					//t@C
						OFN_HIDEREADONLY|OFN_FILEMUSTEXIST,
						"BSch3V library file(*.lb3)|*.LB3|BSch3V schematic(*.ce3)|*.CE3||",	//tB^
						this);						//eEChE
		if(dlg.DoModal()!=IDOK) return FALSE;
		strOpenName=CString(dlg.m_ofn.lpstrFile);	//t@C_CAOt@C擾
	}else{
		strOpenName=CString(pszFileName);
	}
	m_wndView.setCompIndex(NULL);
	m_LCoVDoc.m_CompLib.deleteContent();
	m_LCoVDoc.m_CompLib.readLibraryFile(strOpenName);
	m_LCoVDoc.m_bDirty = false;
	setAppCaption(strOpenName);

	setCompIndexToListBox();
	CListBox* pLB =(CListBox*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
	if(pLB->GetCount()>0){
		pLB->SetCurSel(0);
		SCompIndex* pCompIndex = (SCompIndex*)pLB->GetItemData(0);
		m_wndView.setCompIndex(pCompIndex);
		pEdit->SetWindowText(pCompIndex->compInfo()->m_note.c_str());
	}else{
		m_wndView.setCompIndex(NULL);
		pEdit->SetWindowText("");
	}

	return TRUE;
}

//iCfbNXXg{bNXɐݒ
void  CMainFrame::setCompIndexToListBox()
{
	SCompIndexListIterator iteIndex;
	iteIndex =m_LCoVDoc.m_CompLib.m_listCompIndex.begin();
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	pLB->ResetContent();	//Xg{bNX̓eׂď
	int n=0;
	while(iteIndex != m_LCoVDoc.m_CompLib.m_listCompIndex.end()){
		int indexNum = pLB->AddString("");
		pLB->SetItemData(indexNum,(DWORD_PTR)(*iteIndex));
		//CString str;
		iteIndex++;
	}
}

void CMainFrame::OnSelchangeNameList() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int n=pLB->GetCurSel();
	if(n==-1) return;
	if(m_wndView.m_pCompIndex!=NULL){
		m_wndView.releaseTemp();
		//m_wndView.m_doc.releaseTemp();
		if(m_wndView.m_doc.m_dirtyFlag){
			m_wndView.saveCompInfo();
			m_LCoVDoc.m_bDirty = true;
		}
	}
	SCompIndex* pCompIndex = (SCompIndex*)pLB->GetItemData(n);
	m_wndView.setCompIndex(pCompIndex);
	CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
	pEdit->SetWindowText(pCompIndex->compInfo()->m_note.c_str());
}

void CMainFrame::OnButtonUp()
{
	TRACE("Button UP\n");
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int n=pLB->GetCurSel();
	if(n>0){
		SCompIndex* pCompIndex = (SCompIndex*)pLB->GetItemData(n);
		pLB->DeleteString(n);
		int newIndex = pLB->InsertString(n-1," ");
		pLB->SetItemData(newIndex,(DWORD_PTR)pCompIndex);
		pLB->SetCurSel(newIndex);
		m_LCoVDoc.m_bDirty = true;
	}
}

void CMainFrame::OnButtonDown()
{
	TRACE("Button Down\n");
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int n=pLB->GetCurSel();
	int nCount=pLB->GetCount();
	if(n>=0&&n<nCount-1){
		SCompIndex* pCompIndex = (SCompIndex*)pLB->GetItemData(n);
		pLB->DeleteString(n);
		int newIndex = pLB->InsertString(n+1," ");
		pLB->SetItemData(newIndex,(DWORD_PTR)pCompIndex);
		pLB->SetCurSel(newIndex);
		m_LCoVDoc.m_bDirty = true;
	}
}



void CMainFrame::OnUpdateButtonUp(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int n=pLB->GetCurSel();
	pCmdUI->Enable(n>0);
}

void CMainFrame::OnUpdateButtonDown(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int n=pLB->GetCurSel();
	int nCount=pLB->GetCount();
	pCmdUI->Enable(n>=0&&n<nCount-1);
}


void CMainFrame::OnEditSortComponent()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(AfxMessageBox(IDS_NOTICE_SORT,MB_OKCANCEL)==IDOK){
		sortComponent();
	}
}

void CMainFrame::OnUpdateEditSortComponent(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	pCmdUI->Enable(pLB->GetCount()>1);
}

void CMainFrame::sortComponent()
{
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int nCount=pLB->GetCount();
	PSCompIndex* pArray=new PSCompIndex[nCount];
	
	int n;
	for(n=0;n<nCount;n++){
		pArray[n] = (SCompIndex*)pLB->GetItemData(n);
	}
	qsort(pArray,nCount,sizeof(void*),
	(int(*)(const void *,const void *))sortComponentCompare);

	pLB->ResetContent();	//Xg{bNX̓eׂď

	for(n=0;n<nCount;n++){
		int indexNum = pLB->AddString("");
		pLB->SetItemData(indexNum,(DWORD_PTR)(pArray[n]));
	}
	pLB->SetCurSel(0);
	SCompIndex* pCompIndex = (SCompIndex*)pLB->GetItemData(0);
	m_wndView.setCompIndex(pCompIndex);
	CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
	pEdit->SetWindowText(pCompIndex->compInfo()->m_note.c_str());


	delete[]pArray;
}

int CMainFrame::sortComponentCompare(SCompIndex** p1,SCompIndex ** p2)
{
	return strcmp( (*p1)->name(), (*p2)->name() );
}



BOOL CMainFrame::DoSaveChanged()
{
	if(m_wndView.m_pCompIndex!=NULL){
		m_wndView.releaseTemp();
		if(m_wndView.m_doc.m_dirtyFlag){
			m_wndView.saveCompInfo();
			m_wndView.m_doc.m_dirtyFlag=false;
			m_LCoVDoc.m_bDirty = true;
		}
	}
	if(m_LCoVDoc.m_bDirty){
		int n=AfxMessageBox(IDS_STRING_SAVE_CURRENT,MB_YESNOCANCEL);
		if(n==IDYES){
			if(DoOnFileSave()) return TRUE;
			return FALSE;
		}else if(n==IDCANCEL){
			return FALSE;
		}else{
			return TRUE;
		}
	}
	return TRUE;
}

//t@Cۑ̎
BOOL CMainFrame::DoSave(LPCSTR lpszFileName)
{
//	return m_LCoVDoc.m_CompLib.writeLibraryFile(filename);

	m_wndView.save();

	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int nCount=pLB->GetCount();
	int n,m;


	FILE* fp;
	if((fp = fopen(lpszFileName,"w"))==NULL){
		AfxMessageBox(IDS_SAVE_ERROR);
		return false;
	}
	SWriteCE3 wce3;
	wce3.Attach(fp);
	wce3.WriteRecord("+BSCH3_LIB_V.1.0");
	wce3.WriteEOL();

	wce3.WriteRecordString("PROP",m_LCoVDoc.m_CompLib.m_prop_string);
	wce3.WriteEOL();

	for(n=0;n<nCount;n++){
		SCompIndex* pIndex = (SCompIndex*)pLB->GetItemData(n);
		if(!pIndex)continue;
		string name = pIndex->name();
		if(name.empty())continue;
		SCompInfo* pInfo = pIndex->compInfo();
		if(!pInfo)continue;
		bool bAlias = false;
		string aliasFor;
		for(m=0;m<n && m<nCount;m++){
			SCompIndex* pIndex2 = (SCompIndex*)pLB->GetItemData(m);
			if(!pIndex2)continue;
			if(pIndex2->compInfo()==pInfo){
				aliasFor = pIndex2->name();	//ݍς݂̖O
				if(aliasFor.empty())continue;
				bAlias = true;
				break;
			}
		}
		if(bAlias){
			SCompLib::WriteAlias(wce3,name.c_str(),aliasFor.c_str());
		}else{
			pInfo->writeCe3(wce3,name.c_str());
		}
	}
	wce3.WriteRecord("-BSCH3_LIB_V.1.0");
	wce3.WriteEOL();

	fclose(fp);
	m_LCoVDoc.m_bDirty = false;
	m_wndView.m_doc.m_dirtyFlag = false;
	setAppCaption(lpszFileName);
	return true;
}

//Otăt@Cۑ̎
BOOL CMainFrame::DoSaveAs(LPCSTR defaultFilename)
{
	const char* initFilename;
	if(defaultFilename){
		initFilename = defaultFilename;
	}else{
		initFilename = "Untitled.LB3";
	}

	CFileDialog dlg(FALSE,			//ۑ_CAO
					"LB3",			//gqtȂꍇ̃ftHg
					initFilename,	//t@C
					OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
					"BSch3V library file(*.lb3)|*.LB3||",	//tB^
					this);							//eEChE

	if(dlg.DoModal()==IDOK){						//t@C_CAO̎s
		CString strSaveName=dlg.GetPathName();		//t@C_CAOt@C擾
		TRACE("%s\n",(const char*)strSaveName);
		if(DoSave(strSaveName)){
			m_LCoVDoc.m_CompLib.setLibraryName(strSaveName);
			return TRUE;
		}
	}
	return FALSE;
}

void CMainFrame::OnFileSaveAs()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(((CLCoVApp*)AfxGetApp())->m_bTempMode){
		return;
	}
	if(!m_LCoVDoc.m_CompLib.m_lpszLibraryName){
		DoSaveAs(NULL);
		return;
	}
	char szpath[_MAX_PATH];
	char szdrive[_MAX_DRIVE];
	char szdir[_MAX_DIR];
	char szname[_MAX_FNAME];
	char ext[_MAX_EXT];
	_splitpath(m_LCoVDoc.m_CompLib.m_lpszLibraryName,szdrive,szdir,szname,ext);
	if(_stricmp(ext,".LB3")!=0){
		_makepath(szpath,szdrive,szdir,szname,".LB3");
		DoSaveAs(szpath);
	}else{
		DoSaveAs(m_LCoVDoc.m_CompLib.m_lpszLibraryName);
	}
}

BOOL CMainFrame::DoOnFileSave()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(!m_LCoVDoc.m_CompLib.m_lpszLibraryName){
		return DoSaveAs(NULL);
	}

	char szpath[_MAX_PATH];
	char szdrive[_MAX_DRIVE];
	char szdir[_MAX_DIR];
	char szname[_MAX_FNAME];
	char ext[_MAX_EXT];
	_splitpath(m_LCoVDoc.m_CompLib.m_lpszLibraryName,szdrive,szdir,szname,ext);
	if(_stricmp(ext,".CE3")==0){
		_makepath(szpath,szdrive,szdir,szname,".LB3");
		return	DoSaveAs(szpath);
	}
	return DoSave(m_LCoVDoc.m_CompLib.m_lpszLibraryName);
}

void CMainFrame::OnFileSave()
{
	DoOnFileSave();
}

void CMainFrame::doCopyComp()
{
	if(m_wndView.m_pCompIndex!=NULL){
		m_wndView.releaseTemp();
		//m_wndView.m_doc.releaseTemp();
		if(m_wndView.m_doc.m_dirtyFlag){
			m_wndView.saveCompInfo();
		}
	}

	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int nIndex = pLB->GetCurSel();
	SCompIndex* pIndex = (SCompIndex*)pLB->GetItemData(nIndex);
	if(!pIndex)return;
	string name = pIndex->name();
	if(name.empty())return;
	SCompInfo* pInfo = pIndex->compInfo();
	if(!pInfo)return;
	string str;
	SWriteCE3 wce3;
	wce3.Attach(&str);

	wce3.WriteRecord("+BSCH3_DATA_V.1.0");	wce3.WriteEOL();
	wce3.WriteRecord("+COMPONENT");			wce3.WriteEOL();
	wce3.WriteRecord("+BSCH3_LIB_V.1.0");	wce3.WriteEOL();
	pInfo->writeCe3(wce3,name.c_str());
	wce3.WriteRecord("-BSCH3_LIB_V.1.0");	wce3.WriteEOL();
	wce3.WriteRecordInt("X",pInfo->m_size.w()*10);
	wce3.WriteRecordInt("Y",pInfo->m_size.h()*10);
	wce3.WriteRecordString("LIB",name);
	wce3.WriteRecordString("N",  name);
	wce3.WriteRecordString("R",  pInfo->m_pszRef);wce3.WriteEOL();
	wce3.WriteRecord("-COMPONENT");			wce3.WriteEOL();
	wce3.WriteRecord("-BSCH3_DATA_V.1.0");	wce3.WriteEOL();

	int nLength = str.size()+1;
	HGLOBAL hGMem=::GlobalAlloc(GMEM_MOVEABLE,nLength);//Nbv{[hɓn̊m
	if(hGMem==NULL){
		return;
	}
	BYTE* pgBuff=(BYTE*)::GlobalLock(hGMem);	//蓖ĂO[obN
	memcpy(pgBuff,str.c_str(),nLength);		//蓖ĂO[oɃt@C̓eRs[
	::GlobalUnlock(hGMem);				//O[õAbN
	::OpenClipboard(AfxGetMainWnd()->m_hWnd);//Nbv{[h̃I[v
	::EmptyClipboard();					//Nbv{[hɂ
	::SetClipboardData(CF_TEXT,hGMem);	//Nbv{[hɃf[^n
	::CloseClipboard();					//Nbv{[h
}


void CMainFrame::OnEditCopyComp()
{
	// TODO : ɃR}h nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int nIndex = pLB->GetCurSel();
	if(nIndex<0)return;
	doCopyComp();
}

void CMainFrame::OnUpdateEditCopyComp(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	pCmdUI->Enable(pLB->GetCurSel()>=0);
}

void CMainFrame::OnEditCutComp()
{
	// TODO : ɃR}h nh R[hǉ܂B
	doCopyComp();
	doDeleteComp();
}

void CMainFrame::OnUpdateEditCutComp(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	pCmdUI->Enable(pLB->GetCurSel()>=0);
}

void CMainFrame::doDeleteComp()
{
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int nIndex = pLB->GetCurSel();
	if(nIndex<0)return;
	m_wndView.setCompIndex(NULL);
	CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
	pEdit->SetWindowText("");
	SCompIndex* pIndex = (SCompIndex*)pLB->GetItemData(nIndex);
	pLB->DeleteString(nIndex);


	bool shareConpInfo =false;	

	SCompIndexListIterator iteIndex =m_LCoVDoc.m_CompLib.m_listCompIndex.begin();
	while(iteIndex != m_LCoVDoc.m_CompLib.m_listCompIndex.end()){
		if((*iteIndex)==pIndex){
			SCompIndexListIterator iteIndex2 =m_LCoVDoc.m_CompLib.m_listCompIndex.begin();
			while(iteIndex2 != m_LCoVDoc.m_CompLib.m_listCompIndex.end()){
				if(iteIndex!=iteIndex2){
					if((*iteIndex)->m_pCompInfo ==(*iteIndex2)->m_pCompInfo){
						shareConpInfo = true;
						break;
					}
				}
				iteIndex2++;
			}
			if(!shareConpInfo){
				SCompInfoListIterator iteInfo = m_LCoVDoc.m_CompLib.m_listCompInfo.begin();
				while(iteInfo != m_LCoVDoc.m_CompLib.m_listCompInfo.end()){
					if((*iteIndex)->m_pCompInfo == (*iteInfo)){
						delete (*iteInfo);
						m_LCoVDoc.m_CompLib.m_listCompInfo.erase(iteInfo);
						break;
					}
					iteInfo++;
				}
			}
			delete (*iteIndex);
			m_LCoVDoc.m_CompLib.m_listCompIndex.erase(iteIndex);
			break;
		}
		iteIndex++;
	}
	int nCount = pLB->GetCount();
	if(nCount-1 < nIndex) nIndex = nCount-1;
	if(nIndex>=0){
		pLB->SetCurSel(nIndex);
		pIndex = (SCompIndex*)pLB->GetItemData(nIndex);
		m_wndView.setCompIndex(pIndex);
		CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
		pEdit->SetWindowText(pIndex->m_pCompInfo->m_note.c_str());
	}
}


bool CMainFrame::canPaste()
{
	static const char* pcszID= "+BSCH3_DATA_V.1.0";
	int nIdLength = strlen(pcszID);
	bool retVal = false;
	if(::IsClipboardFormatAvailable(CF_TEXT)){
		::OpenClipboard(AfxGetMainWnd()->m_hWnd);		//Open clip board.
		HGLOBAL hGMem=::GetClipboardData(CF_TEXT);		//Get memory handle.
		if(hGMem!=NULL){
			int nLength=GlobalSize(hGMem);				//Size of clip board data.
			if(nLength>nIdLength*4){
				char* pgBuff=(char*)::GlobalLock(hGMem);	//Lock global memory.
				if(strncmp(pcszID,pgBuff,nIdLength)==0){
					retVal = true;
				}
				::GlobalUnlock(hGMem);				//Unock global memory.
			}
		}
		::CloseClipboard();
	}
	return retVal;
}


void CMainFrame::OnEditPasteComp()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(!canPaste())return;

	::OpenClipboard(AfxGetMainWnd()->m_hWnd);		//Open clip board.
	HGLOBAL hGMem=::GetClipboardData(CF_TEXT);		//Get memory handle.
	if(hGMem==NULL){
		::CloseClipboard();						//Close clip board.
		return;
	}
	char* pgBuff=(char*)::GlobalLock(hGMem);	//Lock global memory.
	string cbbuff=string(pgBuff);				//Initialize string with global memory.
	::GlobalUnlock(hGMem);						//Unock global memory.
	::CloseClipboard();							//Close clip board.


	SReadCE3 rce3;
	rce3.Attach(cbbuff.c_str());

	string str("");

	rce3.ReadRecord(str);
	if(str != "+BSCH3_DATA_V.1.0") return;
	if(rce3.SkipTo("+BSCH3_LIB_V.1.0")==EOF) return;

	if(!m_LCoVDoc.m_CompLib.ReadLb3(rce3,true))return;
	
	SCompIndex* pIndex = m_LCoVDoc.m_CompLib.m_listCompIndex.back();
	if(pIndex){
		if(m_wndView.m_pCompIndex!=NULL){
			m_wndView.releaseTemp();
			//m_wndView.m_doc.releaseTemp();
			if(m_wndView.m_doc.m_dirtyFlag){
				m_wndView.saveCompInfo();
			}
		}
		SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
		int n=pLB->GetCurSel();
		int newIndex = pLB->InsertString(n," ");
		pLB->SetItemData(newIndex,(DWORD_PTR)pIndex);
		pLB->SetCurSel(newIndex);
		m_wndView.setCompIndex(pIndex);
		CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
		pEdit->SetWindowText(pIndex->compInfo()->m_note.c_str());
		m_wndView.setDirty();
		m_LCoVDoc.m_bDirty = true;
	}
}


void CMainFrame::OnUpdateEditPasteComp(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(canPaste());
}



void CMainFrame::OnToolSelect()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.setTool(CCompEditView::TOOL_SELECT);
}

void CMainFrame::OnUpdateToolSelect(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL);
	pCmdUI->SetCheck(m_wndView.tool()==CCompEditView::TOOL_SELECT);
}

void CMainFrame::OnToolPin()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.setTool(CCompEditView::TOOL_PIN);
}

void CMainFrame::OnUpdateToolPin(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL);
	pCmdUI->SetCheck(m_wndView.tool()==CCompEditView::TOOL_PIN);
}

void CMainFrame::OnToolLine()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.setTool(CCompEditView::TOOL_LINE);
}

void CMainFrame::OnUpdateToolLine(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL && m_wndView.m_pCompIndex->pattern()!=NULL);
	pCmdUI->SetCheck(m_wndView.tool()==CCompEditView::TOOL_LINE);
}

void CMainFrame::OnToolCircle()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.setTool(CCompEditView::TOOL_CIRCLE);
}

void CMainFrame::OnUpdateToolCircle(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL  && m_wndView.m_pCompIndex->pattern()!=NULL);
	pCmdUI->SetCheck(m_wndView.tool()==CCompEditView::TOOL_CIRCLE);
}

void CMainFrame::OnToolPolygon()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.setTool(CCompEditView::TOOL_POLYGON);
}

void CMainFrame::OnUpdateToolPolygon(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL  && m_wndView.m_pCompIndex->pattern()!=NULL);
	pCmdUI->SetCheck(m_wndView.tool()==CCompEditView::TOOL_POLYGON);
}

void CMainFrame::OnToolText()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.setTool(CCompEditView::TOOL_TEXT);
}

void CMainFrame::OnUpdateToolText(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL  && m_wndView.m_pCompIndex->pattern()!=NULL);
	pCmdUI->SetCheck(m_wndView.tool()==CCompEditView::TOOL_TEXT);
}

void CMainFrame::OnToolArc()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.setTool(CCompEditView::TOOL_ARC);
}

void CMainFrame::OnUpdateToolArc(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL && m_wndView.m_pCompIndex->pattern()!=NULL);
	pCmdUI->SetCheck(m_wndView.tool()==CCompEditView::TOOL_ARC);
}

void CMainFrame::OnEditProperty()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.editProperty();
}

void CMainFrame::OnUpdateEditProperty(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL && m_wndView.canProperty());
}

void CMainFrame::OnEditCopy()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(!((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canCopy()))) return;
	m_wndView.doCopy();
}

void CMainFrame::OnUpdateEditCopy(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canCopy()));
}

void CMainFrame::OnEditPaste()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(!((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canPaste()))) return;
	m_wndView.doPaste();
}

void CMainFrame::OnUpdateEditPaste(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canPaste()));
}

void CMainFrame::OnEditCut()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(!((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canCopy()))) return;
	m_wndView.doCopy();
	m_wndView.doDelete();
}

void CMainFrame::OnUpdateEditCut(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canCopy()));
}

void CMainFrame::OnEditUndo()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(!((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canUndo()))) return;
	m_wndView.doUndo();
}

void CMainFrame::OnUpdateEditUndo(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canUndo()));
}

void CMainFrame::OnEditNewComp()
{
	// TODO : ɃR}h nh R[hǉ܂B
	CCompProperty dlg;
	if(dlg.DoModal()==IDOK){
		SCompInfo* pComp = new SCompInfo;
		SSize sizeComp=SSize(dlg.m_x,dlg.m_y);
		bool usePtn = (dlg.m_usePtn != FALSE);
		bool nobit =  (dlg.m_noBitPtn != FALSE);
		pComp->setSize(sizeComp,usePtn,nobit);
		pComp->setRef(dlg.m_num);
		pComp->setBlock(dlg.m_block);
		pComp->m_note = dlg.m_note;
		pComp->m_mfr  = dlg.m_mfr;
		pComp->m_mfrpn= dlg.m_mfrpn;
		pComp->m_pkg  = dlg.m_pkg;
	
		string name = dlg.m_name;

		string uniqname = m_LCoVDoc.m_CompLib.uniqueName(name);
	
		SCompIndex* pIndex = new SCompIndex;
		pIndex->setName(uniqname.c_str());
		pIndex->setCompInfo(pComp);

		m_LCoVDoc.m_CompLib.m_listCompIndex.push_back(pIndex);
		m_LCoVDoc.m_CompLib.m_listCompInfo.push_back(pComp);
		if(pIndex){
			if(m_wndView.m_pCompIndex!=NULL){
				m_wndView.releaseTemp();
				//m_wndView.m_doc.releaseTemp();
				if(m_wndView.m_doc.m_dirtyFlag){
					m_wndView.saveCompInfo();
				}
			}
			SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
			int n=pLB->GetCurSel();
			int newIndex = pLB->InsertString(n," ");
			pLB->SetItemData(newIndex,(DWORD_PTR)pIndex);
			pLB->SetCurSel(newIndex);
			m_wndView.setCompIndex(pIndex);
			CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
			pEdit->SetWindowText(pIndex->compInfo()->m_note.c_str());
		}
	}
	m_LCoVDoc.m_bDirty = true;
}

void CMainFrame::OnEditPropertyComp()
{
	// TODO : ɃR}h nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int nIndex = pLB->GetCurSel();
	if(nIndex<0) return;

	if(m_wndView.m_pCompIndex!=NULL){
		m_wndView.releaseTemp();
		//m_wndView.m_doc.releaseTemp();
		if(m_wndView.m_doc.m_dirtyFlag){
			m_wndView.saveCompInfo();
		}
	}

	SCompIndex* pIndex = (SCompIndex*)pLB->GetItemData(nIndex);
	if(!pIndex)return;
	string oldName = pIndex->name();
	//if(oldName.empty())return;
	SCompInfo* pComp = pIndex->compInfo();
	if(!pComp)return;



	CCompProperty dlg;
	dlg.m_name = oldName.c_str();
	dlg.m_num = pComp->m_pszRef;
	dlg.m_x = pComp->m_size.w();
	dlg.m_y = pComp->m_size.h();
	dlg.m_block = pComp->m_nBlock;
	dlg.m_usePtn = (pComp->m_pPtn!=NULL);
	dlg.m_note = pComp->m_note.c_str();
	dlg.m_mfr = pComp->m_mfr.c_str();
	dlg.m_mfrpn = pComp->m_mfrpn.c_str();
	dlg.m_pkg = pComp->m_pkg.c_str();



	if(pComp->m_pPtn!=NULL){
		dlg.m_noBitPtn = (pComp->m_pPtn->m_pBuff==NULL);
	}else{
		dlg.m_noBitPtn = FALSE;
	}

	if(dlg.DoModal()==IDOK){
		SSize sizeComp=SSize(dlg.m_x,dlg.m_y);
		bool usePtn = (dlg.m_usePtn != FALSE);
		bool nobit =  (dlg.m_noBitPtn != FALSE);
		pComp->setSize(sizeComp,usePtn,nobit);
		pComp->setUsePattern(usePtn,nobit);
		pComp->setRef(dlg.m_num);
		pComp->setBlock(dlg.m_block);
		pComp->m_note = dlg.m_note;
		pComp->m_mfr  = dlg.m_mfr;
		pComp->m_mfrpn= dlg.m_mfrpn;
		pComp->m_pkg  = dlg.m_pkg;

		string name = dlg.m_name;
		if(name != oldName){
			string uniqname = m_LCoVDoc.m_CompLib.uniqueName(name);
			pIndex->setName(uniqname.c_str());
			pLB->Invalidate();
		}
		m_wndView.setCompIndex(pIndex);
		CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
		pEdit->SetWindowText(pIndex->compInfo()->m_note.c_str());

		m_wndView.setDirty();
		m_LCoVDoc.m_bDirty = true;
	}
}

void CMainFrame::OnUpdateEditPropertyComp(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	pCmdUI->Enable(pLB->GetCurSel()>=0);
}

void CMainFrame::OnUpdateEditMirror(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canMirrorRotate()));
}

void CMainFrame::OnUpdateEditRotate(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canMirrorRotate()));
}

void CMainFrame::OnEditRotate()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canMirrorRotate())){
		m_wndView.doRotate();
	}
}

void CMainFrame::OnEditMirror()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canMirrorRotate())){
		m_wndView.doMirror();
	}
}

void CMainFrame::OnEditNodeMode()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.setEditNodeMode(!m_wndView.editNodeMode());
}

void CMainFrame::OnUpdateEditNodeMode(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL  && m_wndView.m_pCompIndex->pattern()!=NULL);
	pCmdUI->SetCheck(m_wndView.editNodeMode());
}

void CMainFrame::OnToolCreateBptn()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(AfxMessageBox(IDS_STRING_CREATE_BPTN,MB_OKCANCEL) == IDOK){
		m_wndView.doCreateBitPtn();
	}
}

void CMainFrame::OnUpdateToolCreateBptn(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.canCreateBitPtn());
}

void CMainFrame::OnClose()
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if(DoSaveChanged()){
		CFrameWnd::OnClose();
	}
}

void CMainFrame::OnEditClear()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(!((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canCopy()))) return;
	m_wndView.doDelete();
}

void CMainFrame::OnUpdateEditClear(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable((m_wndView.m_pCompIndex!=NULL)&&(m_wndView.canCopy()));
}

void CMainFrame::OnUpdateFileSaveAs(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable( ((CLCoVApp*)AfxGetApp())->m_bTempMode == false );
}

void CMainFrame::OnEditPropLib()
{
	// TODO : ɃR}h nh R[hǉ܂B
	CPropLib dlg;
	dlg.m_propString = m_LCoVDoc.m_CompLib.m_prop_string.c_str();
	if(dlg.DoModal()==IDOK){
		m_LCoVDoc.m_CompLib.m_prop_string = dlg.m_propString;
		m_LCoVDoc.m_bDirty = true;
	}
}

void CMainFrame::OnEditAddAlias()
{
	// TODO : ɃR}h nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	int nIndex = pLB->GetCurSel();
	if(nIndex<0) return;

	if(m_wndView.m_pCompIndex!=NULL){
		m_wndView.releaseTemp();
		//m_wndView.m_doc.releaseTemp();
		if(m_wndView.m_doc.m_dirtyFlag){
			m_wndView.saveCompInfo();
		}
	}

	SCompIndex* pIndex = (SCompIndex*)pLB->GetItemData(nIndex);
	if(!pIndex)return;
	string strName = pIndex->name();
	SCompInfo* pCompInfo = pIndex->compInfo();
	if(!pCompInfo)return;

	CAddAlias dlg;
	dlg.m_strName = strName.c_str();
	dlg.m_strAlias = "NAME";
// Ƀ_CAO
	if(dlg.DoModal()==IDOK){

		string strAlias = dlg.m_strAlias;

		string uniqname = m_LCoVDoc.m_CompLib.uniqueName(strAlias);
		SCompIndex* pIndex = new SCompIndex;
		pIndex->setName(uniqname.c_str());
		pIndex->setCompInfo(pCompInfo);

		m_LCoVDoc.m_CompLib.m_listCompIndex.push_back(pIndex);

		int newIndex = pLB->InsertString(nIndex," ");
		pLB->SetItemData(newIndex,(DWORD_PTR)pIndex);
		pLB->SetCurSel(newIndex);
		m_wndView.setCompIndex(pIndex);
		CEdit* pEdit = (CEdit*)m_wndDlgBar.GetDlgItem(IDC_EDIT_NOTE);
		pEdit->SetWindowText(pIndex->compInfo()->m_note.c_str());
	}
}

void CMainFrame::OnUpdateEditAddAlias(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
	pCmdUI->Enable(pLB->GetCurSel()>=0);
}



void CMainFrame::OnEditNextPinName()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.nextPinName();

}

void CMainFrame::OnUpdateEditNextPinName(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL && m_wndView.canNextPinName());
}

void CMainFrame::OnEditNextPinNum()
{
	// TODO : ɃR}h nh R[hǉ܂B
	m_wndView.nextPinNumber();
}

void CMainFrame::OnUpdateNextPinNum(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_wndView.m_pCompIndex!=NULL && m_wndView.canNextPinNumber());
}

//>>>t[EBhETCY̕ BSch3VڐA 2008/02/09
CSize CMainFrame::m_sizeInitialWindowSize = CSize(CW_USEDEFAULT,CW_USEDEFAULT);

void CMainFrame::SetInitialWindowSize(int cx,int cy)
{
	if(cx!=CW_USEDEFAULT && cx<400) cx = 400;
	if(cy!=CW_USEDEFAULT && cy<300) cy = 300;
	m_sizeInitialWindowSize = CSize(cx,cy);
}

#define WINDOW_POS_SECTION "WindowPosition"
void CMainFrame::IniWriteWindowPosition(int cmdShow,int cx,int cy)
{
	AfxGetApp()->WriteProfileInt(WINDOW_POS_SECTION,"cmdShow",cmdShow);
	AfxGetApp()->WriteProfileInt(WINDOW_POS_SECTION,"Width",cx);
	AfxGetApp()->WriteProfileInt(WINDOW_POS_SECTION,"Height",cy);
}
void CMainFrame::IniReadWindowPosition(int& cmdShow,int& cx,int& cy)
{
	cmdShow = AfxGetApp()->GetProfileInt(WINDOW_POS_SECTION,"cmdShow",SW_NORMAL);
	cx = AfxGetApp()->GetProfileInt(WINDOW_POS_SECTION,"Width",CW_USEDEFAULT);
	cy = AfxGetApp()->GetProfileInt(WINDOW_POS_SECTION,"Height",CW_USEDEFAULT);
}
//<<<t[EBhETCY̕ BSch3VڐA 2008/02/09


