/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2005 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/


// LBCompName.cpp : t@C
//

#include "stdafx.h"
#include "LCoV.h"
#include "LBCompName.h"
#include <list>
#include <string>
using namespace std;
#include "complib.h"
#include ".\lbcompname.h"
#include "MainFrm.h"


// SLBCompName

IMPLEMENT_DYNAMIC(SLBCompName, CListBox)
SLBCompName::SLBCompName()
{
	char* p=(char*)&m_lf;	//LOGFONT\̂̂OCjVCY
	for(int n=0;n<sizeof(LOGFONT);n++) *p++=0;
	m_lf.lfHeight=-13;
	m_lf.lfWeight=FW_REGULAR;
	m_lf.lfCharSet=DEFAULT_CHARSET;
	m_lf.lfPitchAndFamily=0;
	strcpy(m_lf.lfFaceName,"MS UI Gothic");
	m_drawCall = 0;
}

SLBCompName::~SLBCompName()
{
}


BEGIN_MESSAGE_MAP(SLBCompName, CListBox)
	ON_WM_CONTEXTMENU()
	ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()



// SLBCompName bZ[W nh


void SLBCompName::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct)
{
	// TODO :  w肳ꂽڂ̃TCY肷R[hǉĂB
	lpMeasureItemStruct->itemHeight = 15;
}

void SLBCompName::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	// TODO :  w肳ꂽڂ`悷邽߂̃R[hǉĂB
	CDC dc;
	dc.Attach(lpDrawItemStruct->hDC);
	CRect rcItem = lpDrawItemStruct->rcItem;
	int index = lpDrawItemStruct->itemID;
	int selectItem = GetCurSel();

//	TRACE("SLBCompName::DrawItem (%d,%d,%d)\n", m_drawCall++,index,selectItem);
//	if(index == 2){
//		TRACE("****\n");
//	}

	
	COLORREF col;
	


	if(lpDrawItemStruct->itemAction & ODA_SELECT){
		this->Invalidate(FALSE);
//		return;
	}

	if((lpDrawItemStruct->itemState & ODS_FOCUS) && (lpDrawItemStruct->itemState & ODS_SELECTED)){
		col = ::GetSysColor(COLOR_HIGHLIGHT);
		//colText = ::GetSysColor(COLOR_HIGHLIGHTTEXT);
	}else{
		col = ::GetSysColor(COLOR_WINDOW);
		//colText = ::GetSysColor(COLOR_WINDOWTEXT);
	}
	{
		CBrush brush;
		brush.CreateSolidBrush(col);
		dc.FillRect(&rcItem,&brush);
	}
	if(lpDrawItemStruct->itemState & ODS_SELECTED){
		dc.DrawFocusRect(&rcItem);
	}
	if(index != -1){
//		SCompIndex* pCompIndex =(SCompIndex*)lpDrawItemStruct->itemData;
		CRect rcDraw = CRect(rcItem);

		SCompIndex* pCompIndex =(SCompIndex*)GetItemData(index);
		//if(lpDrawItemStruct->itemState & ODS_FOCUS){
		if((lpDrawItemStruct->itemState & ODS_FOCUS) && (lpDrawItemStruct->itemState & ODS_SELECTED)){
			col = ::GetSysColor(COLOR_HIGHLIGHTTEXT);	
		}else if(lpDrawItemStruct->itemState & ODS_SELECTED){
			col = ::GetSysColor(COLOR_WINDOWTEXT);
		}else{
			SCompIndex* pCompIndexSelected =(SCompIndex*)GetItemData(selectItem); 
			if((selectItem != -1) && (pCompIndexSelected->compInfo()==pCompIndex->compInfo())){
				col = RGB(255,0,0);
				rcDraw.left += 10;
			}
			else{
				col = ::GetSysColor(COLOR_WINDOWTEXT);
			}
		}
		CFont font;
		font.CreateFontIndirect(&m_lf);
		CFont* pOldFont = dc.SelectObject(&font);
		COLORREF colOldText	= dc.SetTextColor(col);			//TextColor̐ݒ
		int nOldBkMode  = dc.SetBkMode(TRANSPARENT);			//`͓߃[h
		dc.DrawText(pCompIndex->name(),&rcDraw,DT_LEFT);
		dc.SetTextColor(colOldText);
		dc.SelectObject(pOldFont);
		dc.SetBkMode(nOldBkMode);
	}
	dc.Detach();
}

BOOL SLBCompName::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB
	if(! CListBox::PreCreateWindow(cs)) return FALSE;
	cs.style &= ~(LBS_OWNERDRAWVARIABLE | LBS_SORT);
	cs.style |= LBS_OWNERDRAWFIXED;
	return TRUE;
}

void SLBCompName::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	// TODO : ɃbZ[W nh R[hǉ܂B
	TRACE("SLBCompName::OnContextMenu()\n");
	CMenu menu;
	menu.LoadMenu(IDR_COMPNAMECONTEXT);
	menu.GetSubMenu(0)->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON,
		                               point.x,point.y,AfxGetMainWnd());
}

void SLBCompName::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CListBox::OnLButtonDblClk(nFlags, point);
	((CMainFrame*)AfxGetMainWnd())->OnEditPropertyComp();
}
