/****************************************************************************
    NL3W netlist utility for BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/


#ifndef NETLIST_H
#define NETLIST_H

#ifdef _MSVC
	#pragma warning (disable: 4786)
#endif

#include <stdio.h>
#include <assert.h>
#include <ctype.h>
#include <string>
#include <algorithm>
#include <list>
using namespace std;
#include "xbschstringlist.h"
#include "ce3io.h"
#include "xbschobj.h"
#include "xbschjunc.h"
#include "xbschlabel.h"
#include "xbschcomment.h"
#include "xbschtag.h"
#include "xbschcomponent.h"

#include "xbschline.h"
#include "xbschwirenl.h"
#include "xbschentry.h"
#include "xbschdelobj.h"
#include "xbschsheetinfo.h"
#include "xbschdoc.h"
#include "nlpin.h"
#include "dlliftype.h"


typedef list<SNlPin*> NlPinList;
typedef list<SNlPin*>::iterator NlPinListIterator;

typedef list<SPoint> PointList;
typedef list<SPoint>::iterator PointListIterator;


typedef SNlPin* PSNlPin;





class SSingleNetList
{
public:
	stringList m_SignalNameList;
	//string m_SignalName;
	SNlPin** m_pPinArray;
	int		m_nPinCount;
	SSingleNetList(){
		//m_SignalName=="";
		m_pPinArray	=NULL;
		m_nPinCount =0;
	}
	~SSingleNetList();

	string SignalName();
};

class SPartsListElement
{
public:
	string	m_prefix;
	int		m_suffix;
	string	m_name;
	string	m_note;
	string	m_mfr;
	string	m_mfrpn;
	string	m_package;
};

typedef SPartsListElement* PSPartsListElement;



typedef list<SSingleNetList*> NetList;
typedef list<SSingleNetList*>::iterator NetListIterator;

//#include "netclass.h"

class SNetList{
protected:
	XBSchObjList m_listTagPower;		//^OƓdi
	XBSchObjList m_listNcTagPower;		//gȂ^OƓdi
	XBSchObjList m_listWire;			//C[
	XBSchObjList m_listJunc;			//ڍ_
	XBSchObjList m_listLabel;			//x
	NlPinList	 m_listNlPin;			//񋓂s
	NlPinList	 m_listNlNcPin;			//gȂs
	NlPinList	 m_listNlConfPin;		//ds
	NlPinList	 m_listNoNumPin;		//sԍȂs
	int			 m_xOffset;				//setDatas邽т10000
	PSPartsListElement* m_pArrayPlistElem;
public:
	XBSchObjList m_listComponent;		//diȊO̕i
	NetList		 m_listNet;

public:
	SNetList();
	~SNetList();
	static string removeWS(const string& str);				//̗[̃zCgXy[X̍폜 
	static void clearXBSchObjList(XBSchObjList& listObj);	//SXBSchObj̃|C^Xg̉
	static void clearNlPin(NlPinList& listPin);				//SNlPiñ|C^Xg̉
	void clear();
	void clearNetList(NetList& netlist);
	void setData(XBSchObjList* plistSrc);//SXBSchDocǗĂ}ʗvf玟̗vfRs[ĐU蕪̃XgɒǉB
	void createNetList();//bool bExcludeNC);
	void createPartsList();
	void clearPlistElem();
	int writeReport(FILE* fp);			//|[gt@Co
	//int writePADSNetList(FILE* fp,bool bExcludeNC);		//PADS`̃lbgXgo
	//int writeTeleNetList(FILE* fp,bool bExcludeNC);		//eVX`̃lbgXgo
	//int writeProtNetList(FILE* fp,bool bExcludeNC);		//ve`̃lbgXgo
	int writeTeleNetList(const char* filename,bool bExcludeNC);		//eVX`̃lbgXgo
	int writeProtNetList(const char* filename,bool bExcludeNC);		//ve`̃lbgXgo
	int writeUserTypeNetList(const char* filename, bool bExcludeNC, int( __stdcall *fnWriteNetList)(const char*, const SExportNetlistInfo*));
	int writePartsList(const char* filename);		//CSV`̕iXgo
	//int writePartsList(FILE* fp);		//CSV`̕iXgo

protected:
	bool testLineJoint(int& al,int& ar,int bl,int br); //܂͐̐̌eXgB
	void jointWire();			//C[̘A
	void divideWire();			//C[ڍ_ŕ
	void nameFromTagPower();	//^OƓdiɐƃsɖO
	void nameFromLabel();		//xɐɐǉ

	
	void enumPin();//Lȕĩs񋓂
	bool quaryExist(stringList& strlist,string& str);//w蕶񂪕񃊃Xgɑ݂邩ǂǂ̃`FbN
	bool quaryExist(PointList& pointlist,SPoint point);//w__Xgɑ݂邩ǂǂ̃`FbN
	SSingleNetList* NetList1();//ЂƂ̃m[h̃lbg
	void enumConflictingPin();

	static void parseRefNum(const string& refnum,string& prefix,int& suffix);
	static int CompareSNlPin( const void *ppin1, const void *ppin2 );//SNlPiñsɂ召r
	static int CompareSPartsListElement( const void *p1, const void *p2 ); //SPartsListElement̕iԍɂr

};

struct SNetlistOption{
	const char* pszDstPath;
	//FILE* fpDst;
	FILE* fpRpt;
	int   listType;
	bool  bPlistMode;
	bool  bExcludeNC;
};


//lbgXg쐬B
//int netlist(int srcfiles, const char* srcfile[],const char* cfgpath,FILE* fp,int listtype,bool bPlist);
int netlist(int srcfiles, const char* srcfile[],SNetlistOption& option);







typedef SXBSchObj* PSXBSchObj;

#endif