/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// Copyright (C) 2002 H.Okada(suigyodo) All rights reserved.
/****************************************************************************
** XBSch}ʗvf^ONX
****************************************************************************/
#ifndef XBSCHTAG_H
#define XBSCHTAG_H

#include "xbsch.h"
#include "xbschobj.h"

class SXBSchTag:public SXBSchObj
{

public:

	enum BSCHTAG_TYPE{
		TAG_SQ =0,
		TAG_LU =1,
		TAG_RD =2,
		TAG_BI =3
	};

	//RXgN^
	SXBSchTag();
	//fXgN^
	virtual ~SXBSchTag(){};

	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );
	

	//ID̎擾
	unsigned id(){return ID_TAG;}
	unsigned objectFilterValue(){return OBJMASK_TAG;} 
protected:
	string m_strText;
	bool m_bHoriz;
	int m_nType;
public:
	int width();
	void setp2();
	// m_p1܂͉ɂȂ悤ɒ
	void normalize();
	//s
	SXBSchObj* duplicate();
	//W̐ݒ  m_p2ւ̐ݒ𖳌ɂĂ
	void setX2(int){}
	void setY2(int){}
	void setP2(const SPoint&){}
	//XWw肵čE]s
	void mirrorH(int x);
	//XYSWw肵āA]s
	void rotate(const SPoint& p);
	//]s
	void rotate();
	//_w肵đIdvxԂ
	int qSelectWeight(const SPoint& p);
	//͈͂w肵đIs
	unsigned testSelection(const SRect& rc);
	//͈͂IăhbOIs
	unsigned testSelectionForDrag(const SRect& rc);
	//`悪KvǂԂ
	bool qRedraw(const SRect& rc);
	//L͈͂Ԃ
	SRect area();
	SRect rotateRect();
	//sԂ
	int pinCount()const {return 2;}
	//nԖڂ̃s̈ʒu𓾂B
	SPoint pinPosition(int n) const;

public:
	bool canAttribute(){return true;}
	//LȃIuWFNgȂtrueԂ
	bool qValid(){return true;}

	bool horizontal(){ return m_bHoriz; }
	void setHorizontal(bool horizFlag){m_bHoriz = horizFlag;}
	int	 tagType(){ return m_nType; }
	void setTagType(int nType){ assert(nType>=0 && nType<=3); m_nType = nType ; }
	void setText(const char* psz);
	const char* text(){return m_strText.c_str();}

	//PƑÎƂɃ~[\ǂԂ
	bool canMirrorSingleSelected() { //2008/06/26
		if(!m_bHoriz) return false;
		if(m_nType == TAG_SQ || m_nType == TAG_BI) return false;
		return true;
	}


};

#endif
