#ifndef __INTEL_HEX_FILE_HPP__
#define __INTEL_HEX_FILE_HPP__

#include <list>
#include <iostream>
#include <string>
#include <boost/shared_ptr.hpp>

class IntelHEXRecord;
typedef boost::shared_ptr<IntelHEXRecord> IntelHEXRecordPtr;

class IntelHEXFileImpl;

class IntelHEXFile {
private:
	IntelHEXFileImpl* impl_;

public:
	typedef std::list<IntelHEXRecordPtr> RecordContainer;
	typedef RecordContainer::iterator iterator;
	typedef RecordContainer::const_iterator const_iterator;

public:
	IntelHEXFile();
	IntelHEXFile(const std::string& filename);
	IntelHEXFile(std::istream& stream);
	virtual ~IntelHEXFile();

private:
	IntelHEXFile(const IntelHEXFile& file);
	IntelHEXFile& operator=(const IntelHEXFile& file);

public:
	size_t size();
	void add(const std::string& record);
	void add(const IntelHEXRecordPtr& record);
	iterator begin();
	iterator end();
	const_iterator begin() const;
	const_iterator end() const;
};

typedef boost::shared_ptr<IntelHEXFile> IntelHEXFilePtr;

#endif
