#ifndef _MACRO_H_
#define _MACRO_H_

typedef unsigned char 	  u8;
typedef unsigned short 	  u16;
typedef unsigned char 	  uint8_t;

//extern u8 status;


#define	LOW				0
#define	HIGH			1


#define PCDDR	DDRC
#define PCSEL	PINC
#define PCINTIE


#define PBDDR	DDRB





enum {
	STARTUP=0,
	CHK_INPUT,
	DATA_SEND,
	CHK_DATA_SEND,
	POWER_DONW
};

enum {
	MASTER=0,
	SLAVE
};

enum {
	//OSC_128KHZ=0,
	
	OSC_8MHZ=0,
	OSC_1MHZ
};

typedef struct _ctl_data_
{
	
	u8 adj_freq;
	u8 add_sub;
	//u8 sleep_transmit_time;

}ctl_data;



typedef struct _rtc_time_
{
	
	u8 chk_hour;
	u8 chk_min;
	u8 curt_hour;
	u8 curt_min;

}rtc_time;



typedef struct _txfifo_data_ 
{
	//u8 length;

	//u8 data[20];
	u8 data[30];
	uint16_t length;
	u8 src_serial[6];
	u8 dest_serial[6];
	u8 sessionflag;
	u8 user_data1;
	u8 rx_rssi;
	u8 rx_lqi;
	u8 sl_rssi;
	u8 sl_lqi;

}txfifo_data;


typedef struct _rxfifo_data_
{
	//u8 length;

	//u8 data[20];
	u8 data[30];
	uint16_t length;
	u8 src_serial[6];
	u8 dest_serial[6];
	u8 sessionflag;
	u8 user_data1;
	u8 rx_rssi;
	u8 rx_lqi;
	u8 sl_rssi;
	u8 sl_lqi;

}rxfifo_data;



typedef struct _reg_slave_
{
	u8 serial[3];
	u8 slave_ctl_set;
}reg_slave;


typedef struct _reg_cmd_
{
	u8 length;
	u8 cmd[4];
}reg_cmd;


typedef struct _reg_param_
{
	u8 length;
	u8 param[4];
}reg_param;





typedef struct _client_status_
{
	
	//u8 tx_length;
	u8 version_l;
	u8 type;
	u8 serial[6];
	u8 sessionflag;
	u8 user_data1;
	u8 user_data2;
	u8 bat_val;
	u8 system_osc;
	u8 status;
	u8 send_err_cnt;
	u8 alert;
	u8 alert_old_temp;
	u8 make_alert;
	u8 make_alert_old;
	u8 sleep_time;
	u8 input_data;
	u8 ad_data_h;
	u8 ad_data_l;
	reg_slave reg_slave[100];
	//reg_cmd reg_cmd[2];
	//reg_param reg_param[4];
	//u8 master_rssi;

	//u8 master_lqi;
	u8 reserve[8];

}client_status;



typedef struct _cc1101_client_
{
	u8 i;
	client_status status;
	txfifo_data txfifo;
	rxfifo_data rxfifo;
	//rtc_time rtc;
	ctl_data ctl;

}cc1101_client;






typedef struct 
{ 
  unsigned int bit0:1; 
  unsigned int bit1:1; 
  unsigned int bit2:1; 
  unsigned int bit3:1; 
  unsigned int bit4:1; 
  unsigned int bit5:1; 
  unsigned int bit6:1; 
  unsigned int bit7:1; 
} _io_reg; 


extern u8 edge_val_gdo0;
extern u8 edge_val_gdo1;

extern u8 gdo0_status;
extern u8 gdo1_status;



#define REGISTER_BIT(rg,bt) ((volatile _io_reg*)&rg)->bit##bt 

#endif
