package hayashi.yuu.register;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeviceData
{
	/**
	 * コンストラクタ：　データコレクタのデータ
	 */
	public DeviceData() {
		deviceName = null;
		typeID = null;
		verAVR = null;
		dateAVR = null;
		verMSP = null;
	}
	
    /**
     * データコレクターのデバイス識別コード
     * （製品のシリアル番号です）
     */
    String deviceID = null;
    
    /**
     * データコレクターのデバイス識別コードを取得する
     * @return　デバイス識別コード（製品のシリアル番号）
     */
	public String getDeviceID() {
		return this.deviceID;
	}

	/**
	 * データコレクターのデバイス識別コードを設定する。
	 * @param deviceID　デバイス識別コード（製品のシリアル番号）
	 */
	public void setDeviceID(String deviceID) {
		this.deviceID = deviceID;
	}

	/**
	 * データコレクターを識別するためにユーザーが定義した名称。
	 * 未定義のときは、NULLとする。
	 */
	String deviceName = null;		// デバイスの定義名称

	/**
	 * このデバイスの名称を取得する。
	 * 名称が未定義の時は、NULLが戻る。
	 * @return	デバイス名称
	 */
	public String getDeviceName() {
		return this.deviceName;
	}

	/**
	 * このデバイスの名称を定義する。
	 * @param deviceName
	 */
	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName;
	}

	String typeID = null;
	
	public String getTypeID() {
		return typeID;
	}

	public void setTypeID(String typeID) {
		this.typeID = typeID;
	}

	/**
	 * このデバイスの「タイプ名」
	 */
	String typeName = "GuardiX OEM";
	
	/**
	 * このデバイスの「タイプ名」を取得する。
	 * @return	タイプ名
	 */
	public String getTypeName() {
		return this.typeName;
	}
	
	/**
	 * ステータス
	 */
	public int status;
	
	public int getStatus() {
		return this.status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public void setStatus(String statusStr) {
    	this.status = Integer.parseInt(statusStr, 16);
	}
	
	public String getStatusName() {
    	if (status == 0x02) {
    		return ("正常");
    	}
    	StringBuffer sbuf = new StringBuffer();
		if ((status & 0x02) == 0) {
			sbuf.append("残データあり ");
		}
		else {
			sbuf.append("残データなし ");
		}
		sbuf.append("[");
		if ((status & 0x01) != 0) {
			sbuf.append("ＲＡＭエラー発生! , ");
		}
		if ((status & 0x04) != 0) {
			sbuf.append("要バッテリー交換! , ");
		}
		if ((status & 0x08) != 0) {
			sbuf.append("メモリーオーバー!");
		}
		sbuf.append("]");
		return sbuf.toString();
	}
	
	/**
	 * AVR version
	 */
	String verAVR = null;

	public String getVerAVR() {
		return this.verAVR;
	}

	public void setVerAVR(String verAVR) {
		this.verAVR = verAVR;
	}
	
	/**
	 * AVR date
	 */
	Date dateAVR = null;

	public Date getDateAVR() {
		return this.dateAVR;
	}

	public void setDateAVR(Date dateAVR) {
		this.dateAVR = dateAVR;
	}

	public void setDateAVR(String dateAVRstr) throws ParseException {
		this.dateAVR = (new SimpleDateFormat("yyyyMMdd")).parse(dateAVRstr);
	}
	
	/**
	 * MSP version
	 */
	String verMSP = null;

	public String getVerMSP() {
		return verMSP;
	}

	public void setVerMSP(String verMSP) {
		this.verMSP = verMSP;
	}
	
	/**
	 * Version Type
	 */
	String verType = null;
	

	public String getVerType() {
		return verType;
	}

	public void setVerType(String verType) {
		this.verType = verType;
	}

	
	/**
	 * 収集データをXML形式にして表現する。
	 * @return	XMLレコード
	 */
	public Element getXmlElement(Document document) {
		Element device = document.createElement("device");
		String idStr = getDeviceID();
		if (idStr != null) {
			device.setAttribute("sn", idStr);
		}
		
		if (getTypeID() != null) {
			Element type = document.createElement("type");
			type.setAttribute("id", getTypeID());
			type.appendChild(document.createTextNode(getTypeName()));
			device.appendChild(type);
		}
		
		if (getVerAVR() != null) {
			Element avr = document.createElement("AVR");
			avr.setAttribute("ver", getVerAVR());
			if (getDateAVR() != null) {
				avr.setAttribute("date", (new SimpleDateFormat("yyyy/MM/dd")).format(getDateAVR()));
			}
			device.appendChild(avr);
		}
		
		if (getVerMSP() != null) {
			Element msp = document.createElement("AVR");
			msp.setAttribute("ver", getVerMSP());
			if (getVerType() != null) {
				msp.setAttribute("type", getVerType());
			}
			device.appendChild(msp);
		}
		
		String name = getDeviceName();
		if (name != null) {
			Element nameEle = document.createElement("name");
			nameEle.appendChild(document.createTextNode(name));
			device.appendChild(nameEle);
		}
    	return device;
	}
}
