#ifndef WAVEVIEWWIDGET_H
#define WAVEVIEWWIDGET_H

#include <QWidget>
#include <vector>
using namespace std;

#include "waveFileEx/waveFileEx.h"
#include "QUtauParameters.h"

struct waveFileDrawPoint{
    double top;
    double bottom;
};

class waveViewWidget : public QWidget
{
    Q_OBJECT
public:
    explicit waveViewWidget(QWidget *parent = 0);

signals:

protected:
    void paintEvent(QPaintEvent *);

public slots:
    void setUtauParameters(QUtauParameters *p);
    void setWaveBuffer(double *buffer, int length);
    void setScaleChange(double scale);

private:
    QUtauParameters currentParameters;

    bool readWaveFile(QString fileName);
    void destroyWave(void);
    void setBuffer(void);

    double scale;
    QImage image;
    waveFileEx wave;
    vector<waveFileDrawPoint> pointBuffer;

    QWidget *parent;
};

#endif // WAVEVIEWWIDGET_H
