#ifndef UTAUSETTINGTABLEWIDGET_H
#define UTAUSETTINGTABLEWIDGET_H

#include <QTableWidget>
#include "QUtauParameters.h"
#include <QLineEdit>

class utauSettingTableWidget : public QTableWidget
{
    Q_OBJECT
public:
    explicit utauSettingTableWidget(QWidget *parent = 0);
    void setSuffixTextObject(QLineEdit *p){suffix = p;}
    void getCurrentParameters(QUtauParameters &p){p = current;}

    void getParametersInRow(int row, QUtauParameters &param);
    bool getParametersByAlias(QString &alias, QUtauParameters &dst);

    QString getDirectoryPath(void){return directoryPath;}

signals:
    void updateWaveView(QUtauParameters *p);
    void enableAnalysis(bool);

public slots:
    void setSettingFilePath(QString *s);
    void searchAndSelectByParameters(QUtauParameters *p);
    void selectionCheck();

private:
    void destroyAllItems(void);
    void setRowHeightAtTime(int);

    QString filePath;
    QString directoryPath;
    QUtauParameters current;

    QLineEdit *suffix;

};

#endif // UTAUSETTINGTABLEWIDGET_H
