#include "VSQNoteManager.h"

NoteManager::~NoteManager(){
    for( vector<NoteEvent*>::iterator i = mNoteList.begin(); i != mNoteList.end(); i++ ){
        if( (*i) != NULL ){
            delete (*i);
        }
    }
}

void NoteManager::RegisterNote( long nTick, int iID ){
    NoteEvent *pNote = new NoteEvent;
    pNote->mTick = nTick;
    pNote->mIsContinuousBack = false;
    pNote->mIsContinuousFront = false;
    pNote->mNextNote = NULL;
    pNote->mPreviousNote = NULL;
    pNote->mLength = 0;
    pNote->mID = iID;

    pNote->mBendDepth = 0;
    pNote->mBendLength = 0;
    pNote->mPortamentoUse = 3;

    pNote->mVibratoDepth.SetValue( 0, 0 );
    pNote->mVibratoRate.SetValue( 0, 0 );

    //UTAU設定用構造体を初期化
    pNote->mSetting.dBaseFrequency = 0.0;
    pNote->mSetting.iConsonant = 0;
    pNote->mSetting.iLeftBlank = 0;
    pNote->mSetting.iVoiceOverlap = INT_MAX;
    pNote->mSetting.iPreUtterance = INT_MAX;
    pNote->mSetting.iRightblank = 0;
    pNote->mSetting.sName = "";

    mNoteList.push_back( pNote );
    mNoteMap.insert(make_pair(iID,pNote));

    return;
}


void NoteManager::SetNoteEvent( int iID, NoteEvent *pNoteEvent ){
    MAP_TYPE<int, NoteEvent *>::iterator i = mNoteMap.find( iID );

    //ハッシュに一致するものがなければ何もしない。
    if( i == mNoteMap.end() ){
        return;
    }

    i->second->mLyric = pNoteEvent->mLyric;
    i->second->mIsContinuousBack = pNoteEvent->mIsContinuousBack;
    i->second->mIsContinuousFront = pNoteEvent->mIsContinuousFront;
    i->second->mLength = pNoteEvent->mLength;
    i->second->mVelocity = pNoteEvent->mVelocity;
    i->second->mNote = pNoteEvent->mNote;
    i->second->mDecay = pNoteEvent->mDecay;
    i->second->mAccent = pNoteEvent->mAccent;

    return;

}

void NoteManager::UnregisterNoteByID( int iTargetID ){
    NoteEvent *pNoteEvent;
    MAP_TYPE<int, NoteEvent *>::iterator i = mNoteMap.find( iTargetID );

    //そんなID知りません
    if( i == mNoteMap.end() ){
        return;
    }
    pNoteEvent = i->second;
    mNoteMap.erase( i );

    for( vector<NoteEvent *>::iterator i = mNoteList.begin(); i != mNoteList.end(); i++ ){
        if( (*i) == pNoteEvent ){
            mNoteList.erase( i );
            break;
        }
    }

    if( pNoteEvent ) delete pNoteEvent;

}

bool NoteManager::SetValue( string key, string value ){
    //ID#の設定
    if( value.find( "ID#" ) == 0 ){
        // valueがID#で始まるのは，[EventList]読み込み時しか起こり得ない
        RegisterNote( atol( key.c_str() ), 
                      atoi( value.substr( 3 ).c_str() ) );
        //TODO: ここで480=ID#0000,ID#0001とかの処理をやるのもアリだな！
    }else if( !mHandle ){
        return SetValueID( key, value );
    }else{
        return SetValueHandle( key, value );
    }

    return true;
}

bool NoteManager::SetValueID( string key, string value ){
    if( mEditTarget == NULL ){
        //読み飛ばし設定
        cout << "warning; VSQNoteManager::SetValueID; cannot find target; key=" << key << endl;
        return true;
    }

    //今回タイプは登録しない。
    if( key.compare( "Type" ) == 0 ){
#ifdef USE_MULTI_SINGER
        // タイプを設定しておく。
        mEditTarget->mType = value;
#else
        //歌手情報の場合該当ノートは使わないので削除
        if( value.compare( "Singer" ) == 0 ){
            UnregisterNoteByID( mCurrentIdOrHandle );
            mCurrentIdOrHandle = -1;
            mEditTarget = NULL;
        }
#endif
        return true;
    }else if( key.compare( "Length" ) == 0 ){
        mEditTarget->mLength = atol( value.c_str() );
        //順番依存でごめん
        mEditTarget->mVibratoDelay = mEditTarget->mLength;
    }else if( key.compare( "Note#" ) == 0 ){
        mEditTarget->mNote = atoi( value.c_str() );
    }else if( key.compare( "Dynamics" ) == 0 ){
        mEditTarget->mVelocity = atoi( value.c_str() );
    }else if( key.compare( "DEMdecGainRate" ) == 0 ){
        mEditTarget->mDecay = atoi( value.c_str() );
    }else if( key.compare( "DEMaccent" ) == 0 ){
        mEditTarget->mAccent = atoi( value.c_str() );
    }else if( key.compare( "VibratoDelay" ) == 0 ){
        mEditTarget->mVibratoDelay = atol( value.c_str() );
    }else if( key.compare( "Lyric" ) == 0 ){
        mEditTarget->mLyric = value;
    }else if( key.compare( "PMBendDepth" ) == 0 ){
        mEditTarget->mBendDepth = atoi( value.c_str() );
    }else if( key.compare( "PMBendLength" ) == 0 ){
        mEditTarget->mBendLength = atoi( value.c_str() );
    }else if( key.compare( "PMbPortamentoUse" ) == 0 ){
        mEditTarget->mPortamentoUse = atoi( value.c_str() );
    }else if( value.find( "h#" ) != string::npos ){
        //ハンドル情報を登録する。
        value = value.substr( 2 );
        int handle = atoi( value.c_str() );
        mHandleToNoteMap.insert( make_pair( handle, mEditTarget ) );
    }else if( key.compare( "PreUtterance" ) == 0 ){
        mEditTarget->mSetting.iPreUtterance = atoi( value.c_str() );
    }else if( key.compare( "VoiceOverlap" ) == 0 ){
        mEditTarget->mSetting.iVoiceOverlap = atoi( value.c_str() );
    }else{
        cout << "warning; don't know property named: " << key.c_str() << endl;
        return true;
    }

    return true;
}

bool NoteManager::SetValueHandle( string key, string value ){
    MAP_TYPE<int, NoteEvent *>::iterator i = mHandleToNoteMap.find( mCurrentIdOrHandle );
    if( i == mHandleToNoteMap.end() ){
        return true;
    }
    mEditTarget = i->second;

    //L0があれば歌詞情報を読み込む
    if( key.compare( "L0" ) == 0 ){
        value = value.substr( 1 );
        value = value.substr( 0, value.find( "\"" ) );
        mEditTarget->mLyric = value;
    //それ以降の歌詞は後ろに付け加える
/*    }else if(key.find("L")==0 && key.compare("Length")!=0){
        value=value.substr(1);
        value=value.substr(0,value.find("\""));
        mEditTarget->sLyric.append(value.c_str());
*/
    //StartDepthの設定
    }else if( key.compare( "StartDepth" ) == 0 ){
        mEditTarget->mVibratoDepth.SetValue( mEditTarget->mVibratoDelay, atoi( value.c_str() ) );

    //StartRateの設定
    }else if( key.compare( "StartRate" ) == 0 ){
        mEditTarget->mVibratoRate.SetValue( mEditTarget->mVibratoDelay, atoi( value.c_str() ) );

    //DepthBPXの設定
    }else if( key.compare( "DepthBPX" ) == 0 ){
        mHandleParseContext.mDepthBPX = value;
        if( mHandleParseContext.ParseVibratoDepth( mEditTarget ) ){
            mHandleParseContext.Reset();
        }

    //RateBPXの設定
    }else if( key.compare( "RateBPX" ) == 0 ){
        mHandleParseContext.mRateBPX = value;
        if( mHandleParseContext.ParseVibratoRate( mEditTarget ) ){
            mHandleParseContext.Reset();
        }

    //DepthBPYの設定
    }else if( key.compare( "DepthBPY" ) == 0 ){
        mHandleParseContext.mDepthBPY = value;
        if( mHandleParseContext.ParseVibratoDepth( mEditTarget ) ){
            mHandleParseContext.Reset();
        }

    //RateBPYの設定
    }else if( key.compare( "RateBPY" ) == 0 ){
        mHandleParseContext.mRateBPY = value;
        if( mHandleParseContext.ParseVibratoRate( mEditTarget ) ){
            mHandleParseContext.Reset();
        }

    }else if( key.compare( "IconID" ) == 0 ){
        mEditTarget->mIconID = value;
    }

    return true;
}

NoteEvent *NoteManager::GetNoteEvent( int iID ){
    MAP_TYPE<int, NoteEvent *>::iterator i = mNoteMap.find( iID );

    //ハッシュに一致するものがなければNULLを返す。
    if( i == mNoteMap.end() ){
        return NULL;
    }

    return i->second;
}

NoteEvent *NoteManager::GetNoteEvent( long nTick ){
    for( vector<NoteEvent *>::iterator i = mNoteList.begin(); i != mNoteList.end(); i++ ){
        if( (*i)->mTick + (*i)->mLength > nTick && nTick >= (*i)->mTick){
            //間に挟まってるなら値を返す。
            return (*i);
        }
    }

    return NULL;
}

NoteEvent *NoteManager::GetNoteEventByFrame( long nFrame ){
    for( vector<NoteEvent *>::iterator i = mNoteList.begin(); i != mNoteList.end(); i++ ){
        if( (*i)->mEndFrame > nFrame && nFrame >= (*i)->mBeginFrame ){
            //間に挟まってるなら値を返す。
            return (*i);
        }
    }

    return NULL;
}

#ifdef _DEBUG
void NoteManager::PrintNote(){
    cout << "NoteManager::PrintNote; NoteList>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" << endl;
    for( int i = 0; i < mNoteList.size(); i++ ){
        NoteEvent *item = mNoteList[i];
#ifdef USE_MULTI_SINGER
        cout << "mType=" << item->mType << "; mID=" << item->mID << "; mSingerIndex=" << item->mSingerIndex << endl;
#else
        cout << "mType=" << item->mType << "; mID=" << item->mID << endl;
#endif
    }
    cout << "NoteManager::PrintNote; NoteList<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<" << endl;
}
#endif

#ifdef USE_MULTI_SINGER
bool NoteManager::CheckContinuity( double dTempo, vector<UTAUManager *> *pUtauManagers, double dFrameShift ){
#else
bool NoteManager::CheckContinuity( double dTempo, UTAUManager *pUtauManager, double dFrameShift ){
#endif
    int count=0;

#ifdef USE_MULTI_SINGER
    int indx_singer = 0;  // 現在適用中の歌手番号デフォルトは，最初に[oto.ini]セクションに現れた原音とする
    UTAUManager *pUtauManager = (*pUtauManagers)[indx_singer];
#endif
    //Noteが一つも登録されていない場合
    if( mNoteList.empty() ){
        return false;
    }

    // 並べ替え
    // 同時刻のイベントであっても，歌手変更イベントが先頭となるよう並べ替える
    int size = mNoteList.size();
    if( size > 1 ){
        bool changed = true;
        while( changed ){
            changed = false;
            NoteEvent *event_last = mNoteList[0];
            for( int i = 1; i < size; i++ ){
                NoteEvent *event_this = mNoteList[i];
                bool sort = false;
                if( event_last->mTick > event_this->mTick ){
                    // 1コ前のnTickの方が，今の位置のnTickより大ならソート
                    sort = true;
                }else if( event_last->mTick == event_this->mTick ){
                    // 1個前と今の位置のnTickが同じで，
                    if( event_this->mType.compare( "Singer" ) == 0 && event_last->mType.compare( "Singer" ) != 0 ){
                        // かつ1コ前がSinger以外，今の位置のがSingerだった場合ソート
                        sort = true;
                    }
                }
                if( sort ){
                    // 入れ替えを実行
                    mNoteList[i] = event_last;
                    mNoteList[i - 1] = event_this;
                    changed = true;
                    // 入れ替えたのでevent_lastは更新不要
                }else{
                    event_last = event_this;
                }
            }
        }
    }

    for( int i = 0; i < mNoteList.size(); i++ ){
        NoteEvent *pPresentNote = mNoteList[i];

#ifdef USE_MULTI_SINGER
        // Singerイベントならindx_singerを更新してcontinue
        if( pPresentNote->mType.compare( "Singer" ) == 0 ){
            MAP_TYPE<string, int>::iterator h_i = mSingerMap.find( pPresentNote->mIconID );
            if( h_i != mSingerMap.end() ){
                indx_singer = h_i->second;
            }else{
                // 歌手不明の場合は，デフォルトの歌手を利用する
                indx_singer = 0;
            }
            // 設定し終えたら役目は終わりなので消しちゃおう．
            UnregisterNoteByID( pPresentNote->mID );
            // イテレータを前に戻す( for 文で進んじゃうから． )
            i--;
            continue;
        }

        // そうでなければ歌手周りの設定をしておく。
        pUtauManager = (*pUtauManagers)[indx_singer];
        pPresentNote->mSingerIndex = indx_singer;
#endif

        //　UTAUを設定
        UTAUSetting *pSetting = pUtauManager->GetDefaultSetting( pPresentNote->mLyric );
        if( pSetting ){
            pPresentNote->mSetting.dBaseFrequency = pSetting->dBaseFrequency;
            pPresentNote->mSetting.iConsonant += pSetting->iConsonant;
            pPresentNote->mSetting.iLeftBlank += pSetting->iLeftBlank;
            pPresentNote->mSetting.iRightblank += pSetting->iRightblank;
            pPresentNote->mLyric = pSetting->sName;

            if( pPresentNote->mSetting.iPreUtterance == INT_MAX ){
                pPresentNote->mSetting.iPreUtterance = pSetting->iPreUtterance;
            }
//          }else{
//                pPresentNote->mSetting.iPreUtterance+=pSetting->iPreUtterance;
//          }

            if( pPresentNote->mSetting.iVoiceOverlap == INT_MAX ){
                pPresentNote->mSetting.iVoiceOverlap = pSetting->iVoiceOverlap;
            }
//          }else{
//                pPresentNote->mSetting.iVoiceOverlap += pSetting->iVoiceOverlap;
//          }

            if( pPresentNote->mSetting.iVoiceOverlap < 5.0 ){
                pPresentNote->mSetting.iVoiceOverlap = 5;
            }

            count++;
        }else{
            cout << "warning; lyric: " << pPresentNote->mLyric << " is not registerd in voice DB." << endl;
            // memset使うとstringがヤバイ気がするので，ちまちま設定
            pPresentNote->mSetting.dBaseFrequency = 0.0;
            pPresentNote->mSetting.iConsonant = 0;
            pPresentNote->mSetting.iLeftBlank = 0;
            pPresentNote->mSetting.iPreUtterance = 0;
            pPresentNote->mSetting.iRightblank = 0;
            pPresentNote->mSetting.iVoiceOverlap = 0;
            pPresentNote->mSetting.sName = "";
        }
    }

    //原音設定の存在するNoteの数がゼロだった。
    if( count == 0 ){
        cout << "No note has UTAU-Setting. v.Connect failed synthesis." << endl;
        return false;
    }

    for( vector<NoteEvent *>::iterator i = mNoteList.begin(); i != mNoteList.end(); i++ ){

        NoteEvent *pPresentNote = (*i);

        if( pPresentNote == NULL ){
            break;
        }

        //ノート開始位置を計算
        //(音符の位置)=(Tick指定位置)－(先行発音分)＊(Velocityによる比率)
        //(音符の長さ)=(Tick指定長)＋(先行発音分)＊(Velocityによる比率)＋(次の音符のオーバーラップ指定分)－(次の音符の先行発音分)＊(Velocityによる比率)
        pPresentNote->mBeginFrame = (long)((double)(pPresentNote->mTick) / TICK_PER_SEC / dTempo * 1000.0 / dFrameShift
                                    - (double)(pPresentNote->mSetting.iPreUtterance) / dFrameShift * pow( 2.0, (64.0 - (double)(pPresentNote->mVelocity)) / 64.0 ));

        long nFrameLength = (long)((double)(pPresentNote->mLength) / TICK_PER_SEC / dTempo * 1000.0 / dFrameShift
                                + (double)(pPresentNote->mSetting.iPreUtterance) / dFrameShift * pow( 2.0, (64.0 - (double)(pPresentNote->mVelocity)) / 64.0 ));

        //後ろをチェックしていく。
        if( ++i != mNoteList.end() ){
            NoteEvent *pNextNote = (*i);

            // 次の音符との距離が20ms以下ならば連続と判断する
            double msec_present_note_end = (pPresentNote->mTick + pPresentNote->mLength) / TICK_PER_SEC / dTempo * 1000.0;
            double msec_next_note_start = pNextNote->mTick / TICK_PER_SEC / dTempo * 1000.0 - pNextNote->mSetting.iPreUtterance;
            // 次の音符の先頭と，現在の音符の末尾との時間差(msec)
            double msec_delta = msec_next_note_start - msec_present_note_end;
            if( msec_delta <= 20.0 ){
                pPresentNote->mIsContinuousBack = true;
                pNextNote->mIsContinuousFront = true;
                pPresentNote->mNextNote = pNextNote;
                pNextNote->mPreviousNote = pPresentNote;

                nFrameLength += (long)((double)(pNextNote->mSetting.iVoiceOverlap) / dFrameShift
                            - (double)(pNextNote->mSetting.iPreUtterance) / dFrameShift * pow( 2.0, (64.0 - (double)(pNextNote->mVelocity)) / 64.0 ));
            }
        }

        pPresentNote->mEndFrame = pPresentNote->mBeginFrame + nFrameLength;
        i--;

        //位置と長さを計算
    }
    return true;
}

long NoteManager::GetEndID(){
    if( mNoteList.empty() ){
        return -1;
    }

    vector<NoteEvent *>::iterator i = mNoteList.end();

    if( i == mNoteList.begin() ){
        return -1;
    }
    i--;
    return (*(i))->mID;
}

long NoteManager::GetBeginFrame(){
    if( mNoteList.empty() ){
        return -1;
    }

    return (*mNoteList.begin())->mBeginFrame;
}

long NoteManager::GetBeginTick(){
    if( mNoteList.empty() ){
        return -1;
    }

    return (*mNoteList.begin())->mTick;
}

long NoteManager::GetEndFrame(){
    if( mNoteList.empty() ){
        return -1;
    }
    
    vector<NoteEvent *>::iterator i = mNoteList.end();

    if( i == mNoteList.begin() ){
        return -1;
    }
    i--;
    return (*i)->mEndFrame;
}
