#ifndef QMYGRAPHWIDGET_H
#define QMYGRAPHWIDGET_H

#include <QWidget>

#include <vector>
using namespace std;

class QMyGraphWidget : public QWidget
{
    Q_OBJECT

public:
    enum graphStyle{
        linearGraph,
        logGraph
    };

public:
    explicit QMyGraphWidget(QWidget *parent = 0);
    ~QMyGraphWidget();

    void setGraphStyle(graphStyle style){this->style = style;}
    void setGraphStyle(graphStyle style, double min, double max){setRange(min,max); setGraphStyle(style);}
    void setRange(double min, double max){minValue = min; maxValue = max;}

    void addGraph(double* graph, int length);
    void destroyGraphs(void);

public slots:
    void setScale(double scale){this->scale = scale; resize(maxLength * scale, height());}


signals:

protected:
    virtual void paintEvent(QPaintEvent *);

    QWidget *parent;
    graphStyle style;

    double minValue;
    double maxValue;
    double scale;

    vector<double*> graphs;
    vector<int> graphLength;
    int maxLength;

private:
    int getPosition(double value);
    void drawGridLine(QPainter *, QPaintEvent *);
    void drawHorizontalLineLinear(QPainter *, QPaintEvent *);
    void drawHorizontalLineLog(QPainter *, QPaintEvent *);

public slots:

};

#endif // QMYGRAPHWIDGET_H
