// eXgvO
// e֐̏ڍׂapi.txtQl
// V֐̏ڍׂapi0.0.3.txtQl

#include <stdio.h>
#include <stdlib.h>

#include <windows.h>

#include "world.h"
#include "wavread.h"

#include <math.h>

// ̓Vtg [msec]
#define FRAMEPERIOD 1.0

#pragma comment(lib, "winmm.lib")

int main(int argc, char *argv[])
{
	int i;

	double *x,*f0,*t,*y;
	double **specgram;
	double **aperiodicity;
	int fftl;

	int signalLen;
	int tLen, cLen;

	if(argc != 2 && argc != 3) 
	{
		printf("error: ̐słD\n");
		return 0;
	}

	FILE *fp;

	int fs, nbit;
	x = wavread(argv[1], &fs, &nbit, &signalLen);
	if(x == NULL)
	{
		printf("error: w肳ꂽt@C݂͑܂D\n");
		return 0;
	}

	printf("File information\n");
	printf("Sampling : %d Hz %d Bit\n", fs, nbit);
	printf("Length %d [sample]\n", signalLen);
	printf("Length %f [sec]\n", (double)signalLen/(double)fs);

	// F0͉Tv邩OɌvZD
	tLen = getSamplesForDIO(fs, signalLen, FRAMEPERIOD);
	f0 = (double *)malloc(sizeof(double)*tLen);
	t  = (double *)malloc(sizeof(double)*tLen);
	y  = (double *)malloc(sizeof(double)*signalLen);
	// f0 estimation by DIO
	DWORD elapsedTime;

	printf("\nAnalysis\n");
	elapsedTime = timeGetTime();
	dio(x, signalLen, fs, FRAMEPERIOD, t, f0);
	printf("DIO: %d [msec]\n", timeGetTime() - elapsedTime);

	fftl = getFFTLengthForStar(fs);
	cLen = getBands_v3(fs);

	specgram		= (double **)malloc(sizeof(double *) * tLen);
	aperiodicity	= (double **)malloc(sizeof(double *) * tLen);
	for(i = 0;i < tLen;i++)
	{
		specgram[i]		= (double *)malloc(sizeof(double) * (fftl+1) );
		aperiodicity[i] = (double *)malloc(sizeof(double) * cLen);
	}

	// XyNg̕
	elapsedTime = timeGetTime();
	star(x, signalLen, fs, t, f0, specgram);
	printf("STAR: %d [msec]\n", timeGetTime() - elapsedTime);

	// wW̕

	double targetF0;
	elapsedTime = timeGetTime();
//	platinum(fs, f0, tLen, aperiodicity);
	// Version 0.0.3
	aperiodicityRatio_v3(x, signalLen, fs, f0, tLen, FRAMEPERIOD, aperiodicity, &targetF0);
	printf("PLATINUM: %d [msec]\n", timeGetTime() - elapsedTime);

	// ӁI
	// SĂ͂̕܂ŁCF0͑삵ȂƁD

	// ̑OF0̑
	if(argc == 3)
	{
		double shift;
		shift = atof(argv[2]);
		for(i = 0;i < tLen;i++)
		{
			f0[i] *= shift;
		}
	}

	// 
	printf("\nSynthesis\n");
	elapsedTime = timeGetTime();
//	synthesis(f0, tLen, specgram, aperiodicity, fftl, FRAMEPERIOD, fs, y, signalLen);
	// Version 0.0.3
	synthesis_ap(f0, tLen, specgram, fftl, aperiodicity, cLen, targetF0, FRAMEPERIOD, fs, y, signalLen);
	printf("WORLD: %d [msec]\n", timeGetTime() - elapsedTime);

	// t@C̏o (eɂ͊֌WȂ)
	char header[44];
	short *output;
	double maxAmp;
	output = (short *)malloc(sizeof(short) * signalLen);
	// U̐K
	maxAmp = 0.0;
	for(i = 0;i < signalLen;i++)
	{
		maxAmp = maxAmp < abs(y[i]) ? abs(y[i]) : maxAmp;
	}
	for(i = 0;i < signalLen;i++)
	{
		output[i] = (short)(32768.0*(y[i]*0.8/maxAmp));
	}

	fp = fopen(argv[1], "r");
	
	fread(header, sizeof(char), 44, fp);
	fclose(fp);

	fp = fopen("output.wav","wb");
	fwrite(header, sizeof(char), 44, fp);
	fwrite(output, sizeof(short), signalLen, fp);
	fclose(fp);
	free(output);

	printf("complete.\n");

	free(x); free(t); free(f0); free(y);
	for(i = 0;i < tLen;i++)
	{
		free(specgram[i]);
		free(aperiodicity[i]);
	}

	return 0;
}