/*
 *
 *    standTexture.h
 *                              (c) HAL 2010-           
 *
 *  This file is a part of STAND Library.
 * standTexture is a structure that contains
 * frequency transform functions and spectral filter.
 *
 * These files are distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
#ifndef __standTexture_h__
#define __standTexture_h__

#include "stand.h"
#include "runtimeOptions.h"
#define MAX_LENGTH 4096
#define DEFAULT_F0 440.0

class standTexture{
public:
    standTexture();
    ~standTexture();

    bool readTexture( string_t input, runtimeOptions& options );
    bool setTexture( double* trans_src, double* filter_src, double f0_src, int length_src );
    void getTexturePointer( double** trans_dst, double** filter_dst, double* f0, int* length_dst );
    bool setPlainTexture( int length_src );

    void combine( standTexture* tex1, standTexture* tex2, double rate );

private:
    double *trans;
    double *filter;
    double f0Base;
    int    length;
};

extern double interpolateArray( double x, double *p );
extern void applyStretching( double *T, double *target, int length );

#endif
