/*
 *
 *    corpusManager.cpp
 *                        (c) HAL 2010-
 *
 *  This files is a part of v.Connect.
 * corpusManager is a class that controls corpus based on UTAU.
 * This class convert UTAU WAVE corpus into WORLD specgrams.
 *
 * These files are distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
#include "corpusManager.h"

corpusManager::~corpusManager()
{
    map_t<string_t, standData*>::iterator i;
    map_t<string_t, standTexture*>::iterator j;
    for( i = objectMap.begin(); i != objectMap.end(); i++ ){
        SAFE_DELETE( (i->second)->specgram );
        SAFE_DELETE( i->second );
    }
    for( j = textureMap.begin(); j != textureMap.end(); j++ ){
        SAFE_DELETE( j->second );
    }
    
}

standData* corpusManager::getStandData( string_t lyric, runtimeOptions& options)
{
    standData *ret = NULL;
#ifdef WIN32
    // まず standData の有無をチェック．
    if(hMutex)
        WaitForSingleObject(hMutex, INFINITE);
#endif

    map_t<string_t, standData*>::iterator i;
    map_t<string_t, standTexture*>::iterator j;
    i = objectMap.find( lyric );
    string_t alphabet, vtd_path;
    bool fast = options.fast;
    if( i != objectMap.end() ){

#ifdef WIN32
        // うーん．
        if(hMutex)
            ReleaseMutex(hMutex);
        // 処理中は待つ．
        if(i->second->isProcessing){
            WaitForSingleObject(i->second->waitHandle, INFINITE);
            CloseHandle(i->second->waitHandle);
            i->second->waitHandle = 0;
        }
#endif

        // 有効性チェック．
        if(i->second->isValid){
            ret = i->second;
        }else{
            ret = NULL;
        }
    }else{
        utauParameters parameters;
        standData* target = new standData;
        // ハッシュには先に突っ込んでしまう．
        objectMap.insert( make_pair( lyric, target ) );
#ifdef WIN32
        target->isProcessing = true;
        target->waitHandle = CreateEvent(NULL,TRUE,FALSE,NULL);
        if(hMutex)
            ReleaseMutex(hMutex);
#endif

        if( voiceDB->getUtauParameters( parameters, lyric ) == 0 ){
            // ダメなので無効なデータを登録したまま，イベントを無効化．
            target->isValid = false;
#ifdef WIN32
            target->isProcessing = false;
            CloseHandle(target->waitHandle);
            target->waitHandle = 0;
#endif
            return NULL;
        }

        target->specgram = new standSpecgram;
        target->texture = NULL;

        int check;

        check = target->specgram->computeWaveFile( voicePath + parameters.fileName, parameters, fast ) ;
        if( check ){
            alphabet = vowels.getAlphabet( lyric );
            j = textureMap.find( alphabet );
            if( j == textureMap.end() ){
                target->texture = new standTexture;
                if( alphabet.compare( _T("") ) != 0 ){
                    vtd_path = voicePath + alphabet + _T(".vtd");
                    if( !target->texture->readTexture( vtd_path, options ) ){
                        target->texture->setPlainTexture( target->specgram->getFFTLength() );
                    }
                }else{
                    target->texture->setPlainTexture( target->specgram->getFFTLength() );
                }
                textureMap.insert( make_pair( alphabet, target->texture ) );
            }else{
                target->texture = j->second;
            }
            target->isValid = true;
            ret = target;
        }
        target->isProcessing = false;
        // 寝てる子がいたら起こす．
        SetEvent(target->waitHandle);
    }
    return ret;
}

/* うーん… */
standTexture* corpusManager::getClearness( string_t lyric, runtimeOptions& options )
{
    string_t tmp, vtdPath;
    standTexture* p = NULL;
    map_t<string_t, standTexture*>::iterator i;

    tmp = vowels.getAlphabet( lyric );
    i = textureMap.find( tmp + _T("_cle") );
    if( i == textureMap.end() && tmp.compare( _T("") ) != 0 ){
        p = new standTexture;
        vtdPath = voicePath + tmp + _T("_cle.vtd");
        if( !p->readTexture( vtdPath, options ) )
            p->setPlainTexture( 1024 );
        textureMap.insert( make_pair( tmp + _T("_cle"), p ) );
    } else if( i != textureMap.end() ){
        p = i->second;
    }
    return p;
}

void corpusManager::setVoiceDB( utauVoiceDataBase* p, runtimeOptions& options )
{
    string_t tmp;
    voiceDB = p;
    if(p){
        p->getVoicePath( voicePath );
    }
    tmp = voicePath + _T("vowelTable.txt");
    vowels.readVowelTable( tmp, options );
}
