﻿/*
 * AttachedCurve.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

using Boare.Lib.Vsq;
using bocoree;

namespace Boare.Cadencii {

    public class AttachedCurve : ICloneable {
        public Vector<BezierCurves> Curves = new Vector<BezierCurves>();

        public void Add( BezierCurves item ) {
            add( item );
        }

        public void add( BezierCurves item ) {
            Curves.add( item );
        }

        public void RemoveAt( int index ) {
            Curves.removeElementAt( index );
        }

        public void Insert( int position, BezierCurves attached_curve ) {
            Curves.insertElementAt( attached_curve, position );
        }

        public object Clone() {
            AttachedCurve ret = new AttachedCurve();
            ret.Curves.clear();
            for ( int i = 0; i < Curves.size(); i++ ) {
                ret.Curves.add( (BezierCurves)Curves.get( i ).Clone() );
            }
            return ret;
        }

        public BezierCurves this[int index] {
            get {
                return get( index );
            }
            set {
                set( index, value );
            }
        }

        public BezierCurves get( int index ) {
            return Curves.get( index );
        }

        public void set( int index, BezierCurves value ) {
            Curves.set( index, value );
        }
    }

}
